/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.CollectorProperties;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

@Singleton
public class BslProjectPreferences
implements BslPreferences,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String TRANSLATOR_PROPERTIES_NODE = "translatorProperties";
    public static final String COLLECTOR_PROPERTIES_NODE = "collectorProperties";
    private Map<IProject, TranslatorProperties> translatorProperties = Maps.newHashMap();
    private Map<IProject, CollectorProperties> collectorProperties = Maps.newHashMap();
    private ReentrantReadWriteLock readWriteLockForTranslatorProperties = new ReentrantReadWriteLock();
    private IResourceChangeListener projectChangeListener = new ProjectChangeListener();
    private IEclipsePreferences.INodeChangeListener nodeChangeListener = new NodeChangeListener();

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 6);
    }

    public void deactivate() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public TranslatorProperties getTranslatorProperties(IProject project) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslatorProperties.readLock();
        try {
            readLock.lock();
            TranslatorProperties properties = this.translatorProperties.get(project);
            if (properties != null) {
                TranslatorProperties translatorProperties = properties;
                return translatorProperties;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLockForTranslatorProperties.writeLock();
        try {
            writeLock.lock();
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
            TranslatorProperties properties = new TranslatorProperties(project);
            if (rootNode != null) {
                IEclipsePreferences propNode = (IEclipsePreferences)rootNode.node(TRANSLATOR_PROPERTIES_NODE);
                this.addPreferenceChangeListener(rootNode);
                this.addNodeChangeListener(rootNode);
                properties.read((Preferences)propNode);
                this.addPreferenceChangeListener(propNode);
            }
            this.translatorProperties.put(project, properties);
            TranslatorProperties translatorProperties = properties;
            return translatorProperties;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public CollectorProperties getCollectorProperties(IProject project) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslatorProperties.readLock();
        try {
            readLock.lock();
            CollectorProperties properties = this.collectorProperties.get(project);
            if (properties != null) {
                CollectorProperties collectorProperties = properties;
                return collectorProperties;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLockForTranslatorProperties.writeLock();
        try {
            writeLock.lock();
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
            CollectorProperties properties = new CollectorProperties(project);
            if (rootNode != null) {
                IEclipsePreferences propNode = (IEclipsePreferences)rootNode.node(COLLECTOR_PROPERTIES_NODE);
                this.addPreferenceChangeListener(rootNode);
                this.addNodeChangeListener(rootNode);
                properties.read((Preferences)propNode);
                this.addPreferenceChangeListener(propNode);
            }
            this.collectorProperties.put(project, properties);
            CollectorProperties collectorProperties = properties;
            return collectorProperties;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getNode().name().equals(TRANSLATOR_PROPERTIES_NODE) || event.getNode().name().equals(COLLECTOR_PROPERTIES_NODE)) {
            String[] segments = event.getNode().absolutePath().split("/");
            if (segments.length < 3) {
                return;
            }
            String projectName = segments[2];
            if (StringUtils.isNotEmpty((String)projectName)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (event.getNode().name().equals(TRANSLATOR_PROPERTIES_NODE)) {
                    this.updateTranslatorProperties(project, event.getNode());
                } else if (event.getNode().name().equals(COLLECTOR_PROPERTIES_NODE)) {
                    this.updateCollectorProperties(project, event.getNode());
                }
            }
        }
    }

    private void updateTranslatorProperties(IProject project, Preferences pref) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslatorProperties.readLock();
        try {
            readLock.lock();
            TranslatorProperties properties = this.translatorProperties.get(project);
            if (properties != null) {
                properties.read(pref);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void updateCollectorProperties(IProject project, Preferences pref) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslatorProperties.readLock();
        try {
            readLock.lock();
            CollectorProperties properties = this.collectorProperties.get(project);
            if (properties != null) {
                properties.read(pref);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void updateProperties(IProject project) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslatorProperties.readLock();
        try {
            readLock.lock();
            TranslatorProperties translator = this.translatorProperties.get(project);
            CollectorProperties collector = this.collectorProperties.get(project);
            CollectorProperties validation = this.collectorProperties.get(project);
            if (translator != null || collector != null || validation != null) {
                IEclipsePreferences propNode;
                ProjectScope projectScope = new ProjectScope(project);
                IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
                if (rootNode != null && translator != null) {
                    propNode = (IEclipsePreferences)rootNode.node(TRANSLATOR_PROPERTIES_NODE);
                    this.addPreferenceChangeListener(rootNode);
                    this.addNodeChangeListener(rootNode);
                    translator.read((Preferences)propNode);
                    this.addPreferenceChangeListener(propNode);
                } else if (translator != null) {
                    this.translatorProperties.remove(project);
                }
                if (rootNode != null && collector != null) {
                    propNode = (IEclipsePreferences)rootNode.node(COLLECTOR_PROPERTIES_NODE);
                    this.addPreferenceChangeListener(rootNode);
                    this.addNodeChangeListener(rootNode);
                    collector.read((Preferences)propNode);
                    this.addPreferenceChangeListener(propNode);
                } else if (collector != null) {
                    this.collectorProperties.remove(project);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void removeProperties(IProject project) {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLockForTranslatorProperties.writeLock();
        try {
            writeLock.lock();
            this.translatorProperties.remove(project);
            this.collectorProperties.remove(project);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void addPreferenceChangeListener(IEclipsePreferences projectNode) {
        projectNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private void addNodeChangeListener(IEclipsePreferences projectNode) {
        projectNode.addNodeChangeListener(this.nodeChangeListener);
    }

    private class NodeChangeListener
    implements IEclipsePreferences.INodeChangeListener {
        private NodeChangeListener() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            IProject project = this.getProject(event);
            if (project != null) {
                BslProjectPreferences.this.updateProperties(project);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            IProject project = this.getProject(event);
            if (project != null) {
                BslProjectPreferences.this.removeProperties(project);
            }
        }

        private IProject getProject(IEclipsePreferences.NodeChangeEvent event) {
            Preferences child = event.getChild();
            String name = child.name();
            String projectName = null;
            if ("com.e1c.langtool.v8.dt.bsl".equals(name)) {
                Preferences parent = event.getParent();
                if (parent.parent() != null && "project".equals(parent.parent().name())) {
                    projectName = parent.name();
                }
            } else if ("project".equals(event.getParent().name())) {
                projectName = name;
            } else if (BslProjectPreferences.TRANSLATOR_PROPERTIES_NODE.equals(name) || BslProjectPreferences.COLLECTOR_PROPERTIES_NODE.equals(name)) {
                Preferences parent = event.getParent();
                try {
                    if (parent.parent() != null) {
                        projectName = parent.parent().name();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotEmpty(projectName)) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            return null;
        }
    }

    private class ProjectChangeListener
    implements IResourceChangeListener {
        private ProjectChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource res = event.getResource();
            if ((event.getType() == 2 || event.getType() == 4) && res instanceof IProject) {
                BslProjectPreferences.this.removeProperties((IProject)res);
            }
        }
    }
}

