/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl;

import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.ContextDef;
import com._1c.g5.v8.dt.mcore.Ctor;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.Method;
import com._1c.g5.v8.dt.mcore.ParamSet;
import com._1c.g5.v8.dt.mcore.Parameter;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.Type;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.TypeSet;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.IEObjectProvider;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.storage.AbstractContextDefCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.IEObjectDescription;

public class ContextDefExternalTranslationProvider
extends AbstractContextDefCache
implements IExternalTranslationProvider {
    private static final String METADATA_OBJECT_ENUMERATED_PROPERTIES = "MetadataObjectEnumeratedProperties";
    private static final String LANGUAGE_CODE_EN = "en";
    private static final String LANGUAGE_CODE_RU = "ru";
    private static final Set<String> LANGUAGE_CODES = ImmutableSet.of((Object)"en", (Object)"ru");
    private static final Map<String, String> LANGUAGES = ImmutableMap.of((Object)"en", (Object)ScriptVariant.ENGLISH.getName(), (Object)"ru", (Object)ScriptVariant.RUSSIAN.getName());
    private static final long EXPARATION_MINUTES = 10L;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    private RemovalListener<Boolean, ContextDefCache> listener = new CacheRemovalListener();
    private final Cache<Boolean, ContextDefCache> cache = this.newCache();

    public String getTranslationItemImageName() {
        return "icons/obj16/context_def.png";
    }

    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        if (StringUtils.isNotEmpty((String)text)) {
            ContextDefCache contextDef = null;
            if (LANGUAGE_CODE_EN.equalsIgnoreCase(sourceLocale) && LANGUAGE_CODE_RU.equalsIgnoreCase(targetLocale)) {
                contextDef = this.getContextDefCache(true);
            } else if (LANGUAGE_CODE_RU.equalsIgnoreCase(sourceLocale) && LANGUAGE_CODE_EN.equalsIgnoreCase(targetLocale)) {
                contextDef = this.getContextDefCache(false);
            }
            if (contextDef == null) {
                return Collections.emptyList();
            }
            List<String> translations = contextDef.getObjectTranslations(text);
            if (!translations.isEmpty()) {
                return Lists.newArrayList(translations);
            }
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        texts.forEach(text -> {
            List<String> list = res.put((String)text, this.translate((String)text, sourceLocale, targetLocale));
        });
        return res;
    }

    public Set<String> getLanguageCodes() {
        return LANGUAGE_CODES;
    }

    public Map<String, String> getLanguages(String targetLocale) {
        return LANGUAGES;
    }

    public ContextDefCache getContextDefCache(boolean isRussian) {
        try {
            return (ContextDefCache)this.cache.get((Object)isRussian, () -> {
                ContextDefCache contextDef = new ContextDefCache();
                try {
                    contextDef.initialize(isRussian);
                }
                catch (Exception e) {
                    BslPlugin.logError(e);
                }
                return contextDef;
            });
        }
        catch (ExecutionException e) {
            BslPlugin.logError(e);
            return null;
        }
    }

    private Cache<Boolean, ContextDefCache> newCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(this.listener).build();
    }

    private final class CacheRemovalListener
    implements RemovalListener<Boolean, ContextDefCache> {
        private CacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<Boolean, ContextDefCache> notification) {
            ((ContextDefCache)notification.getValue()).clear();
        }
    }

    private final class ContextDefCache {
        private Map<String, List<String>> objects = null;
        private volatile boolean initialized = false;

        private ContextDefCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialize(boolean isRussian) {
            if (!this.initialized) {
                ContextDefCache contextDefCache = this;
                synchronized (contextDefCache) {
                    this.init(isRussian);
                    this.initialized = true;
                }
            }
        }

        public synchronized void clear() {
            this.checkAccess();
            this.initialized = false;
            this.objects = null;
        }

        public List<String> getObjectTranslations(String name) {
            if (name == null) {
                return Collections.emptyList();
            }
            this.checkAccess();
            List<String> translations = this.objects.get(name);
            if (translations != null) {
                return translations;
            }
            return Collections.emptyList();
        }

        private void init(boolean isRussian) {
            Type object;
            ContextDef contexDef;
            EObject object2;
            IEObjectDescription item2;
            if (this.initialized) {
                return;
            }
            EObject context = this.getMaxProjectContext();
            IEObjectProvider provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.TYPE_ITEM, Version.LATEST);
            Iterable items = provider.getEObjectDescriptions(null);
            TreeMap<String, Map<String, Integer>> objectsData = new TreeMap<String, Map<String, Integer>>(String.CASE_INSENSITIVE_ORDER);
            TreeSet<String> processedTypes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (IEObjectDescription item2 : items) {
                String typeName;
                object2 = EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context);
                if (object2 instanceof Type) {
                    Type typeObject = (Type)object2;
                    this.process(typeObject, objectsData, isRussian);
                    typeName = McoreUtil.getTypeName((TypeItem)typeObject);
                    if (typeName == null) continue;
                    processedTypes.add(typeName);
                    continue;
                }
                if (!(object2 instanceof TypeSet)) continue;
                TypeSet typeSet = (TypeSet)object2;
                this.appendTranslation(objectsData, (DuallyNamedElement)typeSet, isRussian);
                typeName = McoreUtil.getTypeName((TypeItem)typeSet);
                if (typeName != null) {
                    processedTypes.add(typeName);
                }
                for (Type type : typeSet.getTypes()) {
                    this.process(type, objectsData, isRussian);
                    typeName = McoreUtil.getTypeName((TypeItem)type);
                    if (typeName == null) continue;
                    processedTypes.add(typeName);
                }
            }
            provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.METHOD, Version.LATEST);
            items = provider.getEObjectDescriptions(null);
            for (IEObjectDescription item2 : items) {
                object2 = EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context);
                if (!(object2 instanceof Method)) continue;
                Method method = (Method)object2;
                this.appendTranslation(objectsData, (DuallyNamedElement)method, isRussian);
                for (Object paramSet : method.getParamSet()) {
                    for (Parameter param : paramSet.getParams()) {
                        this.appendTranslation(objectsData, (DuallyNamedElement)param, isRussian);
                    }
                }
            }
            provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.PROPERTY, Version.LATEST);
            items = provider.getEObjectDescriptions(null);
            for (IEObjectDescription item2 : items) {
                object2 = EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context);
                if (!(object2 instanceof Property)) continue;
                Property property = (Property)object2;
                this.appendTranslation(objectsData, (DuallyNamedElement)property, isRussian);
                this.process(property, objectsData, processedTypes, isRussian, context);
            }
            provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.TYPE_ITEM, Version.LATEST);
            item2 = provider.getEObjectDescription(ContextDefExternalTranslationProvider.METADATA_OBJECT_ENUMERATED_PROPERTIES);
            if (item2 != null && (contexDef = (object = (Type)EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context)).getContextDef()) != null) {
                for (Property property : contexDef.allProperties()) {
                    this.process(property, objectsData, processedTypes, isRussian, context);
                }
            }
            this.appendExtraTranslation(objectsData, isRussian);
            TreeMap<String, List<String>> objectBuilder = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry entry : objectsData.entrySet()) {
                List value = ((Map)entry.getValue()).entrySet().stream().sorted((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue()).map(Map.Entry::getKey).collect(Collectors.toList());
                objectBuilder.put((String)entry.getKey(), value);
            }
            this.objects = objectBuilder;
        }

        private void process(Property property, Map<String, Map<String, Integer>> objectsData, Set<String> processedTypes, boolean isRussian, EObject context) {
            if (property.getTypeContainer() == null) {
                return;
            }
            for (TypeItem propertyType : property.getTypes()) {
                String typeName;
                EObject resolvedPropertyType = EcoreUtil.resolve((EObject)propertyType, (EObject)context);
                if (resolvedPropertyType instanceof Type) {
                    Type typeObject = (Type)resolvedPropertyType;
                    typeName = McoreUtil.getTypeName((TypeItem)typeObject);
                    if (typeName == null || processedTypes.contains(typeName)) continue;
                    this.process(typeObject, objectsData, isRussian);
                    continue;
                }
                if (!(resolvedPropertyType instanceof TypeSet)) continue;
                TypeSet typeSet = (TypeSet)resolvedPropertyType;
                typeName = McoreUtil.getTypeName((TypeItem)typeSet);
                if (typeName != null && !processedTypes.contains(typeName)) {
                    this.appendTranslation(objectsData, (DuallyNamedElement)typeSet, isRussian);
                }
                for (Type type : typeSet.getTypes()) {
                    typeName = McoreUtil.getTypeName((TypeItem)type);
                    if (typeName == null || processedTypes.contains(typeName)) continue;
                    this.process(type, objectsData, isRussian);
                }
            }
        }

        private Map<String, Integer> createUsageData(String key) {
            return new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        }

        private void process(Type type, Map<String, Map<String, Integer>> data, boolean isRussian) {
            this.appendTranslation(data, (DuallyNamedElement)type, isRussian);
            for (Ctor ctor : type.getCtors()) {
                for (Parameter param : ctor.getParams()) {
                    this.appendTranslation(data, (DuallyNamedElement)param, isRussian);
                }
            }
            ContextDef contextDef = type.getContextDef();
            if (contextDef == null) {
                return;
            }
            for (Event event : type.allEvents()) {
                this.appendTranslation(data, (DuallyNamedElement)event, isRussian);
                for (ParamSet paramSet : event.getParamSet()) {
                    for (Parameter param : paramSet.getParams()) {
                        this.appendTranslation(data, (DuallyNamedElement)param, isRussian);
                    }
                }
            }
            this.process(contextDef, data, isRussian);
        }

        private void process(ContextDef contextDef, Map<String, Map<String, Integer>> data, boolean isRussian) {
            for (Property property : contextDef.allProperties()) {
                this.appendTranslation(data, (DuallyNamedElement)property, isRussian);
            }
            for (Method method : contextDef.allMethods()) {
                this.appendTranslation(data, (DuallyNamedElement)method, isRussian);
                for (ParamSet paramSet : method.getParamSet()) {
                    for (Parameter param : paramSet.getParams()) {
                        this.appendTranslation(data, (DuallyNamedElement)param, isRussian);
                    }
                }
            }
        }

        private void appendTranslation(Map<String, Map<String, Integer>> data, DuallyNamedElement element, boolean isRussian) {
            String source = isRussian ? element.getName() : element.getNameRu();
            String translation = isRussian ? element.getNameRu() : element.getName();
            this.process(data, source, translation);
        }

        private void appendExtraTranslation(Map<String, Map<String, Integer>> data, boolean isRussian) {
            Map enumTokens = ContextDefExternalTranslationProvider.this.getExtraTerms(!isRussian);
            for (Map.Entry element : enumTokens.entrySet()) {
                this.process(data, (String)element.getKey(), (String)element.getValue());
            }
        }

        private void process(Map<String, Map<String, Integer>> data, String source, String translation) {
            if (StringUtils.isNullOrEmpty((String)source) || StringUtils.isNullOrEmpty((String)translation) || source.equalsIgnoreCase(translation)) {
                return;
            }
            source = source.trim();
            translation = translation.trim();
            Map translations = data.computeIfAbsent(source, this::createUsageData);
            int count = translations.computeIfAbsent(translation, t -> 0);
            translations.put(translation, count + 1);
        }

        private EObject getMaxProjectContext() {
            IV8Project v8Project = null;
            Collection projects = ContextDefExternalTranslationProvider.this.v8ProjectManager.getProjects();
            for (IV8Project project : projects) {
                if (v8Project != null && !project.getVersion().isGreaterThan(v8Project.getVersion())) continue;
                v8Project = project;
            }
            if (v8Project != null) {
                return v8Project.getDefaultLanguage();
            }
            return null;
        }

        private void checkAccess() {
            if (!this.initialized) {
                throw new IllegalAccessError("Cache is not initialized yet.");
            }
        }
    }
}

