/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.sync;

import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.resource.BslResolveCrossReferencesJob;
import com._1c.g5.v8.dt.bsl.resource.BslResource;
import com._1c.g5.v8.dt.bsl.util.BslUtil;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com.e1c.g5.dt.core.api.naming.INamingService;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.ModuleCachedLoader;
import com.e1c.langtool.v8.dt.bsl.translator.ModuleTextEditor;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.ExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.CancelIndicator;

public class ModuleSynchronizer
extends ExternalPropertySynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.bsl.Module";
    @Inject
    private ModuleCachedLoader moduleCachedLoader;
    @Inject
    private IBmModelManager bmModelManager;
    @Inject
    private INamingService namingService;

    public String getId() {
        return ID;
    }

    protected IStatus synchronize(IFile sourceFile, EObject owner, IProject target, IFile targetFile, BmSyncSession bmSession, IProjectTranslationProvider translationProvider, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(sourceFile.getContents());){
                if (BslUtil.isBinaryBslFile((BufferedInputStream)inputStream, (String)sourceFile.getName())) {
                    bmSession.storeDelayedFiles(targetFile, sourceFile.getContents());
                    return Status.OK_STATUS;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            IStatus status = BslPlugin.createErrorStatus(MessageFormat.format("BSL module error: {0}", sourceFile.getFullPath()), e);
            BslPlugin.log(status);
            return status;
        }
        MonitorBasedCancelIndicator cancelIndicator = new MonitorBasedCancelIndicator(monitor);
        Module module = this.moduleCachedLoader.getModule(sourceFile, (CancelIndicator)cancelIndicator);
        if (module != null) {
            return (IStatus)this.bmModelManager.executeReadOnlyTask(sourceFile.getProject(), transaction -> {
                BmOperationContext context = new BmOperationContext(this.namingService, this.bmModelManager, transaction);
                return this.synchronize(sourceFile, context, owner, (EObject)module, null, target, targetFile, bmSession, translationProvider, monitor);
            });
        }
        return super.synchronize(sourceFile, owner, target, targetFile, bmSession, translationProvider, monitor);
    }

    protected boolean executeInTransaction() {
        return false;
    }

    protected IStatus synchronize(IFile sourceFile, BmOperationContext typeComputationContext, EObject owner, EObject source, EReference property, IProject target, IFile targetFile, BmSyncSession bmSession, IProjectTranslationProvider translationProvider, IProgressMonitor monitor) {
        if (source.eIsProxy() || !(source instanceof Module)) {
            if (BslPlugin.getDefault().isDebugging()) {
                System.err.println("Source Module wasn't found" + String.valueOf(EcoreUtil.getURI((EObject)source)));
            }
            return Status.CANCEL_STATUS;
        }
        MonitorBasedCancelIndicator cancelIndicator = new MonitorBasedCancelIndicator(monitor);
        Module module = (Module)source;
        ModuleTextEditor editor = new ModuleTextEditor(module, translationProvider, typeComputationContext);
        Resource moduleResource = module.eResource();
        if (moduleResource != null && !((BslResource)moduleResource).isDeepAnalysing()) {
            BslResource.setSingleThreadMode();
            ((BslResource)moduleResource).setDeepAnalysis(true);
            try {
                try {
                    EcoreUtil2.resolveLazyCrossReferences((Resource)moduleResource, (CancelIndicator)cancelIndicator);
                    Collection jobs = BslResolveCrossReferencesJob.findJobsByResource((LazyLinkingResource)((BslResource)moduleResource));
                    for (BslResolveCrossReferencesJob job : jobs) {
                        job.join();
                    }
                }
                catch (Exception e) {
                    IStatus status = this.createErrorStatus(source, e);
                    BslPlugin.log(status);
                    IStatus iStatus = status;
                    BslResource.resetSingleThreadMode();
                    return iStatus;
                }
            }
            finally {
                BslResource.resetSingleThreadMode();
            }
        }
        URI uri = EcoreUtil.getURI((EObject)module);
        try {
            IStatus result = editor.process(monitor);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (!result.isOK()) {
                IStatus iStatus = result;
                return iStatus;
            }
        }
        catch (Exception e) {
            IStatus status = this.createErrorStatus(source, e);
            BslPlugin.log(status);
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            try {
                sourceFile.deleteMarkers(null, true, 2);
            }
            catch (CoreException e) {
                BslPlugin.log(BslPlugin.createErrorStatus("Error while removing BSL markers.", e));
            }
            this.moduleCachedLoader.cleanCached(uri);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            try {
                String bslText = editor.getProcessedText();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bslText.getBytes(StandardCharsets.UTF_8));
                bmSession.storeDelayedFiles(targetFile, (InputStream)inputStream);
            }
            catch (IOException e) {
                Object message = e.getMessage();
                if (StringUtils.isNullOrEmpty((String)message)) {
                    message = "";
                }
                message = "Cannot translate module: " + String.valueOf(uri) + "\n\n" + (String)message;
                IStatus status = BslPlugin.createErrorStatus((String)message, e);
                BslPlugin.log(status);
                IStatus iStatus = status;
                try {
                    sourceFile.deleteMarkers(null, true, 2);
                }
                catch (CoreException e2) {
                    BslPlugin.log(BslPlugin.createErrorStatus("Error while removing BSL markers.", e2));
                }
                return iStatus;
            }
        }
        finally {
            try {
                sourceFile.deleteMarkers(null, true, 2);
            }
            catch (CoreException e) {
                BslPlugin.log(BslPlugin.createErrorStatus("Error while removing BSL markers.", e));
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus createErrorStatus(EObject source, Exception e) {
        Object message = e.getMessage();
        if (StringUtils.isNullOrEmpty((String)message)) {
            message = "";
        }
        URI uri = EcoreUtil.getURI((EObject)source);
        message = "Cannot translate module: " + String.valueOf(uri) + "\n\n" + (String)message;
        IStatus status = BslPlugin.createErrorStatus((String)message, e);
        return status;
    }
}

