/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.translator;

import com._1c.g5.v8.dt.bsl.model.BslDerivedPropertySource;
import com._1c.g5.v8.dt.bsl.model.BslFactory;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.McoreFactory;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.Type;
import com._1c.g5.v8.dt.mcore.TypeContainer;
import com._1c.g5.v8.dt.mcore.TypeContainerRef;
import com._1c.g5.v8.dt.mcore.TypeDescription;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.CommonExpression;
import com._1c.g5.v8.dt.ql.model.QlPackage;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralProvider;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.ql.QuerySelectedFieldTypesComputer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Pair;

@Singleton
public class QueryFieldsTypeComputer {
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    private IDependentQuerySchemaProvider dependentModelProvider;
    @Inject
    private TypedStringLiteralProvider typedStringLiteralProvider;
    private QuerySelectedFieldTypesComputer querySelectedFieldTypesComputer;

    public TypeItem getQueryResultSelectionType(DynamicFeatureAccess featureAccess, TypeItem typeItem) {
        if (!(typeItem instanceof Type)) {
            return typeItem;
        }
        Collection<Property> properties = this.getQueryProperties((EObject)featureAccess);
        if (properties.isEmpty()) {
            return typeItem;
        }
        if (typeItem.eIsProxy()) {
            typeItem = (TypeItem)EcoreUtil.resolve((EObject)typeItem, (EObject)featureAccess);
        }
        Type newTypeItem = (Type)EcoreUtil2.cloneWithProxies((EObject)typeItem);
        newTypeItem.getContextDef().getProperties().addAll(properties);
        newTypeItem.setParentType(typeItem);
        return newTypeItem;
    }

    private Collection<Property> getQueryProperties(EObject current) {
        ArrayDeque<Property> result = new ArrayDeque<Property>();
        Collection<StringLiteral> literals = this.getQueryStringLiterals(current);
        for (StringLiteral literal : literals) {
            Collection<Property> properties = this.getQueryStringLiteralProperties(literal);
            if (properties.isEmpty()) continue;
            result.addAll(properties);
        }
        return result;
    }

    private Collection<Property> getQueryStringLiteralProperties(StringLiteral literal) {
        QueryStringLiteralPropertiesAdapter adapter = (QueryStringLiteralPropertiesAdapter)EcoreUtil.getExistingAdapter((Notifier)literal, QueryStringLiteralPropertiesAdapter.class);
        if (adapter == null) {
            adapter = new QueryStringLiteralPropertiesAdapter();
            literal.eAdapters().add((Object)adapter);
        }
        return adapter.getQueryProperties();
    }

    private Collection<Property> createProperties(List<Pair<TypeDescription, EObject>> fields, StringLiteral literal) {
        LinkedList<Property> result = new LinkedList<Property>();
        StringLiteralQuerySchemaOffsetProvider offsetProvider = new StringLiteralQuerySchemaOffsetProvider(literal);
        for (Pair<TypeDescription, EObject> field : fields) {
            TypeDescription typeDescr = (TypeDescription)field.getFirst();
            if (typeDescr == null) continue;
            String name = null;
            String nameRu = null;
            if (field.getSecond() instanceof DuallyNamedElement) {
                DuallyNamedElement dually = (DuallyNamedElement)field.getSecond();
                name = dually.getName();
                nameRu = dually.getNameRu();
            } else if (field.getSecond() instanceof QuerySchemaExpression) {
                name = ((QuerySchemaExpression)field.getSecond()).getAlias();
            }
            if (StringUtils.isBlank(name)) continue;
            if (nameRu == null) {
                nameRu = name;
            }
            DerivedProperty property = McoreFactory.eINSTANCE.createDerivedProperty();
            property.setName(name);
            property.setNameRu(nameRu);
            property.setReadable(true);
            property.setWritable(false);
            TypeContainerRef typeContainer = McoreFactory.eINSTANCE.createTypeContainerRef();
            property.setTypeContainer((TypeContainer)typeContainer);
            typeContainer.getTypes().addAll((Collection)typeDescr.getTypes());
            property.setSource(this.getSource((EObject)field.getSecond(), offsetProvider));
            result.add((Property)property);
        }
        return result;
    }

    private EObject getSource(EObject field, StringLiteralQuerySchemaOffsetProvider offsetProvider) {
        if (field instanceof QuerySchemaExpression) {
            List nodes;
            Object node = null;
            node = ((QuerySchemaExpression)field).isComputeAlias() && ((QuerySchemaExpression)field).getExpression() instanceof CommonExpression ? ((nodes = NodeModelUtils.findNodesForFeature((EObject)((QuerySchemaExpression)field).getExpression(), (EStructuralFeature)QlPackage.Literals.COMMON_EXPRESSION__CONTENT)).isEmpty() ? NodeModelUtils.findActualNodeFor((EObject)field) : (INode)nodes.get(0)) : ((nodes = NodeModelUtils.findNodesForFeature((EObject)field, (EStructuralFeature)QlPackage.Literals.QUERY_SCHEMA_EXPRESSION__ALIAS)).isEmpty() ? NodeModelUtils.findActualNodeFor((EObject)field) : (INode)nodes.get(0));
            if (node == null) {
                return null;
            }
            int line = node.getStartLine();
            int localOffset = offsetProvider.getLineLocalOffset(line) + node.getOffset();
            BslDerivedPropertySource source = BslFactory.eINSTANCE.createBslDerivedPropertySource();
            source.setModuleUri(offsetProvider.getModuleUri());
            source.setMethodName(offsetProvider.getMethodName());
            source.setLocalOffset(localOffset);
            return source;
        }
        return field;
    }

    private Collection<StringLiteral> getQueryStringLiterals(EObject current) {
        return this.typedStringLiteralProvider.getStringLiterals(current, LangToolDefaults.QUERY);
    }

    private QuerySchema getQuerySchema(StringLiteral literal) {
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return null;
        }
        return this.dependentModelProvider.getQuerySchema((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, this::getQueryText, CancelIndicator.NullImpl);
    }

    private String getQueryText(EObject object, EStructuralFeature feautre) {
        StringLiteral literal = (StringLiteral)object;
        String literalContent = BslUtils.getString(literal);
        return QlUtil.getActualQueryText((String)literalContent);
    }

    private QuerySelectedFieldTypesComputer getQuerySelectedFieldTypesComputer() {
        if (this.querySelectedFieldTypesComputer == null) {
            this.querySelectedFieldTypesComputer = QuerySelectedFieldTypesComputer.getInstance();
        }
        return this.querySelectedFieldTypesComputer;
    }

    private class QueryStringLiteralPropertiesAdapter
    extends AdapterImpl {
        private Collection<Property> queryProperties;

        private QueryStringLiteralPropertiesAdapter() {
        }

        public StringLiteral getStringLiteral() {
            return (StringLiteral)this.getTarget();
        }

        public Collection<Property> getQueryProperties() {
            if (this.queryProperties == null) {
                QuerySchema querySchema = QueryFieldsTypeComputer.this.getQuerySchema(this.getStringLiteral());
                LinkedList<Property> result = new LinkedList<Property>();
                if (querySchema != null) {
                    Collection<Property> properties;
                    List allFields = QueryFieldsTypeComputer.this.getQuerySelectedFieldTypesComputer().getSelectedFieldTypes(querySchema);
                    if (!allFields.isEmpty() && !(properties = QueryFieldsTypeComputer.this.createProperties((List)allFields.get(allFields.size() - 1), this.getStringLiteral())).isEmpty()) {
                        result.addAll(properties);
                    }
                    QlUtil.cleanUpQueryCache((QuerySchema)querySchema);
                }
                this.queryProperties = List.copyOf(result);
            }
            return this.queryProperties;
        }
    }

    private class StringLiteralQuerySchemaOffsetProvider {
        private final StringLiteral literal;
        private boolean computed;
        private String moduleUri;
        private String methodName;
        private int[] localOffsets;
        private int offset;

        public StringLiteralQuerySchemaOffsetProvider(StringLiteral literal) {
            this.literal = literal;
        }

        public int getLineLocalOffset(int line) {
            if (!this.computed) {
                this.compute();
            }
            if (line >= this.localOffsets.length) {
                return 0;
            }
            return this.localOffsets[line - 1];
        }

        public String getMethodName() {
            if (!this.computed) {
                this.compute();
            }
            return this.methodName;
        }

        public String getModuleUri() {
            if (!this.computed) {
                this.compute();
            }
            return this.moduleUri;
        }

        private synchronized void compute() {
            if (this.computed) {
                return;
            }
            URI uri = EcoreUtil.getURI((EObject)this.literal).trimFragment().appendFragment("/0");
            this.moduleUri = uri.toString();
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)this.literal, Method.class);
            if (method == null) {
                this.methodName = "";
                this.offset = 0;
            } else {
                this.methodName = method.getName();
                ICompositeNode rootNode = NodeModelUtils.findActualNodeFor((EObject)method);
                this.offset = rootNode.getTotalOffset();
            }
            String trimmed = QueryFieldsTypeComputer.this.getQueryText((EObject)this.literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
            String[] lines = trimmed.split("\\n", -1);
            List nodes = NodeModelUtils.findNodesForFeature((EObject)this.literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
            int lineShift = 0;
            if (lines.length < nodes.size()) {
                lineShift = nodes.size() - lines.length;
            }
            this.localOffsets = new int[nodes.size() - lineShift];
            int prevOffsetShift = 0;
            int i = 0;
            while (i < nodes.size() - lineShift) {
                INode node = (INode)nodes.get(i + lineShift);
                this.localOffsets[i] = node.getOffset() - (this.offset + prevOffsetShift) + 1;
                prevOffsetShift += node.getTotalLength();
                ++i;
            }
            this.computed = true;
        }
    }
}

