/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.microsoft.internal.ui;

import com.e1c.langtool.microsoft.internal.ui.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.microsoft.ui";
    public static final String T_VIEW = "/view/";
    public static final String ICONS_PATH = "/icons";
    public static final String IMG_VIEW_MSFT_ORG_LOGO = "com.e1c.langtool.microsoft.ui/view/msft_logo_org_misc.png";
    private static UiPlugin plugin;
    private volatile Injector injector;
    private BundleContext bundleContext;

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static Image getImage(String id) {
        return plugin.getImageRegistry().get(id);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return plugin.getImageRegistry().getDescriptor(id);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.bundleContext = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.injector = null;
        plugin = null;
        super.stop(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<UiPlugin> clazz = UiPlugin.class;
        synchronized (UiPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IMG_VIEW_MSFT_ORG_LOGO, UiPlugin.createImageDescriptorFromKey(IMG_VIEW_MSFT_ORG_LOGO));
    }

    private static ImageDescriptor createImageDescriptorFromKey(String key) {
        String path = ICONS_PATH + key.substring(PLUGIN_ID.length());
        return UiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule((Plugin)this)});
        }
        catch (Exception e) {
            UiPlugin.log(UiPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

