/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.ui;

import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.FormatterUtil;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsChangeListener;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.stat.internal.ui.TranslationStatisticViewSettingsDialog;
import com.e1c.langtool.stat.internal.ui.UiPlugin;
import com.e1c.langtool.stat.ui.Messages;
import com.e1c.langtool.ui.SearchText;
import com.e1c.langtool.ui.TableViewerColumnComparator;
import com.e1c.langtool.ui.TextSearchFilter;
import com.e1c.langtool.ui.TransSharedImages;
import com.google.inject.Inject;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class TranslationStatisticView
extends CommonNavigator {
    public static final String COLUMN_DATA_METRIC = "metric";
    private final StatisticsChangeListener statisticChangeListener = e -> this.update(e.getProject(), e.getPath(), e.getLanguage());
    @Inject
    private StatisticsService statisticService;
    private Composite topLevel;
    private SearchText searchText;
    private TextSearchFilter searchFilter;
    private TableViewerColumnComparator comparator;
    private StatLableProvider labelProvider;
    private TreeColumnLayout tableColumnLayout;
    private Map<Metric, TreeViewerColumn> metricColumns = new HashMap<Metric, TreeViewerColumn>();
    private IAction openSettingsAction;
    private IAction filterFullyTranslatedAction;
    private IAction recomputeStatisticAction;
    private IAction exportTranslatedAction;
    private final UpdateJob asyncUpdate = new UpdateJob();
    private static final long ASYNC_UPDATE_DELAY = 1000L;
    private IPropertyChangeListener preferenceChangeListener = e -> {
        if ("metricOrder".equals(e.getProperty())) {
            this.createOrUpdateMetricCulumns();
        }
    };

    public void setFocus() {
        this.topLevel.setFocus();
    }

    public void dispose() {
        this.statisticService.removeStatisticChangeListener(this.statisticChangeListener);
        this.metricColumns.clear();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Font font = parent.getFont();
        this.topLevel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 300).applyTo((Control)this.topLevel);
        GridLayoutFactory.fillDefaults().applyTo(this.topLevel);
        this.topLevel.setFont(font);
        Composite viewerComposite = new Composite(this.topLevel, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 300).applyTo((Control)viewerComposite);
        GridLayoutFactory.fillDefaults().applyTo(viewerComposite);
        viewerComposite.setFont(font);
        super.createPartControl(viewerComposite);
        Tree tree = this.getCommonViewer().getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 300).applyTo((Control)tree);
        this.tableColumnLayout = new TreeColumnLayout();
        viewerComposite.setLayout((Layout)this.tableColumnLayout);
        this.comparator = new TableViewerColumnComparator();
        this.labelProvider = new StatLableProvider();
        this.createViewerColumns();
        this.statisticService.addStatisticChangeListener(this.statisticChangeListener);
        this.createActions();
        this.createToolbar();
        this.createMenu();
    }

    private SelectionListener getSelectionAdapter(TreeColumn column, int index) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            this.comparator.setColumn(index);
            int dir = this.comparator.getDirection(index);
            this.getCommonViewer().getTree().setSortDirection(dir);
            this.getCommonViewer().getTree().setSortColumn(column);
            this.getCommonViewer().refresh();
        });
    }

    private void createViewerColumns() {
        TreeViewerColumn projectColumn = new TreeViewerColumn((TreeViewer)this.getCommonViewer(), 0);
        projectColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider(this.getCommonViewer().getLabelProvider()));
        projectColumn.getColumn().setText(Messages.TranslationStatisticView_Project);
        projectColumn.getColumn().setResizable(true);
        projectColumn.getColumn().setWidth(300);
        projectColumn.getColumn().setMoveable(false);
        this.tableColumnLayout.setColumnData((Widget)projectColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 200));
        this.createOrUpdateMetricCulumns();
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 66306);
    }

    private void createOrUpdateMetricCulumns() {
        int firstColumnWidth = this.getCommonViewer().getTree().getColumn(0).getWidth();
        List<Metric> metrics = this.getMetrics();
        ArrayList<TreeColumn> columnsOrder = new ArrayList<TreeColumn>();
        boolean needRefresh = false;
        int i = 0;
        while (i < metrics.size()) {
            Metric metrict = metrics.get(i);
            TreeViewerColumn column = this.metricColumns.get(metrict);
            if (column == null) {
                column = new TreeViewerColumn((TreeViewer)this.getCommonViewer(), 0);
                column.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)this.labelProvider));
                column.getColumn().setAlignment(131072);
                column.getColumn().setText(metrict.getTitle());
                column.getColumn().setToolTipText(metrict.getDescription());
                column.getColumn().setResizable(true);
                column.getColumn().setWidth(150);
                column.getColumn().setMoveable(true);
                column.getColumn().setData(COLUMN_DATA_METRIC, (Object)metrict);
                column.getColumn().addSelectionListener(this.getSelectionAdapter(column.getColumn(), i + 1));
                this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 140));
                this.metricColumns.put(metrict, column);
                needRefresh = true;
            }
            columnsOrder.add(column.getColumn());
            ++i;
        }
        Iterator<Map.Entry<Metric, TreeViewerColumn>> iterator = this.metricColumns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Metric, TreeViewerColumn> entry = iterator.next();
            if (metrics.contains(entry.getKey())) continue;
            entry.getValue().getColumn().dispose();
            iterator.remove();
            needRefresh = true;
        }
        int[] order = new int[metrics.size() + 1];
        order[0] = 0;
        TreeColumn[] columns = this.getCommonViewer().getTree().getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            TreeColumn column = columns[i2];
            int index = columnsOrder.indexOf(column);
            if (index > -1 && index + 1 < order.length) {
                order[index + 1] = i2;
            }
            ++i2;
        }
        this.getCommonViewer().getTree().setColumnOrder(order);
        if (needRefresh) {
            this.getCommonViewer().getTree().getColumn(0).setWidth(firstColumnWidth);
            this.getCommonViewer().refresh();
        }
    }

    private List<String> loadSelectedIds() {
        IPreferenceStore prefs = UiPlugin.getDefault().getPreferenceStore();
        prefs.addPropertyChangeListener(this.preferenceChangeListener);
        String settings = prefs.getString("metricOrder");
        String[] order = settings.split(",");
        return List.of(order);
    }

    private List<Metric> getMetrics() {
        List<String> selectedIds = this.loadSelectedIds();
        Map<String, Metric> allMetrics = this.statisticService.getMetrics().stream().collect(Collectors.toMap(Metric::getID, m -> m));
        return selectedIds.stream().map(allMetrics::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void update(IProject project, IPath path, TranslateLanguage language) {
        this.asyncUpdate.schedule(1000L);
    }

    private void createActions() {
        this.openSettingsAction = new Action(Messages.TranslationStatisticView_Configure_metric_columns){

            public void run() {
                TranslationStatisticViewSettingsDialog dialog = new TranslationStatisticViewSettingsDialog(TranslationStatisticView.this.getSite().getShell(), TranslationStatisticView.this.statisticService);
                if (dialog.open() == 0) {
                    TranslationStatisticView.this.createOrUpdateMetricCulumns();
                }
            }
        };
        this.filterFullyTranslatedAction = new ToggleFilterAction();
        boolean state = this.getNavigatorContentService().getFilterService().isActive("com.e1c.langtool.stat.ui.translationStatistic.filters.FullyTranslated");
        this.filterFullyTranslatedAction.setChecked(state);
        this.recomputeStatisticAction = new RecomputeStatisticAction((ISelectionProvider)this.getCommonViewer());
        this.exportTranslatedAction = new ExportTranslatedAction((ISelectionProvider)this.getCommonViewer());
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add(this.filterFullyTranslatedAction);
        mgr.add(this.recomputeStatisticAction);
        mgr.add(this.exportTranslatedAction);
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.insertBefore("additions", this.filterFullyTranslatedAction);
        mgr.insertAfter("additions", this.recomputeStatisticAction);
        mgr.insertAfter("additions", this.exportTranslatedAction);
        mgr.add(this.openSettingsAction);
    }

    private class ExportTranslatedAction
    extends SelectionProviderAction {
        public ExportTranslatedAction(ISelectionProvider provider) {
            super(provider, Messages.TranslationStatisticView_Export_title);
            this.setToolTipText(Messages.TranslationStatisticView_Export_tooltip);
            this.setImageDescriptor(TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/elcl16/export.png"));
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            if (!selection.isEmpty()) {
                for (final IProject project : this.getSelectedProjects()) {
                    Display display = Display.getCurrent();
                    FileDialog dialog = new FileDialog(display.getActiveShell(), 8192);
                    dialog.setFilterExtensions(new String[]{"*.csv", "*.json", "*.xls"});
                    final String filePath = dialog.open();
                    if (filePath == null) continue;
                    Job exportJob = new Job("Exporting Statistics for " + project.getName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                ((ExportTranslatedAction)ExportTranslatedAction.this).TranslationStatisticView.this.statisticService.getManager(project).exportStatistics(Paths.get(filePath, new String[0]));
                                return Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                return new Status(4, "com.e1c.langtool.stat.ui", "Failed to export statistics", (Throwable)e);
                            }
                        }
                    };
                    exportJob.setUser(true);
                    exportJob.schedule();
                }
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (!selection.isEmpty() && !TranslationStatisticView.this.getCommonViewer().isCellEditorActive()) {
                IProject project = this.getSelectedProject(selection);
                this.setEnabled(project != null);
            } else {
                this.setEnabled(false);
            }
        }

        private IProject getSelectedProject(IStructuredSelection selection) {
            for (Object sel : selection) {
                IProject project = this.getProject(sel);
                if (project == null || !project.isAccessible()) continue;
                return project;
            }
            return null;
        }

        private Set<IProject> getSelectedProjects() {
            HashSet<IProject> projects = new HashSet<IProject>();
            IStructuredSelection selection = this.getStructuredSelection();
            if (!selection.isEmpty()) {
                for (Object sel : selection) {
                    IProject project = this.getProject(sel);
                    if (Objects.isNull(project) || !project.isAccessible()) continue;
                    projects.add(project);
                }
            }
            return projects;
        }

        private IProject getProject(Object object) {
            IResource resource;
            IProject project = (IProject)Adapters.adapt((Object)object, IProject.class);
            if (project == null && (resource = (IResource)Adapters.adapt((Object)object, IResource.class)) != null) {
                project = resource.getProject();
            }
            return project;
        }
    }

    private class RecomputeStatisticAction
    extends SelectionProviderAction {
        public RecomputeStatisticAction(ISelectionProvider provider) {
            super(provider, Messages.TranslationStatisticView_Recompute_Title);
            this.setToolTipText(Messages.TranslationStatisticView_Recompute_Tooltip);
            this.setImageDescriptor(TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/elcl16/refresh_stat.png"));
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            if (!selection.isEmpty()) {
                for (IProject project : this.getSelectedProjects()) {
                    TranslationStatisticView.this.statisticService.getManager(project).startRecomputeFullStatistic();
                }
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (!selection.isEmpty() && !TranslationStatisticView.this.getCommonViewer().isCellEditorActive()) {
                IProject project = this.getSelectedProject(selection);
                this.setEnabled(!Objects.isNull(project));
            } else {
                this.setEnabled(false);
            }
        }

        private IProject getSelectedProject(IStructuredSelection selection) {
            for (Object sel : selection) {
                IProject project = this.getProject(sel);
                if (Objects.isNull(project) || !project.isAccessible()) continue;
                return project;
            }
            return null;
        }

        private Set<IProject> getSelectedProjects() {
            HashSet<IProject> projects = new HashSet<IProject>();
            IStructuredSelection selection = this.getStructuredSelection();
            if (!selection.isEmpty()) {
                for (Object sel : selection) {
                    IProject project = this.getProject(sel);
                    if (Objects.isNull(project) || !project.isAccessible()) continue;
                    projects.add(project);
                }
            }
            return projects;
        }

        private IProject getProject(Object object) {
            IResource resource;
            IProject project = (IProject)Adapters.adapt((Object)object, IProject.class);
            if (Objects.isNull(project) && !Objects.isNull(resource = (IResource)Adapters.adapt((Object)object, IResource.class))) {
                project = resource.getProject();
            }
            return project;
        }
    }

    private class StatLableProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private StatLableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object data = TranslationStatisticView.this.getCommonViewer().getTree().getColumn(columnIndex).getData(TranslationStatisticView.COLUMN_DATA_METRIC);
            if (!(data instanceof Metric)) {
                return null;
            }
            Metric metric = (Metric)data;
            TranslateLanguage language = (TranslateLanguage)Adapters.adapt((Object)element, TranslateLanguage.class);
            if (language == null || !metric.isApplicable(language)) {
                return null;
            }
            Statistics statistics = (Statistics)Adapters.adapt((Object)element, Statistics.class);
            if (statistics == null) {
                return null;
            }
            int baseValue = statistics.getMetricValue(metric);
            int value = statistics.getMetricValue(metric, language);
            float percentage = statistics.getMetricPercentage(metric, language);
            return MessageFormat.format("{1}/{0} ({2}%)", baseValue, value, FormatterUtil.format((float)percentage));
        }
    }

    private class ToggleFilterAction
    extends Action {
        private final INavigatorFilterService filterService;

        public ToggleFilterAction() {
            super(Messages.TranslationStatisticView_Hide_translated_Title, 2);
            this.setToolTipText(Messages.TranslationStatisticView_Hide_translated_Tooltip);
            this.setImageDescriptor(TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/elcl16/hide_filled_translation.png"));
            this.filterService = TranslationStatisticView.this.getNavigatorContentService().getFilterService();
        }

        public void run() {
            boolean toMakeActive = this.isChecked();
            Set<String> activeFilters = Arrays.stream(this.filterService.getVisibleFilterDescriptors()).map(ICommonFilterDescriptor::getId).filter(arg_0 -> ((INavigatorFilterService)this.filterService).isActive(arg_0)).collect(Collectors.toSet());
            boolean state = this.filterService.isActive("com.e1c.langtool.stat.ui.translationStatistic.filters.FullyTranslated");
            if (toMakeActive ^ state) {
                if (toMakeActive) {
                    activeFilters.add("com.e1c.langtool.stat.ui.translationStatistic.filters.FullyTranslated");
                } else {
                    activeFilters.remove("com.e1c.langtool.stat.ui.translationStatistic.filters.FullyTranslated");
                }
                this.filterService.activateFilterIdsAndUpdateViewer(activeFilters.toArray(new String[0]));
                this.filterService.persistFilterActivationState();
            }
        }
    }

    private class UpdateJob
    extends Job {
        public UpdateJob() {
            super("Language Tool: Update statistics");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (!TranslationStatisticView.this.getCommonViewer().getControl().isDisposed() && !TranslationStatisticView.this.getCommonViewer().getControl().getDisplay().isDisposed()) {
                Display display = TranslationStatisticView.this.getCommonViewer().getControl().getDisplay();
                display.asyncExec(() -> {
                    if (!TranslationStatisticView.this.getCommonViewer().getControl().isDisposed()) {
                        TranslationStatisticView.this.getCommonViewer().refresh();
                    }
                });
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return "Statistics".equals(family);
        }
    }
}

