/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql;

import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.dbview.DbViewElement;
import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldFieldDef;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.PredefinedItem;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.ql.model.AbstractExpression;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.CommonExpression;
import com._1c.g5.v8.dt.ql.model.MultiPartCommonExpression;
import com._1c.g5.v8.dt.ql.model.ParameterExpression;
import com._1c.g5.v8.dt.ql.model.QlPackage;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTempTableDescription;
import com._1c.g5.v8.dt.ql.model.SinglePartQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.UnresolvedDbView;
import com._1c.g5.v8.dt.ql.model.ValueLiteralExpression;
import com._1c.g5.v8.dt.ql.resource.QlMapper;
import com._1c.g5.v8.dt.ql.typesystem.IDynamicDbViewFieldComputer;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedStringFeatureProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.ql.QlPredefinedValueProvider;
import com.e1c.langtool.v8.dt.ql.settings.QlFeatureSettings;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.EcoreUtil2;

public class QlComputeNameProvider
implements IComputedStringFeatureProvider {
    @Inject
    private QlMapper qlMapper;
    @Inject
    private InternalizeDbViewTermsProvider dbViewTermsProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private QlPredefinedValueProvider qlPredefinedValueProvider;
    @Inject
    private IDynamicDbViewFieldComputer dynamicDbViewFieldComputer;

    public boolean isSupported(EObject object) {
        EPackage packageName = object.eClass().getEPackage();
        return packageName.equals(QlPackage.eINSTANCE);
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (object instanceof QuerySchemaTable) {
            return this.isComputedString((QuerySchemaTable)object, stringFeature);
        }
        if (object instanceof QuerySchemaTempTableDescription) {
            return this.isComputedString((QuerySchemaTempTableDescription)object, stringFeature);
        }
        if (object instanceof QuerySchemaExpression) {
            return this.isComputedString((QuerySchemaExpression)object, stringFeature);
        }
        if (object instanceof CommonExpression) {
            return this.isComputedString((CommonExpression)object, stringFeature);
        }
        if (object instanceof SinglePartQuerySchemaTable) {
            return this.isComputedString((SinglePartQuerySchemaTable)object, stringFeature);
        }
        return false;
    }

    private boolean isComputedString(QuerySchemaTable object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_SOURCE__ALIAS)) {
            return false;
        }
        String alias = object.getAlias();
        if (StringUtils.isNullOrEmpty((String)alias)) {
            return false;
        }
        AbstractQuerySchemaTable table = object.getTable();
        if (table == null || table.getTableName() == null) {
            return false;
        }
        if (alias.equals(table.getTableName())) {
            return true;
        }
        String[] words = table.getFullTableName().split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int index = words.length - 1; index >= 0; --index) {
            if (!alias.contains(words[index])) continue;
            sb.insert(0, words[index]);
            if (!alias.equalsIgnoreCase(sb.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isComputedString(QuerySchemaExpression object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(QlFeatureSettings.Literals.QUERY_SCHEMA_EXPRESSION__ALIAS) || object.isComputeAlias()) {
            return false;
        }
        String alias = object.getAlias();
        if (StringUtils.isNullOrEmpty((String)alias)) {
            return false;
        }
        AbstractExpression expr = object.getExpression();
        if (expr instanceof ParameterExpression) {
            return alias.equals(((ParameterExpression)expr).getName());
        }
        if (expr instanceof CommonExpression) {
            return alias.equals(((CommonExpression)expr).getContent());
        }
        return false;
    }

    private boolean isComputedString(QuerySchemaTempTableDescription object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_SOURCE__ALIAS)) {
            return false;
        }
        String alias = object.getAlias();
        if (StringUtils.isNullOrEmpty((String)alias)) {
            return false;
        }
        ParameterExpression parameter = object.getTable();
        return parameter != null && alias.equals(parameter.getName());
    }

    private boolean isComputedString(CommonExpression object, EFeatureSettings stringFeature) {
        EObject model;
        boolean unknown;
        Set sourceObjects;
        EObject mdObject;
        if (!stringFeature.equals(QlFeatureSettings.Literals.COMMON_EXPRESSION__CONTENT)) {
            return false;
        }
        DbViewElement dbView = null;
        try {
            dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EObject eObject = mdObject = dbView == null ? null : dbView.getMdObject();
        if (mdObject instanceof QuerySchemaTempTableDescription) {
            return true;
        }
        if (mdObject instanceof MdObject) {
            return true;
        }
        if (mdObject instanceof AbstractQuerySchemaTable) {
            return true;
        }
        if (dbView instanceof DbViewFieldFieldDef && !(sourceObjects = this.qlMapper.getSourceObjects((EObject)dbView)).isEmpty()) {
            return true;
        }
        boolean bl = unknown = dbView instanceof UnresolvedDbView || dbView != null && dbView.eIsProxy();
        if (unknown && (object instanceof MultiPartCommonExpression || object.eContainer() instanceof MultiPartCommonExpression) && EcoreUtil2.getContainerOfType((EObject)object, ValueLiteralExpression.class) != null && ((model = this.qlPredefinedValueProvider.computePredefinedValue((EObject)object, object.getFullContent())) instanceof MdObject || model instanceof PredefinedItem)) {
            return true;
        }
        if (mdObject == null) {
            IV8Project project = this.v8ProjectManager.getProject((EObject)object);
            String replace = this.dbViewTermsProvider.getInternalizeEnumValue(object.getContent(), project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH));
            if (StringUtils.isNotEmpty((String)replace)) {
                return true;
            }
        }
        return false;
    }

    private boolean isComputedString(SinglePartQuerySchemaTable object, EFeatureSettings stringFeature) {
        EObject mdObject;
        if (!stringFeature.equals(QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_TABLE__TABLE_NAME)) {
            return false;
        }
        IV8Project project = this.v8ProjectManager.getProject((EObject)object);
        String replace = this.dbViewTermsProvider.getInternalizeEnumValue(object.getTableName(), project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH));
        if (StringUtils.isNotEmpty((String)replace)) {
            return true;
        }
        DbViewElement dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)object);
        EObject eObject = mdObject = dbView == null ? null : dbView.getMdObject();
        return mdObject instanceof MdObject;
    }
}

