/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql;

import com._1c.g5.v8.dt.ql.model.FunctionExpression;
import com._1c.g5.v8.dt.ql.model.QlPackage;
import com._1c.g5.v8.dt.ql.parser.antlr.internal.InternalQlParser;
import com._1c.g5.v8.dt.ql.parser.antlr.lexer.InternalQlLexer;
import com._1c.g5.v8.dt.ql.services.QlGrammarAccess;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class QlPartStringParser
implements Iterable<Token> {
    private static final String TOKEN_RULE_ID = "RULE_ID";
    private static final String TOKEN_RULE_WS = "RULE_WS";
    private static final String REF_RU_UPPERCASE = "\u0421\u0421\u042b\u041b\u041a\u0410";
    private static final String KEYWORD_ON_RU = "\u041f\u041e";
    private static final String KEYWORD_ON = "ON";
    private static final String KEYWORD_BY_RU = "\u041f\u041e";
    private static final String KEYWORD_BY = "BY";
    private static final Set<String> KEYWORD_APPEND = Set.of("\u041f\u041e", "ON", "BY");
    private static final Set<String> TOKEN_RULE_JOIN = Set.of("JOIN", "CyrillicCapitalLetterEsCyrillicCapitalLetterOCyrillicCapitalLetterIeCyrillicCapitalLetterDeCyrillicCapitalLetterICyrillicCapitalLetterEnCyrillicCapitalLetterIeCyrillicCapitalLetterEnCyrillicCapitalLetterICyrillicCapitalLetterIe");
    private static final Set<String> TOKEN_RULE_TOTALS = Set.of("TOTALS", "CyrillicCapitalLetterICyrillicCapitalLetterTeCyrillicCapitalLetterOCyrillicCapitalLetterGheCyrillicCapitalLetterI");
    private static final Set<String> TOKEN_RULE_PREV_BY = Set.of("INDEX", "CyrillicCapitalLetterICyrillicCapitalLetterEnCyrillicCapitalLetterDeCyrillicCapitalLetterIeCyrillicCapitalLetterKaCyrillicCapitalLetterEsCyrillicCapitalLetterICyrillicCapitalLetterErCyrillicCapitalLetterOCyrillicCapitalLetterVeCyrillicCapitalLetterACyrillicCapitalLetterTeCyrillicCapitalLetterSoftSign", "ORDER", "CyrillicCapitalLetterUCyrillicCapitalLetterPeCyrillicCapitalLetterOCyrillicCapitalLetterErCyrillicCapitalLetterYaCyrillicCapitalLetterDeCyrillicCapitalLetterOCyrillicCapitalLetterCheCyrillicCapitalLetterICyrillicCapitalLetterTeCyrillicCapitalLetterSoftSign", "GROUP", "CyrillicCapitalLetterEsCyrillicCapitalLetterGheCyrillicCapitalLetterErCyrillicCapitalLetterUCyrillicCapitalLetterPeCyrillicCapitalLetterPeCyrillicCapitalLetterICyrillicCapitalLetterErCyrillicCapitalLetterOCyrillicCapitalLetterVeCyrillicCapitalLetterACyrillicCapitalLetterTeCyrillicCapitalLetterSoftSign");
    private static final String TOKEN_RULE_FULLSTOP = "FullStop";
    private static final Set<String> TOKEN_SKIP = Set.of("RULE_WS", "FullStop", "NULL", "Ampersand", "PlusSign", "Asterisk", "Comma", "HyphenMinus", "Semicolon", "LessThanSignEqualsSign", "LessThanSignGreaterThanSign", "GreaterThanSignEqualsSign", "NumberSign", "EqualsSign", "GreaterThanSign", "Solidus", "<invalid>", "LeftParenthesis", "RightParenthesis");
    private final QlGrammarAccess grammarAccess;
    private final IScopeProvider qlScope;
    private CommonTokenStream stream;
    private final String[] tokenNames;
    private Map<Token, FunctionExpression> functions = new HashMap<Token, FunctionExpression>();

    public QlPartStringParser() {
        this(true);
    }

    public QlPartStringParser(boolean isQlDcs) {
        this.tokenNames = InternalQlParser.tokenNames;
        URI uri = isQlDcs ? URI.createURI((String)"*.qldcs") : URI.createURI((String)"*.ql");
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        this.grammarAccess = (QlGrammarAccess)rsp.get(QlGrammarAccess.class);
        this.qlScope = (IScopeProvider)rsp.get(IScopeProvider.class);
    }

    @Override
    public Iterator<Token> iterator() {
        return this.stream.getTokens().iterator();
    }

    public void setString(String content) {
        InternalQlLexer lexer = new InternalQlLexer((CharStream)new ANTLRStringStream(content));
        this.stream = new CommonTokenStream((TokenSource)lexer);
    }

    public String getTokenName(Token token) {
        int type = token.getType();
        if (type != -1 && type < this.tokenNames.length) {
            String name = this.tokenNames[type];
            String text = token.getText();
            List keywords = this.grammarAccess.findKeywords(new String[]{text});
            if (keywords.isEmpty() && !text.equals(text.toUpperCase())) {
                Token prev;
                String prevName;
                if (token.getTokenIndex() > 0 && (prevName = this.tokenNames[(prev = (Token)this.stream.getTokens().get(token.getTokenIndex() - 1)).getType()]).equals(TOKEN_RULE_FULLSTOP)) {
                    return null;
                }
                keywords = this.grammarAccess.findKeywords(new String[]{text.toUpperCase()});
            }
            return keywords.isEmpty() ? null : name;
        }
        return null;
    }

    public boolean isSkipToken(Token token) {
        int type = token.getType();
        if (type != -1 && type < this.tokenNames.length) {
            String name = this.tokenNames[type];
            return name != null && TOKEN_SKIP.contains(name);
        }
        return false;
    }

    public boolean isKeyword(Token token) {
        Token prev = null;
        String prevName = null;
        if (token.getTokenIndex() > 0 && TOKEN_RULE_FULLSTOP.equals(prevName = this.tokenNames[(prev = (Token)this.stream.getTokens().get(token.getTokenIndex() - 1)).getType()])) {
            return false;
        }
        int type = token.getType();
        if (type != -1 && type < this.tokenNames.length) {
            String text = token.getText();
            if (!(!REF_RU_UPPERCASE.equalsIgnoreCase(text) || REF_RU_UPPERCASE.equals(text) && token.getTokenIndex() > 2 && token.getTokenIndex() < this.stream.getTokens().size() - 2 && TOKEN_RULE_WS.equals(this.tokenNames[((Token)this.stream.getTokens().get(token.getTokenIndex() - 1)).getType()]) && TOKEN_RULE_WS.equals(this.tokenNames[((Token)this.stream.getTokens().get(token.getTokenIndex() + 1)).getType()]) && (TOKEN_RULE_ID.equals(this.tokenNames[((Token)this.stream.getTokens().get(token.getTokenIndex() - 2)).getType()]) || REF_RU_UPPERCASE.equalsIgnoreCase(((Token)this.stream.getTokens().get(token.getTokenIndex() - 2)).getText())) && TOKEN_RULE_ID.equals(this.tokenNames[((Token)this.stream.getTokens().get(token.getTokenIndex() + 2)).getType()]))) {
                return false;
            }
            List keywords = this.grammarAccess.findKeywords(new String[]{text});
            if (keywords.isEmpty() && !text.equals(text.toUpperCase())) {
                text = text.toUpperCase();
                keywords = this.grammarAccess.findKeywords(new String[]{text});
            }
            if (!keywords.isEmpty() && KEYWORD_APPEND.contains(text)) {
                if (("\u041f\u041e".equals(text) || KEYWORD_BY.equals(text)) && (this.isPreviousByKeyword(token) || this.isPreviousTotalsByKeyword(token))) {
                    return true;
                }
                return ("\u041f\u041e".equals(text) || KEYWORD_ON.equals(text)) && this.isPreviousJoinOnKeyword(token);
            }
            return !keywords.isEmpty();
        }
        return false;
    }

    public boolean isStringLiteral(Token token) {
        String comment = token.getText();
        return comment.startsWith("\"") && comment.endsWith("\"");
    }

    public boolean isFunction(Token token) {
        Token next;
        return this.stream.size() > token.getTokenIndex() + 1 && (next = this.stream.get(token.getTokenIndex() + 1)).getText().startsWith("(");
    }

    public FunctionExpression getFunction(Token token, EObject context) {
        return this.functions.computeIfAbsent(token, k -> {
            String name = token.getText();
            IScope scope = this.qlScope.getScope(context, QlPackage.Literals.FUNCTION_INVOCATION_EXPRESSION__FUNCTION_TYPE);
            IEObjectDescription item = scope.getSingleElement(QualifiedName.create((String)name));
            if (item != null) {
                FunctionExpression func = (FunctionExpression)item.getEObjectOrProxy();
                if (func.eIsProxy()) {
                    func = (FunctionExpression)EcoreUtil.resolve((EObject)func, (Resource)context.eResource());
                }
                return func;
            }
            return null;
        });
    }

    public List<Keyword> getKeyword(Token token) {
        List keywords;
        block3: {
            String text;
            block2: {
                text = token.getText().toUpperCase();
                keywords = this.grammarAccess.findKeywords(new String[]{text});
                if (!"\u041f\u041e".equals(text) || keywords.size() <= 1 || !this.isPreviousByKeyword(token) && !this.isPreviousTotalsByKeyword(token)) break block2;
                for (Keyword keyword : keywords) {
                    EObject enElement;
                    Alternatives alternatives;
                    int index;
                    EObject container = keyword.eContainer();
                    if (!(container instanceof Alternatives) || (index = (alternatives = (Alternatives)container).getElements().indexOf((Object)keyword)) <= 0 || !((enElement = (EObject)alternatives.getElements().get(--index)) instanceof Keyword) || !KEYWORD_BY.equals(((Keyword)enElement).getValue())) continue;
                    return Arrays.asList((Keyword)enElement);
                }
                break block3;
            }
            if (!"\u041f\u041e".equals(text) || keywords.size() <= 1 || !this.isPreviousJoinOnKeyword(token)) break block3;
            for (Keyword keyword : keywords) {
                EObject enElement;
                Alternatives alternatives;
                int index;
                EObject container = keyword.eContainer();
                if (!(container instanceof Alternatives) || (index = (alternatives = (Alternatives)container).getElements().indexOf((Object)keyword)) <= 0 || !((enElement = (EObject)alternatives.getElements().get(--index)) instanceof Keyword) || !KEYWORD_ON.equals(((Keyword)enElement).getValue())) continue;
                return Arrays.asList((Keyword)enElement);
            }
        }
        return keywords;
    }

    public QlGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    public boolean isComment(Token token) {
        String name;
        int type = token.getType();
        return type != -1 && type < this.tokenNames.length && "RULE_SL_COMMENT".equals(name = this.tokenNames[type]);
    }

    private boolean isPreviousByKeyword(Token token) {
        if (token.getTokenIndex() < 2) {
            return false;
        }
        int i = token.getTokenIndex() - 1;
        while (i >= 0 && i < this.stream.getTokens().size()) {
            String tokenName;
            Token prev = (Token)this.stream.getTokens().get(i);
            int type = prev.getType();
            if (type != -1 && type < this.tokenNames.length && !TOKEN_RULE_WS.equals(tokenName = this.tokenNames[type])) {
                if (TOKEN_RULE_ID.equals(tokenName)) {
                    return false;
                }
                if (TOKEN_RULE_PREV_BY.contains(tokenName)) {
                    return true;
                }
            }
            --i;
        }
        return false;
    }

    private boolean isPreviousJoinOnKeyword(Token token) {
        if (token.getTokenIndex() < 2) {
            return false;
        }
        int i = token.getTokenIndex() - 1;
        while (i >= 0 && i < this.stream.getTokens().size()) {
            String tokenName;
            Token prev = (Token)this.stream.getTokens().get(i);
            int type = prev.getType();
            if (type != -1 && type < this.tokenNames.length && !TOKEN_RULE_WS.equals(tokenName = this.tokenNames[type]) && !TOKEN_RULE_ID.equals(tokenName) && !TOKEN_RULE_FULLSTOP.equals(tokenName) && TOKEN_RULE_JOIN.contains(tokenName)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean isPreviousTotalsByKeyword(Token token) {
        if (token.getTokenIndex() < 2) {
            return false;
        }
        int i = token.getTokenIndex() - 1;
        while (i >= 0 && i < this.stream.getTokens().size()) {
            String tokenName;
            Token prev = (Token)this.stream.getTokens().get(i);
            int type = prev.getType();
            if (type != -1 && type < this.tokenNames.length && !TOKEN_RULE_WS.equals(tokenName = this.tokenNames[type]) && !TOKEN_RULE_ID.equals(tokenName) && !TOKEN_RULE_FULLSTOP.equals(tokenName) && TOKEN_RULE_TOTALS.contains(tokenName)) {
                return true;
            }
            --i;
        }
        return false;
    }
}

