/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql;

import com._1c.g5.v8.dt.mcore.TypeDescription;
import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldFieldDef;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com._1c.g5.v8.dt.ql.typesystem.IExpressionTypeChecker;
import com.e1c.langtool.v8.dt.internal.ql.QlPlugin;
import com.e1c.langtool.v8.dt.ql.QuerySelectedFieldComputer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class QuerySelectedFieldTypesComputer {
    @Inject
    private QuerySelectedFieldComputer querySelectedFieldComputer;
    @Inject
    private IExpressionTypeChecker checker;

    public static QuerySelectedFieldTypesComputer getInstance() {
        return (QuerySelectedFieldTypesComputer)QlPlugin.getDefault().getInjector().getInstance(QuerySelectedFieldTypesComputer.class);
    }

    public List<List<Pair<TypeDescription, EObject>>> getSelectedFieldTypes(QuerySchema querySchema) {
        ArrayList<List<Pair<TypeDescription, EObject>>> result = new ArrayList<List<Pair<TypeDescription, EObject>>>();
        List<List<EObject>> allFields = this.querySelectedFieldComputer.getSelectedFields(querySchema);
        for (List<EObject> fields : allFields) {
            List<Pair<TypeDescription, EObject>> types = this.computeTypes(fields);
            result.add(types);
        }
        return result;
    }

    private List<Pair<TypeDescription, EObject>> computeTypes(List<EObject> fields) {
        ArrayList<Pair<TypeDescription, EObject>> result = new ArrayList<Pair<TypeDescription, EObject>>();
        for (EObject field : fields) {
            TypeDescription typeDesc = this.getTypeDescription(field);
            if (typeDesc == null) continue;
            Pair typePair = Tuples.create((Object)typeDesc, (Object)field);
            result.add((Pair<TypeDescription, EObject>)typePair);
        }
        return result;
    }

    private TypeDescription getTypeDescription(EObject field) {
        try {
            if (field instanceof DbViewFieldFieldDef) {
                return ((DbViewFieldFieldDef)field).getType();
            }
            if (field instanceof QuerySchemaExpression && ((QuerySchemaExpression)field).getExpression() != null) {
                return ((QuerySchemaExpression)field).getType(this.checker);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

