/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql.translator;

import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bm.xtext.BmAwareResourceSetProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.metadata.dbview.DbViewDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewElement;
import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldFieldDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldTableDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewSelectDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewSelectParamDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewSelectParamVariant;
import com._1c.g5.v8.dt.metadata.dbview.DbViewTableDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewVirtualFieldDef;
import com._1c.g5.v8.dt.metadata.mdclass.BasicFeature;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.PredefinedItem;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.dcs.serializer.DcsInternalizeTokenProvider;
import com._1c.g5.v8.dt.ql.model.AbstractExpression;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaPresentation;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaSource;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.CommonExpression;
import com._1c.g5.v8.dt.ql.model.DbViewDescriptionTempTable;
import com._1c.g5.v8.dt.ql.model.DbViewFieldFieldDefFromQuery;
import com._1c.g5.v8.dt.ql.model.DbViewFromQuery;
import com._1c.g5.v8.dt.ql.model.DbViewNestedTableFromQuery;
import com._1c.g5.v8.dt.ql.model.DbViewOuterParamTable;
import com._1c.g5.v8.dt.ql.model.FieldWithCasting;
import com._1c.g5.v8.dt.ql.model.FunctionExpression;
import com._1c.g5.v8.dt.ql.model.FunctionInvocationExpression;
import com._1c.g5.v8.dt.ql.model.LogicalCompareOperatorExpression;
import com._1c.g5.v8.dt.ql.model.MultiPartCommonExpression;
import com._1c.g5.v8.dt.ql.model.MultiPartQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.NestedTableExpression;
import com._1c.g5.v8.dt.ql.model.NumberLiteralExpression;
import com._1c.g5.v8.dt.ql.model.ParameterExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchemaNestedQuery;
import com._1c.g5.v8.dt.ql.model.QuerySchemaOperator;
import com._1c.g5.v8.dt.ql.model.QuerySchemaSelectQuery;
import com._1c.g5.v8.dt.ql.model.QuerySchemaSource;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTableParameter;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTempTableDescription;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTotalControlPoint;
import com._1c.g5.v8.dt.ql.model.SinglePartCommonExpression;
import com._1c.g5.v8.dt.ql.model.SinglePartQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.StarExpression;
import com._1c.g5.v8.dt.ql.model.StringLiteralExpression;
import com._1c.g5.v8.dt.ql.model.UnresolvedDbView;
import com._1c.g5.v8.dt.ql.model.ValueLiteralExpression;
import com._1c.g5.v8.dt.ql.resource.QlMapper;
import com._1c.g5.v8.dt.ql.serializer.InternalizeTokenProvider;
import com._1c.g5.v8.dt.ql.typesystem.IDynamicDbViewFieldComputer;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.internal.ql.QlPlugin;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.platform.ITranslateV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.ql.QlPredefinedValueProvider;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.ql.QuerySelectedFieldComputer;
import com.e1c.langtool.v8.dt.ql.settings.QlFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedNameTranslationService;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;

public class QlTextProcessor
extends MultiTextEditParseTreeVisitor {
    private static final String HASH_SYMBOL = "#";
    private static final String REF_RU_UPPERCASE = "\u0421\u0421\u042b\u041b\u041a\u0410";
    private static final String SKIP_SYMBOLS_REGEX = "^[(\\)\\\"+-\\/\\\\=\\{\\}*\\%&\\.\\,\\<\\>0-9]+$";
    private static final Pattern SKIP_SYMBOLS_PATTERN = Pattern.compile("^[(\\)\\\"+-\\/\\\\=\\{\\}*\\%&\\.\\,\\<\\>0-9]+$");
    protected final EObject root;
    protected final Map<EObject, String> translationCache = new ConcurrentHashMap<EObject, String>();
    private final IProjectTranslationProvider translationProvider;
    private IDynamicDbViewFieldComputer dynamicDbViewFieldComputer;
    @Inject
    private QlPredefinedValueProvider qlPredefinedValueProvider;
    @Inject
    private QlMapper qlMapper;
    @Inject
    private IBmModelManager modelManager;
    @Inject
    protected IResourceLookup resourceLookup;
    private final IDependentQuerySchemaProvider dependentModelProvider;
    protected BmAwareResourceSetProvider resourceSetProvider;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private IComputedNameTranslationService computedNameTranslationService;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private InternalizeDbViewTermsProvider dbViewTermsProvider;
    private InternalizeTokenProvider internalizeTokenProvider;
    private final QuerySelectedFieldComputer querySelectedFieldComputer;
    private final boolean isDcs;
    private final Set<Integer> processedNode;
    private final MultiTextEdit edit;
    private List<Map<String, String>> fieldMaps = Lists.newArrayList();
    private final ITranslatedV8Project project;
    private final CancelIndicator cancelIndicator;
    private IFile resourceFile;

    protected QlTextProcessor(MultiTextEdit edit, String queryText, EObject root, boolean isDcs, IProjectTranslationProvider translationProvider, CancelIndicator cancelIndicator, IResourceServiceProvider rsp, IDependentQuerySchemaProvider dependentModelProvider) {
        super(edit);
        this.root = root;
        this.dependentModelProvider = dependentModelProvider;
        this.isDcs = isDcs;
        this.translationProvider = translationProvider;
        this.project = translationProvider.getProject();
        this.cancelIndicator = cancelIndicator;
        this.dynamicDbViewFieldComputer = (IDynamicDbViewFieldComputer)rsp.get(IDynamicDbViewFieldComputer.class);
        this.querySelectedFieldComputer = (QuerySelectedFieldComputer)QlPlugin.getDefault().getInjector().getInstance(QuerySelectedFieldComputer.class);
        this.internalizeTokenProvider = this.isDcs ? (InternalizeTokenProvider)rsp.get(DcsInternalizeTokenProvider.class) : (InternalizeTokenProvider)rsp.get(InternalizeTokenProvider.class);
        this.resourceSetProvider = (BmAwareResourceSetProvider)rsp.get(BmAwareResourceSetProvider.class);
        this.processedNode = new HashSet<Integer>();
        this.edit = edit;
    }

    public List<Map<String, String>> getFieldMaps() {
        return this.fieldMaps;
    }

    public void dispose() {
        this.fillFieldMaps();
        this.translationCache.clear();
        if (this.root instanceof QuerySchema) {
            QlUtil.cleanUpQueryCache((QuerySchema)this.root);
        }
    }

    private String getDuallyNamedElementName(ITranslateV8Project project, DuallyNamedElement object) {
        if (object.eIsProxy()) {
            object = (DuallyNamedElement)EcoreUtil.resolve((EObject)object, (EObject)this.root);
        }
        if (project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN)) {
            return object.getNameRu();
        }
        return object.getName();
    }

    private String getDuallyNamedElementName(DuallyNamedElement object) {
        return this.getDuallyNamedElementName((ITranslateV8Project)this.project, object);
    }

    private void fillFieldMaps() {
        if (this.root instanceof QuerySchema) {
            QuerySchema querySchema = (QuerySchema)this.root;
            List<List<EObject>> allFields = this.querySelectedFieldComputer.getSelectedFields(querySchema);
            for (List<EObject> fields : allFields) {
                Map<String, String> fieldMap = this.createFieldMap(fields);
                this.fieldMaps.add(fieldMap);
            }
        }
    }

    private Map<String, String> createFieldMap(List<EObject> fields) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        boolean isRu = this.isSourceProjectRussianScriptVariant();
        for (EObject object : fields) {
            String translation;
            DbViewFieldFieldDef field;
            if (object instanceof DbViewFieldFieldDef) {
                field = (DbViewFieldFieldDef)object;
                String source = isRu ? field.getNameRu() : field.getName();
                String translation2 = this.getReplaceText((EObject)field);
                if (!StringUtils.isNotEmpty((String)translation2) || !StringUtils.isNotEmpty((String)source)) continue;
                fieldMap.put(source, translation2);
                continue;
            }
            if (!(object instanceof QuerySchemaExpression)) continue;
            field = (QuerySchemaExpression)object;
            if (!this.translationCache.containsKey(field)) {
                translation = this.computeFieldAlias((QuerySchemaExpression)field);
                this.translationCache.put((EObject)field, translation == null ? "" : translation);
            }
            if (!StringUtils.isNotEmpty((String)(translation = this.translationCache.get(field)))) continue;
            fieldMap.put(field.getAlias(), translation);
        }
        return fieldMap;
    }

    private String computeFieldAlias(QuerySchemaExpression field) {
        String translation;
        CommonExpression table;
        String alias = field.getAlias();
        if (StringUtils.isNullOrEmpty((String)alias)) {
            return "";
        }
        AbstractExpression expression = field.getExpression();
        if (field.isComputeAlias() && expression instanceof MultiPartCommonExpression && !alias.equalsIgnoreCase(((MultiPartCommonExpression)expression).getContent())) {
            StringBuilder fieldTranslation = new StringBuilder();
            CommonExpression common = (CommonExpression)expression;
            StringBuilder content = new StringBuilder();
            while (!alias.equalsIgnoreCase(content.toString()) && common != null && common.getContent() != null && alias.contains(common.getContent())) {
                content.insert(0, common.getContent());
                String replace = this.getReplaceText((EObject)common);
                if (StringUtils.isNotEmpty((String)replace)) {
                    fieldTranslation.insert(0, replace);
                } else {
                    fieldTranslation.insert(0, common.getContent());
                }
                if (common instanceof MultiPartCommonExpression) {
                    CommonExpression source = ((MultiPartCommonExpression)common).getSourceTable();
                    if (source instanceof MultiPartCommonExpression) {
                        common = source;
                        continue;
                    }
                    if (!alias.equalsIgnoreCase(content.toString()) && alias.contains(source.getContent())) {
                        common = source;
                        continue;
                    }
                    common = null;
                    continue;
                }
                common = null;
            }
            return fieldTranslation.toString();
        }
        if (field.isComputeAlias() && expression instanceof MultiPartCommonExpression && alias.equalsIgnoreCase(((MultiPartCommonExpression)expression).getContent())) {
            String translation2 = this.translationCache.get(expression);
            if (StringUtils.isNotEmpty((String)translation2)) {
                return translation2;
            }
        } else if (field.isComputeAlias() && expression instanceof NestedTableExpression && (table = ((NestedTableExpression)expression).getTable()) instanceof MultiPartCommonExpression && alias.equalsIgnoreCase(((MultiPartCommonExpression)table).getContent()) && StringUtils.isNotEmpty((String)(translation = this.translationCache.get(table)))) {
            return translation;
        }
        return this.getReplaceText((EObject)field);
    }

    protected String getTranslation(EObject source, EFeatureSettings featureSettings) {
        String stringValue = (String)source.eGet(featureSettings.getEFeature());
        if (source instanceof SinglePartQuerySchemaTable && stringValue != null && stringValue.startsWith(HASH_SYMBOL)) {
            stringValue = stringValue.substring(1);
        }
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey(source, (FeatureSettings)featureSettings);
        ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, (FeatureSettings)featureSettings, stringValue);
        return this.translationProvider.getTranslation(source, (ContextTranslationKey)key, this.project.getDefaultLanguage());
    }

    public boolean visit(ICompositeNode node) {
        return !this.cancelIndicator.isCanceled();
    }

    public boolean visit(ILeafNode node) {
        if (node.isHidden()) {
            this.processComments(node);
            return !this.cancelIndicator.isCanceled();
        }
        String text = node.getText();
        if (this.isSkipSymbols(text)) {
            return true;
        }
        EObject grammarElement = node.getGrammarElement();
        EObject object2 = node.getSemanticElement();
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        String replace = null;
        if (object2 instanceof LogicalCompareOperatorExpression || object2 instanceof NumberLiteralExpression) {
            return true;
        }
        if (grammarElement instanceof EnumLiteralDeclaration) {
            replace = this.getReplaceText((EnumLiteralDeclaration)grammarElement);
            this.addReplaceIfNotEmpty(node, replace);
            return true;
        }
        if (!(!(grammarElement instanceof Keyword) || semanticElement instanceof MultiPartCommonExpression || semanticElement instanceof QuerySchemaExpression || semanticElement instanceof SinglePartCommonExpression || semanticElement instanceof MultiPartQuerySchemaTable || semanticElement instanceof AbstractQuerySchemaSource || semanticElement instanceof ParameterExpression)) {
            if (object2 instanceof MultiPartCommonExpression) {
                return true;
            }
            replace = this.getReplaceText((Keyword)grammarElement);
            this.addReplaceIfNotEmpty(node, replace);
            return true;
        }
        replace = this.getReplaceText(semanticElement);
        this.addReplaceIfNotEmpty(node, replace);
        return true;
    }

    protected String getReplaceText(EObject object) {
        if (object == null) {
            return null;
        }
        if (this.translationCache.containsKey(object)) {
            return this.translationCache.get(object);
        }
        String replace = null;
        if (object instanceof CommonExpression) {
            replace = this.getReplaceText((CommonExpression)object);
        } else if (object instanceof QuerySchemaExpression) {
            replace = this.getReplaceText((QuerySchemaExpression)object);
        } else if (object instanceof QuerySchemaTable) {
            replace = this.getReplaceText((QuerySchemaTable)object);
        } else if (object instanceof QuerySchemaNestedQuery) {
            replace = this.getReplaceText((QuerySchemaNestedQuery)object);
        } else if (object instanceof QuerySchemaTempTableDescription) {
            replace = this.getReplaceText((QuerySchemaTempTableDescription)object);
        } else if (object instanceof AbstractQuerySchemaPresentation) {
            replace = this.getReplaceText((AbstractQuerySchemaPresentation)object);
        } else if (object instanceof MultiPartQuerySchemaTable) {
            replace = this.getReplaceText((MultiPartQuerySchemaTable)object);
        } else if (object instanceof SinglePartQuerySchemaTable) {
            replace = this.getReplaceText((SinglePartQuerySchemaTable)object);
        } else if (object instanceof ParameterExpression) {
            replace = this.getReplaceText((ParameterExpression)object);
        } else if (object instanceof FunctionInvocationExpression) {
            replace = this.getReplaceText((FunctionInvocationExpression)object);
        } else if (object instanceof QuerySchemaTotalControlPoint) {
            replace = this.getReplaceText((QuerySchemaTotalControlPoint)object);
        } else if (object instanceof StringLiteralExpression) {
            replace = this.getReplaceText((StringLiteralExpression)object);
        } else if (object instanceof DbViewNestedTableFromQuery) {
            replace = this.getReplaceText((DbViewNestedTableFromQuery)object);
        } else if (object instanceof DbViewFromQuery) {
            replace = this.getReplaceText((DbViewFromQuery)object);
        } else if (object instanceof DbViewFieldFieldDefFromQuery) {
            replace = this.getReplaceText((DbViewFieldFieldDefFromQuery)object);
        } else if (object instanceof DbViewFieldFieldDef) {
            replace = this.getReplaceText((DbViewFieldFieldDef)object);
        } else if (object instanceof DbViewFieldTableDef) {
            replace = this.getReplaceText((DbViewFieldTableDef)object);
        } else if (object instanceof DbViewDescriptionTempTable) {
            replace = this.getReplaceText((DbViewDescriptionTempTable)object);
        } else if (object instanceof MdObject) {
            replace = this.getReplaceText((MdObject)object);
        } else if (object instanceof DuallyNamedElement) {
            replace = this.getReplaceText((DuallyNamedElement)object);
        } else {
            Pair translation = this.namedEObjectNameProvider.getTranslatedName(object, this.translationProvider);
            if (translation != null) {
                replace = (String)translation.getValue();
            } else if (QlPlugin.getDefault().isDebugging()) {
                System.err.println("QlTextProcessor: unknown replace text type: " + object.getClass().toString());
            }
        }
        this.translationCache.put(object, replace == null ? "" : replace);
        return replace;
    }

    /*
     * Unable to fully structure code
     */
    private void processComments(ILeafNode node) {
        if (!node.isHidden() || !QlUtil.isCommentNode(node) || this.processedNode.contains(node.getStartLine())) {
            return;
        }
        lines = QlUtil.getCommentBlock(node);
        text = QlUtil.getCommentText(lines);
        if (StringUtils.isBlank((String)text)) {
            return;
        }
        featureKey = QlUtil.getCommentFeatureKey(this.translationKeyProvider, this.root, text);
        contextKey = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, QlFeatureSettings.Literals.COMMENT__DESCRIPTION, text);
        parts = text.replace("\r", "").split("\n", -1);
        translation = this.translationProvider.getStoredTranslation((ContextTranslationKey)contextKey, this.project.getDefaultLanguage(), new ITranslationStorageProvider.Storage.Type[0]);
        if (translation == null || translation.isEmpty()) {
            return;
        }
        translations = translation.replace("\r", "").split("\n", -1);
        newParts = new ArrayList<String>();
        if (translations.length == parts.length) {
            newParts.addAll(List.of(translations));
        } else if (translations.length < parts.length) {
            newParts.addAll(List.of(translations));
            while (parts.length > newParts.size()) {
                newParts.add("");
            }
        } else if (translations.length > parts.length) {
            newParts.addAll(List.of(Arrays.copyOf(translations, parts.length)));
            lastIndex = newParts.size() - 1;
            sb = new StringBuilder();
            i = lastIndex;
            while (i < translations.length) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(translations[i]);
                ++i;
            }
            newParts.set(lastIndex, sb.toString());
        }
        i = 0;
        j = 0;
        ** GOTO lbl54
        {
            ++j;
            do {
                if (j < lines.size() && QlUtil.getCommentText(List.of(lines.get(j))).isEmpty()) continue block2;
                if (j < lines.size() && !parts[i].isEmpty()) {
                    line = lines.get(j++);
                    txt = line.getText().stripTrailing();
                    this.addReplace(line.getOffset() + txt.length() - parts[i].length(), parts[i], (String)newParts.get(i));
                }
                ++i;
lbl54:
                // 2 sources

            } while (i < parts.length && i < newParts.size() && j < lines.size());
        }
        lines.forEach((Consumer<ILeafNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.xtext.nodemodel.ILeafNode ), (Lorg/eclipse/xtext/nodemodel/ILeafNode;)V)((QlTextProcessor)this));
    }

    private void addReplace(int offset, String source, String replace) {
        if (!source.equals(replace)) {
            this.edit.addChild((TextEdit)new ReplaceEdit(offset, source.length(), replace));
        }
    }

    private boolean isSkipSymbols(String text) {
        return SKIP_SYMBOLS_PATTERN.matcher(text).matches() || text.equals(HASH_SYMBOL);
    }

    private String getReplaceText(DbViewFromQuery object) {
        EObject mdObject = object.getMdObject();
        if (mdObject instanceof AbstractQuerySchemaTable) {
            return this.getReplaceText(mdObject.eContainer());
        }
        if (mdObject instanceof QuerySchemaNestedQuery) {
            return this.getReplaceText(mdObject);
        }
        if (mdObject instanceof QuerySchemaSelectQuery) {
            return this.getReplaceText((EObject)((QuerySchemaSelectQuery)mdObject).getPlacementTable());
        }
        return this.getDuallyNamedElementName((DuallyNamedElement)object);
    }

    private String getReplaceText(DbViewFieldFieldDef object) {
        String replace = null;
        EObject model = this.getModelObject((DbViewElement)object);
        if (model != null && !object.equals(model)) {
            replace = this.getReplaceText(model);
        } else {
            replace = this.getDuallyNamedElementName((DuallyNamedElement)object);
            model = object;
        }
        String content = this.isSourceProjectRussianScriptVariant() ? object.getNameRu() : object.getName();
        return this.updateReplaceText((DbViewElement)object, model, content, replace);
    }

    private String getReplaceText(DbViewFieldFieldDefFromQuery object) {
        EObject model = this.getModelObject((DbViewElement)object);
        String replace = null;
        if (model != null) {
            if (model instanceof DbViewElement) {
                EObject model2 = this.getModelObject((DbViewElement)model);
                if (model2 != null) {
                    replace = this.getReplaceText(model2);
                } else {
                    replace = this.getReplaceText(model);
                    model2 = model;
                }
                String content = this.isSourceProjectRussianScriptVariant() ? object.getNameRu() : object.getName();
                return this.updateReplaceText((DbViewElement)model, model2, content, replace);
            }
            replace = this.getReplaceText(model);
        } else {
            replace = this.getDuallyNamedElementName((DuallyNamedElement)object);
        }
        String content = this.isSourceProjectRussianScriptVariant() ? object.getNameRu() : object.getName();
        return this.updateReplaceText((DbViewElement)object, model, content, replace);
    }

    private String getReplaceText(DbViewNestedTableFromQuery object) {
        EObject mdObject = object.getMdObject();
        if (mdObject != null) {
            return this.getReplaceText(mdObject.eContainer());
        }
        return this.getDuallyNamedElementName((DuallyNamedElement)object);
    }

    private String getReplaceText(DbViewFieldTableDef object) {
        EObject mdObject = object.getMdObject();
        if (mdObject != null) {
            if (mdObject instanceof MdObject) {
                String mdName = ((MdObject)mdObject).getName();
                if (!(object.getName().equalsIgnoreCase(mdName) || object.getNameRu().equalsIgnoreCase(mdName) || object.getName().equalsIgnoreCase(object.getNameRu()))) {
                    return this.getDuallyNamedElementName((DuallyNamedElement)object);
                }
            }
            return this.getReplaceText(mdObject);
        }
        return this.getDuallyNamedElementName((DuallyNamedElement)object);
    }

    private String getReplaceText(DbViewDescriptionTempTable object) {
        EObject mdObject = object.getMdObject();
        if (mdObject != null && object instanceof DbViewOuterParamTable) {
            return this.getReplaceText(mdObject);
        }
        if (mdObject != null) {
            return this.getReplaceText(mdObject.eContainer());
        }
        Set sourceObjects = this.qlMapper.getSourceObjects((EObject)object);
        if (!sourceObjects.isEmpty()) {
            EObject source = (EObject)sourceObjects.iterator().next();
            return this.getReplaceText(source);
        }
        String name = object.getName();
        QuerySchemaOperator operator = (QuerySchemaOperator)EcoreUtil2.getContainerOfType((EObject)object, QuerySchemaOperator.class);
        while (operator != null) {
            for (QuerySchemaSource source : operator.getSources()) {
                AbstractQuerySchemaTable table;
                DbViewElement dbView;
                AbstractQuerySchemaSource sourceSource = source.getSource();
                if (name == null || !name.equalsIgnoreCase(sourceSource.getAlias())) continue;
                if (sourceSource instanceof QuerySchemaTable && object.equals(dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)(table = ((QuerySchemaTable)source.getSource()).getTable()))) && (!sourceSource.isComputeAlias() || this.translationCache.containsKey(table))) {
                    return null;
                }
                return this.getReplaceText((EObject)sourceSource);
            }
            operator = (QuerySchemaOperator)EcoreUtil2.getContainerOfType((EObject)operator.eContainer(), QuerySchemaOperator.class);
        }
        return this.getDuallyNamedElementName((DuallyNamedElement)object);
    }

    private String getReplaceText(QuerySchemaTable object) {
        String alias;
        String replace;
        block9: {
            String fullTableName;
            AbstractQuerySchemaTable table;
            block10: {
                block8: {
                    if (!this.project.isChangeDefaultLanguage()) {
                        return object.getAlias();
                    }
                    replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_SOURCE__ALIAS);
                    if (StringUtils.isNotEmpty((String)replace)) {
                        return replace;
                    }
                    alias = object.getAlias();
                    table = object.getTable();
                    fullTableName = "";
                    if (table != null) {
                        fullTableName = table.getFullTableName();
                    }
                    if (alias == null || table == null || !alias.equalsIgnoreCase(table.getTableName())) break block8;
                    replace = this.getReplaceText((EObject)table);
                    break block9;
                }
                if (!(table instanceof SinglePartQuerySchemaTable) || alias != null && (!table.getTableName().startsWith(HASH_SYMBOL) || !alias.equalsIgnoreCase(table.getTableName().substring(1)))) break block10;
                replace = this.getReplaceText((SinglePartQuerySchemaTable)table);
                if (replace == null || !replace.startsWith(HASH_SYMBOL)) break block9;
                replace = replace.substring(1);
                break block9;
            }
            if (alias != null && table != null && fullTableName.replace(".", "").contains(alias)) {
                String[] sourceNameParts = fullTableName.split("\\.");
                String[] nameParts = (String[])sourceNameParts.clone();
                int index = nameParts.length - 1;
                AbstractQuerySchemaTable parentTable = table;
                while (index >= 0 && parentTable != null) {
                    String partReplace = this.getReplaceText((EObject)parentTable);
                    if (partReplace != null) {
                        nameParts[index] = partReplace;
                    }
                    if (!(parentTable instanceof MultiPartQuerySchemaTable)) break;
                    parentTable = ((MultiPartQuerySchemaTable)parentTable).getParentTable();
                    --index;
                }
                Object sourceName = "";
                Object newName = "";
                for (index = nameParts.length - 1; index >= 0; --index) {
                    if (!alias.contains(sourceNameParts[index])) continue;
                    sourceName = sourceNameParts[index] + (String)sourceName;
                    newName = nameParts[index] + (String)newName;
                    if (!alias.equalsIgnoreCase((String)sourceName)) continue;
                    replace = newName;
                    break;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return alias;
    }

    private String getReplaceText(QuerySchemaNestedQuery object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return object.getAlias();
        }
        String replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_SOURCE__ALIAS);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return object.getAlias();
    }

    private String getReplaceText(QuerySchemaTempTableDescription object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_SOURCE__ALIAS);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        String alias = object.getAlias();
        if (StringUtils.isNullOrEmpty((String)alias) || object.isComputeAlias()) {
            return replace;
        }
        ParameterExpression parameter = object.getTable();
        if (parameter != null && alias.equalsIgnoreCase(parameter.getName())) {
            replace = this.getTranslation((EObject)parameter, QlFeatureSettings.Literals.PARAMETER_EXPRESSION__NAME);
        }
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return alias;
    }

    private String getReplaceText(AbstractQuerySchemaPresentation object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_PRESENTATION__PRESENTATION);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return null;
    }

    private String getReplaceText(SinglePartQuerySchemaTable object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_TABLE__TABLE_NAME);
        if (StringUtils.isNotEmpty((String)replace)) {
            if (!this.project.isChangeDefaultLanguage()) {
                replace = object.getTableName();
            }
            if (replace.startsWith(HASH_SYMBOL)) {
                return replace.substring(1);
            }
            return replace;
        }
        DbViewElement dbView = null;
        try {
            dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)object);
        }
        catch (Exception e) {
            QlPlugin.logError(e);
        }
        if (!this.project.isChangeDefaultLanguage() && dbView instanceof DbViewDescriptionTempTable && object.getTableName().startsWith(HASH_SYMBOL)) {
            return object.getTableName().substring(1);
        }
        this.translationCache.put((EObject)object, "");
        if (QlTextProcessor.isQlObjects(dbView)) {
            replace = this.getReplaceText((EObject)dbView);
            if (replace != null && replace.startsWith(HASH_SYMBOL)) {
                replace = replace.substring(1);
            }
            return replace;
        }
        EObject model = this.getModelObject(dbView);
        if (model != null) {
            replace = this.getReplaceText(model);
        } else {
            replace = this.dbViewTermsProvider.getInternalizeEnumValue(object.getTableName(), this.project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN));
            if (StringUtils.isNotEmpty((String)replace)) {
                return replace;
            }
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
            ICompositeNode parent = node.getParent();
            EObject parentObject = NodeModelUtils.findActualSemanticObjectFor((INode)parent);
            if (parentObject instanceof MultiPartQuerySchemaTable) {
                String fullTableName = ((MultiPartQuerySchemaTable)parentObject).getFullTableName();
                String[] nameParts = fullTableName.split("\\.");
                int index = nameParts.length - 1;
                while (index >= 0) {
                    --index;
                    if (object.equals(((MultiPartQuerySchemaTable)parentObject).getParentTable())) break;
                }
                if (index >= 0 && nameParts.length > 0) {
                    dbView = null;
                    try {
                        dbView = this.dynamicDbViewFieldComputer.computeDbView(parentObject);
                    }
                    catch (Exception e) {
                        QlPlugin.logError(e);
                        return null;
                    }
                    fullTableName = this.getDuallyNamedElementName((DuallyNamedElement)dbView);
                    nameParts = fullTableName.split("\\.");
                    if (nameParts.length > index) {
                        replace = nameParts[index];
                    }
                }
            } else if (QlPlugin.getDefault().isDebugging()) {
                URI uri = EcoreUtil.getURI((EObject)object);
                System.err.println("Unknown type: " + object.getClass().toString() + ", URI: " + uri.toString());
            }
        }
        return replace;
    }

    private String getReplaceText(ParameterExpression object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.PARAMETER_EXPRESSION__NAME);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return null;
    }

    private String getReplaceText(QuerySchemaExpression object) {
        ParameterExpression parameterExpression;
        String objectAlias = object.getAlias();
        if (!(this.project.isChangeDefaultLanguage() || this.project.isChangeScriptVariant() || object.isComputeAlias())) {
            return objectAlias;
        }
        String replace = null;
        if (this.project.isChangeDefaultLanguage()) {
            replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.QUERY_SCHEMA_EXPRESSION__ALIAS);
        }
        if (StringUtils.isNotEmpty(replace)) {
            return replace;
        }
        if (StringUtils.isNullOrEmpty((String)objectAlias)) {
            return null;
        }
        AbstractExpression expression = object.getExpression();
        if (expression instanceof FieldWithCasting) {
            expression = ((FieldWithCasting)expression).getCastOperation().getExpression();
        }
        if (expression instanceof CommonExpression) {
            CommonExpression commonExpression = (CommonExpression)expression;
            if (objectAlias.equalsIgnoreCase(commonExpression.getContent())) {
                replace = this.getReplaceText((EObject)expression);
            }
        } else if (expression instanceof ParameterExpression && objectAlias.equalsIgnoreCase((parameterExpression = (ParameterExpression)expression).getName())) {
            replace = this.getTranslation((EObject)expression, QlFeatureSettings.Literals.PARAMETER_EXPRESSION__NAME);
        }
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return objectAlias;
    }

    private String getReplaceText(QuerySchemaTotalControlPoint object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.QUERY_SCHEMA_TOTAL_CONTROL_POINT__COLUMN_NAME);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return null;
    }

    private String getReplaceText(StringLiteralExpression object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return null;
        }
        String stringValue = QlUtil.getStringLiteralContent(object, false);
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)QlFeatureSettings.Literals.STRING_LITERAL_EXPRESSION__CONTENT);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, (FeatureSettings)QlFeatureSettings.Literals.STRING_LITERAL_EXPRESSION__CONTENT, stringValue);
        String translation = this.translationProvider.getStoredTranslation((ContextTranslationKey)contextKey, this.project.getDefaultLanguage(), new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNotEmpty((String)translation)) {
            return QlUtil.formatForStringLiteralContent(translation);
        }
        translation = this.computedNameTranslationService.computeTranslatedString((EObject)object, QlFeatureSettings.Literals.STRING_LITERAL_EXPRESSION__CONTENT, this.translationProvider, this.project.getDefaultLanguage());
        if (StringUtils.isNotEmpty((String)translation)) {
            return QlUtil.formatForStringLiteralContent(translation);
        }
        return null;
    }

    private EObject getModelObject(DbViewElement object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DbViewVirtualFieldDef) {
            return this.getModelObject((DbViewFieldFieldDef)((DbViewVirtualFieldDef)object));
        }
        if (object instanceof DbViewFieldFieldDefFromQuery) {
            return this.getModelObject((DbViewFieldFieldDefFromQuery)object);
        }
        if (object instanceof DbViewFieldFieldDef) {
            return this.getModelObject((DbViewFieldFieldDef)object);
        }
        if (object instanceof DbViewTableDef) {
            return this.getModelObject((DbViewTableDef)object);
        }
        if (object instanceof DbViewFieldTableDef) {
            return this.getModelObject((DbViewFieldTableDef)object);
        }
        if (QlPlugin.getDefault().isDebugging()) {
            System.err.println("QlTextProcessor: unknown model source type: " + object.getClass().toString());
        }
        return null;
    }

    private String getReplaceText(Keyword keyword) {
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        boolean isRussian = this.project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        EObject container = keyword.eContainer();
        if (container instanceof Alternatives && ((Alternatives)container).getElements().contains((Object)keyword)) {
            EObject replaceObject;
            Alternatives alternatives = (Alternatives)container;
            int shift = 0;
            for (Object element : alternatives.getElements()) {
                if (element instanceof Keyword) break;
                ++shift;
            }
            int index = alternatives.getElements().indexOf((Object)keyword);
            if (index + shift % 2 > 0) {
                --index;
            }
            if (isRussian) {
                ++index;
            }
            if ((replaceObject = (EObject)alternatives.getElements().get(index)) instanceof Keyword) {
                replace = ((Keyword)replaceObject).getValue();
            }
        }
        if (StringUtils.isNullOrEmpty(replace)) {
            replace = this.internalizeTokenProvider.getInternalizeKeyword(keyword, isRussian);
        }
        return replace;
    }

    private String getReplaceText(MdObject object) {
        if (!this.project.isChangeDefaultLanguage()) {
            return object.getName();
        }
        URI objectUri = EcoreUtil.getURI((EObject)object);
        Provider provider = () -> {
            IBmModel model = this.modelManager.getModel((EObject)object);
            if (model == null) {
                model = this.modelManager.getModel(objectUri);
            }
            if (model == null) {
                model = this.modelManager.getModel(this.getResourceFile().getProject());
            }
            IBmTransaction transaction = model.getEngine().getCurrentTransaction();
            boolean isNewTransaction = false;
            if (transaction == null) {
                transaction = model.getEngine().beginReadOnlyTransaction(true);
                isNewTransaction = true;
            }
            String replace = null;
            try {
                MdObject source = null;
                source = object.eIsProxy() ? (MdObject)transaction.getObjectByUri(objectUri) : (MdObject)transaction.toTransactionObject((EObject)object);
                Pair translation = this.namedEObjectNameProvider.getTranslatedName((EObject)source, this.translationProvider);
                if (translation != null && source.getName().equalsIgnoreCase((String)translation.getKey())) {
                    replace = (String)translation.getValue();
                }
                if (StringUtils.isNullOrEmpty(replace)) {
                    replace = source.getName();
                }
            }
            finally {
                if (isNewTransaction) {
                    transaction.commit();
                }
            }
            return replace;
        };
        ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
        return cache.getTranslation(objectUri, provider);
    }

    private String getReplaceText(DuallyNamedElement object) {
        String replace = this.getDuallyNamedElementName(object);
        if (StringUtils.isNullOrEmpty((String)replace)) {
            replace = null;
        }
        return replace;
    }

    private EObject getModelObject(DbViewFieldFieldDefFromQuery object) {
        Set sourceObjects;
        EObject mdObject = object.getMdObject();
        if (mdObject == null && !(sourceObjects = this.qlMapper.getSourceObjects((EObject)object)).isEmpty()) {
            EObject source = (EObject)sourceObjects.iterator().next();
            if (source instanceof QuerySchemaExpression && ((QuerySchemaExpression)source).getExpression() instanceof StarExpression && source.eContainer() instanceof QuerySchemaOperator) {
                QuerySchemaOperator operator = (QuerySchemaOperator)source.eContainer();
                for (DbViewDef dbView : operator.getDbViewByFrom()) {
                    EObject sourceMd = dbView.getMdObject();
                    List fields = this.dynamicDbViewFieldComputer.computeFieldsBySemanticObject(sourceMd);
                    for (DbViewElement field : fields) {
                        if (!field.getName().equalsIgnoreCase(object.getName()) && !field.getNameRu().equalsIgnoreCase(object.getName())) continue;
                        return field;
                    }
                }
            }
            return source;
        }
        return mdObject;
    }

    private EObject getModelObject(DbViewFieldFieldDef object) {
        EObject mdObject = object.getMdObject();
        if (mdObject instanceof BasicFeature) {
            return mdObject;
        }
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        if (object.eContainer() instanceof DbViewOuterParamTable) {
            return null;
        }
        return object;
    }

    private EObject getModelObject(DbViewFieldTableDef object) {
        EObject mdObject = object.getMdObject();
        if (mdObject instanceof MdObject) {
            return mdObject;
        }
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        return object;
    }

    private EObject getModelObject(DbViewTableDef object) {
        EObject mdObject = object.getMdObject();
        if (mdObject instanceof MdObject) {
            return mdObject;
        }
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        return object;
    }

    private String getReplaceText(MultiPartQuerySchemaTable object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        DbViewElement dbView = null;
        try {
            dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)object);
        }
        catch (Exception e) {
            QlPlugin.logError(e);
        }
        if (dbView == null) {
            return null;
        }
        EObject mdObject = dbView.getMdObject();
        if (mdObject != null) {
            if (object.getTableName().equalsIgnoreCase((String)mdObject.eGet((EStructuralFeature)MdClassPackage.Literals.MD_OBJECT__NAME)) && this.project.isChangeDefaultLanguage()) {
                replace = this.getReplaceText(mdObject);
            } else {
                String fullTableName = object.getFullTableName();
                String[] nameParts = fullTableName.split("\\.");
                int index = nameParts.length - 1;
                while (index >= 0) {
                    if (object.getTableName().equalsIgnoreCase(nameParts[index])) break;
                    --index;
                }
                fullTableName = this.getDuallyNamedElementName((DuallyNamedElement)dbView);
                if (dbView instanceof DbViewFieldTableDef && !fullTableName.contains("\\.")) {
                    replace = fullTableName;
                } else if (index >= 0 && nameParts.length > 0 && (nameParts = fullTableName.split("\\.")).length > index) {
                    replace = nameParts[index];
                }
            }
        } else {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
            ICompositeNode parent = node.getParent();
            EObject parentObject = NodeModelUtils.findActualSemanticObjectFor((INode)parent);
            FeatureKey preffix = this.translationKeyProvider.getKey(parentObject);
            if (parentObject instanceof MultiPartQuerySchemaTable) {
                if (QlPlugin.getDefault().isDebugging()) {
                    System.out.println(MessageFormat.format("QlTextProcessor: need to translate table: {0} key preffix {1}", EcoreUtil.getURI((EObject)parentObject), preffix));
                }
            } else if (parentObject instanceof QuerySchemaTable && QlPlugin.getDefault().isDebugging()) {
                System.out.println(MessageFormat.format("QlTextProcessor: need to translate table: {0} key preffix {1}", EcoreUtil.getURI((EObject)parentObject), preffix));
            }
        }
        if (StringUtils.isNullOrEmpty((String)replace)) {
            replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_TABLE__TABLE_NAME);
        }
        return replace;
    }

    /*
     * WARNING - void declaration
     */
    private String getReplaceText(CommonExpression object) {
        EList selectFields;
        QuerySchemaOperator operator;
        EObject model;
        ICompositeNode node;
        boolean unknown;
        String content;
        if (!this.project.isChangeScriptVariant() && !this.project.isChangeDefaultLanguage()) {
            return null;
        }
        String replace = null;
        EObject parent = object.eContainer();
        EObject parent2 = null;
        if (parent != null) {
            parent2 = parent.eContainer();
        }
        if (parent2 instanceof QuerySchemaTableParameter && object instanceof SinglePartCommonExpression) {
            QuerySchemaTable table = (QuerySchemaTable)EcoreUtil2.getContainerOfType((EObject)parent2, QuerySchemaTable.class);
            int index = table.getParameters().indexOf((Object)parent2);
            DbViewElement virtualTable = null;
            try {
                virtualTable = this.dynamicDbViewFieldComputer.computeDbView((EObject)table.getTable());
            }
            catch (Exception e) {
                QlPlugin.logError(e);
            }
            if (virtualTable instanceof DbViewSelectDef) {
                content = object.getContent();
                DbViewSelectParamDef expectedTypeParam = (DbViewSelectParamDef)((DbViewSelectDef)virtualTable).getParams().get(index);
                Optional<DbViewSelectParamVariant> variant = expectedTypeParam.getVariants().stream().filter(v -> v.getName().equalsIgnoreCase(content) || v.getNameRu().equalsIgnoreCase(content)).findFirst();
                if (variant.isPresent()) {
                    boolean isRu = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
                    return variant.map(v -> isRu ? v.getNameRu() : v.getName()).orElse(content);
                }
            }
        }
        DbViewElement dbView = null;
        try {
            dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)object);
        }
        catch (Exception e) {
            QlPlugin.logError(e);
        }
        if (dbView != null && dbView.eIsProxy()) {
            dbView = (DbViewElement)EcoreUtil.resolve((EObject)dbView, (EObject)this.root);
        }
        boolean bl = unknown = dbView instanceof UnresolvedDbView || dbView != null && dbView.eIsProxy();
        if (!(REF_RU_UPPERCASE.equalsIgnoreCase(object.getContent()) || !unknown || parent instanceof QuerySchemaExpression && parent2 instanceof QuerySchemaOperator && ((QuerySchemaOperator)parent2).getSelectFields().contains((Object)parent))) {
            node = NodeModelUtils.getNode((EObject)object);
            try {
                content = object.getContent();
                INode find = (INode)Iterables.find((Iterable)node.getAsTreeIterable(), n -> n.getGrammarElement() instanceof Keyword && n.getText().equalsIgnoreCase(content));
                if (QlPlugin.getDefault().isDebugging()) {
                    System.err.println("Found common expression as Keyword: " + find.getText());
                }
                return this.getReplaceText((Keyword)find.getGrammarElement());
            }
            catch (NoSuchElementException content2) {
                // empty catch block
            }
        }
        if (!(!QlTextProcessor.isQlObjects(dbView) || dbView instanceof DbViewFieldFieldDefFromQuery && dbView.eContainer() instanceof DbViewDescriptionTempTable || unknown)) {
            replace = this.getReplaceText((EObject)dbView);
            content = dbView;
            if (content instanceof DbViewDescriptionTempTable) {
                void descriptionTempTable;
                node = (DbViewDescriptionTempTable)content;
                DbViewDescriptionTempTable cfr_ignored_0 = (DbViewDescriptionTempTable)content;
                if (this.isReplaceSameAsDbViewName((DbViewDescriptionTempTable)descriptionTempTable, replace)) {
                    String stringValue = dbView.getName();
                    FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_TABLE__TABLE_NAME);
                    ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, (FeatureSettings)QlFeatureSettings.Literals.ABSTRACT_QUERY_SCHEMA_TABLE__TABLE_NAME, stringValue);
                    replace = this.translationProvider.getStoredTranslation((ContextTranslationKey)contextKey, this.project.getDefaultLanguage(), new ITranslationStorageProvider.Storage.Type[0]);
                }
            }
            return replace;
        }
        String content3 = object.getContent();
        if (dbView instanceof DbViewFieldTableDef && StringUtils.isNotEmpty((String)content3) && (content3.equalsIgnoreCase(dbView.getName()) || content3.equalsIgnoreCase(dbView.getNameRu()))) {
            return this.getReplaceText((DbViewFieldTableDef)dbView);
        }
        if (unknown && (object instanceof MultiPartCommonExpression || object.eContainer() instanceof MultiPartCommonExpression) && EcoreUtil2.getContainerOfType((EObject)object, ValueLiteralExpression.class) != null) {
            model = this.qlPredefinedValueProvider.computePredefinedValue((EObject)object, object.getFullContent());
            replace = this.getReplaceText(model);
            if (model instanceof MdObject || model instanceof PredefinedItem) {
                return replace;
            }
            if (model != null && StringUtils.isNotEmpty((String)replace)) {
                return this.project.isChangeScriptVariant() ? replace : content3;
            }
            boolean isRussian = this.project.isChangeScriptVariant() && this.project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN) || !this.project.isChangeScriptVariant() && this.project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH);
            replace = this.dbViewTermsProvider.getInternalizeEnumValue(content3, isRussian);
            if (StringUtils.isNotEmpty((String)replace)) {
                return this.project.isChangeScriptVariant() ? replace : content3;
            }
        }
        if ((model = this.getModelObject(dbView)) != null && !model.equals(dbView)) {
            replace = this.getReplaceText(model);
            replace = this.updateReplaceText(dbView, model, content3, replace);
            if (!this.project.isChangeDefaultLanguage() && object instanceof MultiPartCommonExpression && model instanceof MdObject) {
                return replace;
            }
        } else if (dbView instanceof DbViewFieldFieldDefFromQuery && dbView.eContainer() instanceof DbViewDescriptionTempTable) {
            model = null;
        }
        if (StringUtils.isNullOrEmpty((String)replace) && dbView != null && !(dbView instanceof UnresolvedDbView)) {
            boolean isDuallyNamed = !dbView.getName().equalsIgnoreCase(dbView.getNameRu());
            replace = this.getReplaceText((DuallyNamedElement)dbView);
            replace = !isDuallyNamed || content3 == null || content3.equalsIgnoreCase(replace) && this.project.isChangeScriptVariant() ? null : this.updateReplaceText(dbView, (EObject)dbView, content3, replace);
        }
        if (StringUtils.isNullOrEmpty((String)replace) && this.project.isChangeDefaultLanguage()) {
            replace = this.getTranslation((EObject)object, QlFeatureSettings.Literals.COMMON_EXPRESSION__CONTENT);
        }
        if (model == null && StringUtils.isNullOrEmpty((String)replace) && this.project.isChangeScriptVariant()) {
            replace = this.dbViewTermsProvider.getInternalizeEnumValue(content3, this.project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN));
        }
        if (model == null && dbView instanceof DbViewFieldFieldDefFromQuery && !this.translationCache.containsKey(dbView) && StringUtils.isNotEmpty((String)replace) && dbView.eContainer() instanceof DbViewDescriptionTempTable && (operator = (QuerySchemaOperator)EcoreUtil2.getContainerOfType((EObject)object, QuerySchemaOperator.class)) != null && (selectFields = operator.getSelectFields()).size() == 1 && ((QuerySchemaExpression)selectFields.get(0)).getExpression() instanceof StarExpression) {
            this.translationCache.put((EObject)dbView, replace);
        }
        return replace;
    }

    private boolean isReplaceSameAsDbViewName(DbViewDescriptionTempTable descriptionTempTable, String replace) {
        if (replace == null) {
            return false;
        }
        return replace.equalsIgnoreCase(descriptionTempTable.getName()) || replace.equalsIgnoreCase(descriptionTempTable.getNameRu());
    }

    private static boolean isQlObjects(DbViewElement dbView) {
        return dbView instanceof DbViewFromQuery || dbView instanceof DbViewFieldFieldDefFromQuery || dbView instanceof DbViewNestedTableFromQuery || dbView instanceof DbViewDescriptionTempTable;
    }

    private String updateReplaceText(DbViewElement dbView, EObject model, String expressionContent, String sourceReplace) {
        String replace = sourceReplace;
        String modelName = null;
        if (model instanceof DuallyNamedElement) {
            if (this.project.getSourceProject() instanceof ITranslatingConfigurationProject) {
                modelName = this.getDuallyNamedElementName((ITranslateV8Project)((ITranslatingConfigurationProject)this.project.getSourceProject()), (DuallyNamedElement)model);
            }
        } else if (model instanceof NamedElement) {
            modelName = ((NamedElement)model).getName();
        } else if (model instanceof MdObject) {
            modelName = ((MdObject)model).getName();
        }
        if (StringUtils.isNotEmpty(modelName) && !modelName.equalsIgnoreCase(expressionContent) && expressionContent.contains(modelName) && (dbView.getName().equalsIgnoreCase(expressionContent) || dbView.getNameRu().equalsIgnoreCase(expressionContent))) {
            String fullTableName = this.getDuallyNamedElementName((DuallyNamedElement)dbView);
            if (StringUtils.isNotEmpty((String)fullTableName) && StringUtils.isNotEmpty((String)modelName) && StringUtils.isNotEmpty((String)sourceReplace)) {
                replace = fullTableName.replace(modelName, sourceReplace);
            } else if (!this.project.isChangeDefaultLanguage()) {
                replace = fullTableName;
            }
        }
        return replace;
    }

    private String getReplaceText(FunctionInvocationExpression object) {
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        FunctionExpression type = object.getFunctionType();
        if (type == null) {
            return replace;
        }
        replace = this.getDuallyNamedElementName((DuallyNamedElement)type);
        return replace;
    }

    private String getReplaceText(EnumLiteralDeclaration object) {
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        EObject container = object.eContainer();
        if (container != null && container instanceof Alternatives && !container.eContents().isEmpty()) {
            EObject replaceObject;
            EList eContents = container.eContents();
            int index = -1;
            if (eContents.size() > 2) {
                index = eContents.indexOf((Object)object);
            }
            if (index <= 1) {
                index = 0;
            } else if (index % 2 > 0) {
                --index;
            }
            if (this.project.getScriptVariant() == ScriptVariant.RUSSIAN && eContents.size() > 1) {
                ++index;
            }
            if ((replaceObject = (EObject)eContents.get(index)) instanceof EnumLiteralDeclaration) {
                replace = ((EnumLiteralDeclaration)replaceObject).getLiteral().getValue();
            }
        }
        return replace;
    }

    protected IFile getResourceFile() {
        if (this.resourceFile == null) {
            EObject parent;
            QuerySchema schema = (QuerySchema)EcoreUtil2.getContainerOfType((EObject)this.root, QuerySchema.class);
            this.resourceFile = schema == null ? this.resourceLookup.getPlatformResource(this.root) : ((parent = this.dependentModelProvider.getParent(schema)) != null ? this.resourceLookup.getPlatformResource(parent) : this.resourceLookup.getPlatformResource(this.root));
        }
        return this.resourceFile;
    }

    private boolean isSourceProjectRussianScriptVariant() {
        return ((ITranslateV8Project)this.project.getSourceProject()).getScriptVariant() == ScriptVariant.RUSSIAN;
    }

    private /* synthetic */ void lambda$0(ILeafNode n) {
        boolean bl = this.processedNode.add(n.getStartLine());
    }
}

