/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db;

import com.e1c.langtool.history.db.Context;
import com.e1c.langtool.history.db.IProjectTranslation;

public final class ProjectTranslation
implements IProjectTranslation {
    private final String language;
    private final String storageId;
    private final String resourceId;
    private final String featureKey;
    private final String featureName;
    private final String value;
    private final String translation;
    private final String projectPath;
    private final Context context;

    private ProjectTranslation(Builder builder) {
        this.language = builder.language;
        this.storageId = builder.storageId;
        this.resourceId = builder.resourceId;
        this.featureKey = builder.featureKey;
        this.featureName = builder.featureName;
        this.value = builder.value;
        this.translation = builder.translation;
        this.projectPath = builder.projectPath;
        this.context = builder.context;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getStorageId() {
        return this.storageId;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public String getProjectName() {
        return this.projectPath;
    }

    @Override
    public String getTranslation() {
        return this.translation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.featureKey == null ? 0 : this.featureKey.hashCode());
        result = 31 * result + (this.featureName == null ? 0 : this.featureName.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.projectPath == null ? 0 : this.projectPath.hashCode());
        result = 31 * result + (this.storageId == null ? 0 : this.storageId.hashCode());
        result = 31 * result + (this.translation == null ? 0 : this.translation.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectTranslation other = (ProjectTranslation)obj;
        if (this.context != other.context) {
            return false;
        }
        if (this.featureKey == null ? other.featureKey != null : !this.featureKey.equals(other.featureKey)) {
            return false;
        }
        if (this.featureName == null ? other.featureName != null : !this.featureName.equals(other.featureName)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        if (this.projectPath == null ? other.projectPath != null : !this.projectPath.equals(other.projectPath)) {
            return false;
        }
        if (this.storageId == null ? other.storageId != null : !this.storageId.equals(other.storageId)) {
            return false;
        }
        if (this.translation == null ? other.translation != null : !this.translation.equals(other.translation)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "ProjectTranslation [value=" + this.value + ", translation=" + this.translation + ", language=" + this.language + ", resourceId=" + this.resourceId + "]";
    }

    public static final class Builder {
        private String language;
        private String storageId;
        private String resourceId;
        private String featureKey;
        private String featureName;
        private String value;
        private String translation;
        private String projectPath;
        private Context context;

        public static Builder of(IProjectTranslation trans) {
            return new Builder(trans.getValue(), trans.getTranslation(), trans.getLanguage()).resourceId(trans.getResourceId()).storageId(trans.getStorageId()).featureKey(trans.getFeatureKey()).featureName(trans.getFeatureName()).projectName(trans.getProjectName()).context(trans.getContext());
        }

        public Builder(String sourceValue, String translatedValue, String lang) {
            this.value = sourceValue;
            this.translation = translatedValue;
            this.language = lang;
        }

        public Builder resourceId(String val) {
            this.resourceId = val;
            return this;
        }

        public Builder storageId(String val) {
            this.storageId = val;
            return this;
        }

        public Builder featureKey(String val) {
            this.featureKey = val;
            return this;
        }

        public Builder featureName(String val) {
            this.featureName = val;
            return this;
        }

        public Builder projectName(String val) {
            this.projectPath = val;
            return this;
        }

        public Builder context(Context val) {
            this.context = val;
            return this;
        }

        public ProjectTranslation build() {
            return new ProjectTranslation(this);
        }
    }
}

