/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db.pagination;

import com.e1c.langtool.history.db.pagination.IPage;
import com.e1c.langtool.history.db.pagination.IPageable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Page<T>
implements IPage<T> {
    private final long total;
    private final IPageable pageable;
    private final List<T> content = new ArrayList<T>();

    public Page(List<T> content, IPageable pageable, long total) {
        if (pageable.getSize() < 0 || total < 0L) {
            throw new IllegalArgumentException("Pageable size and total size must be positive.");
        }
        if ((long)(pageable.getSize() * (pageable.getNumber() - 1)) > total) {
            throw new IllegalArgumentException("Pageable size must be no more than total size");
        }
        try {
            this.content.addAll(content.subList(0, Math.min(content.size(), pageable.getSize())));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Content must have size no less then pageable size.");
        }
        this.pageable = pageable;
        this.total = total;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public int getSize() {
        return this.pageable.getSize();
    }

    @Override
    public int getNumber() {
        return this.pageable.getNumber();
    }

    @Override
    public int getContentSize() {
        return this.content.size();
    }

    @Override
    public long getTotalSize() {
        return this.total;
    }

    @Override
    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public IPageable getPageable() {
        return this.pageable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.pageable == null ? 0 : this.pageable.hashCode());
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.pageable == null ? other.pageable != null : !this.pageable.equals(other.pageable)) {
            return false;
        }
        return this.total == other.total;
    }

    public String toString() {
        return "Page [total=" + this.total + ", pageable=" + String.valueOf(this.pageable) + ", content=" + String.valueOf(this.content) + "]";
    }
}

