/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db.pagination;

import com.e1c.langtool.history.db.pagination.IPage;
import com.e1c.langtool.history.db.pagination.IPageLoader;
import com.e1c.langtool.history.db.pagination.IPageable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PageIterator<T>
implements Iterator<IPage<T>> {
    private final IPageLoader<T> pageLoader;
    private IPageable pageable;
    private final long totalSize;

    public PageIterator(IPageLoader<T> pageLoader, IPageable pageable, long totalSize) {
        this.pageLoader = pageLoader;
        this.pageable = pageable;
        this.totalSize = totalSize;
    }

    @Override
    public boolean hasNext() {
        return (long)(this.pageable.getSize() * (this.pageable.getNumber() - 1)) < this.totalSize;
    }

    @Override
    public IPage<T> next() {
        if ((long)(this.pageable.getSize() * (this.pageable.getNumber() - 1)) >= this.totalSize) {
            throw new NoSuchElementException();
        }
        IPage<T> page = this.pageLoader.load(this.pageable);
        this.pageable = this.pageable.getNext();
        return page;
    }
}

