/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.db.service;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.history.db.GroupedTranslation;
import com.e1c.langtool.history.db.HistoryDataBaseException;
import com.e1c.langtool.history.db.IProjectTranslation;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.db.ProjectTranslation;
import com.e1c.langtool.history.db.pagination.IPage;
import com.e1c.langtool.history.db.pagination.IPageable;
import com.e1c.langtool.history.db.pagination.Page;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.internal.history.db.entity.Language;
import com.e1c.langtool.internal.history.db.entity.Project;
import com.e1c.langtool.internal.history.db.entity.Storage;
import com.e1c.langtool.internal.history.db.entity.Translation;
import com.e1c.langtool.internal.history.db.service.EntityManagerFactoryConfigurer;
import com.e1c.langtool.internal.history.db.service.ExpressionToPredicateVisitor;
import com.e1c.langtool.internal.history.db.service.ExpressionToSqlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public final class ProjectTranslationStorage
implements IProjectTranslationStorage {
    private volatile EntityManagerFactory emf;

    public void activate() {
    }

    public void deactivate() {
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
    }

    @Override
    public List<IProjectTranslation> getTranslations(IExpression expression) {
        return this.safeGet((em, xt) -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Translation.class);
            ExpressionToPredicateVisitor.Context context = new ExpressionToPredicateVisitor.Context(query, cb);
            ExpressionToPredicateVisitor visitor = new ExpressionToPredicateVisitor(context);
            expression.accept(visitor);
            javax.persistence.criteria.Predicate predicate = visitor.getPredicate();
            TypedQuery typedQuery = em.createQuery(query.select(context.getTranslationRoot()).where((Expression)predicate));
            List res = typedQuery.getResultList().stream().map(this::convertFrom).collect(Collectors.toList());
            return res;
        });
    }

    @Override
    public IPage<IProjectTranslation> getTranslations(IExpression expression, IPageable pageRequest) {
        return this.safeGet((em, xt) -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Translation.class);
            ExpressionToPredicateVisitor.Context context = new ExpressionToPredicateVisitor.Context(query, cb);
            ExpressionToPredicateVisitor visitor = new ExpressionToPredicateVisitor(context);
            expression.accept(visitor);
            javax.persistence.criteria.Predicate predicate = visitor.getPredicate();
            TypedQuery typedQuery = em.createQuery(query.select(context.getTranslationRoot()).where((Expression)predicate));
            int offset = pageRequest.getSize() * (pageRequest.getNumber() - 1);
            int limit = pageRequest.getSize();
            typedQuery.setFirstResult(offset);
            typedQuery.setMaxResults(limit);
            List res = typedQuery.getResultList().stream().map(this::convertFrom).collect(Collectors.toList());
            CriteriaQuery countQuery = cb.createQuery(Long.class);
            countQuery.select((Selection)cb.count((Expression)context.getTranslationRoot().get("id"))).where((Expression)predicate);
            Long totalCount = (Long)em.createQuery(countQuery).getSingleResult();
            return new Page(res, pageRequest, totalCount);
        });
    }

    @Override
    public List<IProjectTranslationStorage.IGroupedTranslation> getGroupedTranslations(IExpression expression) {
        ExpressionToSqlVisitor visitor = new ExpressionToSqlVisitor();
        expression.accept(visitor);
        String sql = visitor.getQuery().toString();
        return this.safeGet((em, tx) -> {
            Query groupQuery = em.createNativeQuery(sql);
            List rows = groupQuery.getResultList();
            List<Object> res = new ArrayList();
            res = rows.stream().map(cols -> new GroupedTranslation((String)cols[0], (Long)cols[1])).collect(Collectors.toList());
            return res;
        });
    }

    @Override
    public void addTranslation(IProjectTranslation translation) {
        this.safeExec((em, tx) -> {
            tx.begin();
            Storage storage = this.getOrCreateStorage((EntityManager)em, translation.getStorageId());
            Project project = this.getOrCreateProject((EntityManager)em, translation.getProjectName());
            Language language = this.getOrCreateLanguage((EntityManager)em, translation.getLanguage());
            Translation entity = new Translation();
            entity.setContext(translation.getContext());
            entity.setResourceId(translation.getResourceId());
            entity.setFeatureKey(translation.getFeatureKey());
            entity.setFeatureName(translation.getFeatureName());
            entity.setValue(translation.getValue());
            entity.setTranslatedValue(translation.getTranslation());
            entity.setLanguage(language);
            entity.setStorage(storage);
            entity.setProject(project);
            entity.setNormalizedValue(StringUtils.nameToText((String)translation.getValue()));
            em.persist((Object)entity);
            tx.commit();
        });
    }

    @Override
    public void deleteTranslations(IExpression expression, Predicate<? super IProjectTranslation> filter) {
        this.safeExec((em, tx) -> {
            tx.begin();
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Translation.class);
            ExpressionToPredicateVisitor.Context context = new ExpressionToPredicateVisitor.Context(query, cb);
            ExpressionToPredicateVisitor visitor = new ExpressionToPredicateVisitor(context);
            expression.accept(visitor);
            javax.persistence.criteria.Predicate predicate2 = visitor.getPredicate();
            TypedQuery typedQuery = em.createQuery(query.select(context.getTranslationRoot()).where((Expression)predicate2));
            typedQuery.getResultList().forEach(trans -> {
                if (filter.test(this.convertFrom((Translation)trans))) {
                    em.remove(trans);
                }
            });
            tx.commit();
        });
    }

    @Override
    public void deleteTranslations(IExpression expression) {
        this.safeExec((em, tx) -> {
            tx.begin();
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Translation.class);
            ExpressionToPredicateVisitor.Context context = new ExpressionToPredicateVisitor.Context(query, cb);
            ExpressionToPredicateVisitor visitor = new ExpressionToPredicateVisitor(context);
            expression.accept(visitor);
            javax.persistence.criteria.Predicate predicate = visitor.getPredicate();
            TypedQuery typedQuery = em.createQuery(query.select(context.getTranslationRoot()).where((Expression)predicate));
            typedQuery.getResultList().forEach(arg_0 -> ((EntityManager)em).remove(arg_0));
            tx.commit();
        });
    }

    @Override
    public void deleteByProject(String projectName) {
        this.safeExec((em, tx) -> {
            tx.begin();
            TypedQuery query = em.createQuery("select p from Project p where p.name like :name", Project.class);
            query.setParameter("name", (Object)projectName);
            query.getResultList().stream().findFirst().ifPresent(arg_0 -> ((EntityManager)em).remove(arg_0));
            tx.commit();
        });
    }

    @Override
    public List<String> getLanguages() {
        return this.safeGet((em, tx) -> {
            TypedQuery query = em.createQuery("SELECT lang FROM Language lang", Language.class);
            return query.getResultList().stream().map(Language::getCode).collect(Collectors.toList());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManager getEntityManager() {
        if (this.emf == null) {
            ProjectTranslationStorage projectTranslationStorage = this;
            synchronized (projectTranslationStorage) {
                if (this.emf == null) {
                    this.emf = EntityManagerFactoryConfigurer.create();
                }
            }
        }
        return this.emf.createEntityManager();
    }

    private void safeExec(BiConsumer<EntityManager, EntityTransaction> executor) {
        this.safeGet((em, tx) -> {
            executor.accept((EntityManager)em, (EntityTransaction)tx);
            return null;
        });
    }

    private <T> T safeGet(BiFunction<EntityManager, EntityTransaction, T> executor) {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            T t = executor.apply(em, tx);
            return t;
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw new HistoryDataBaseException(e);
        }
        finally {
            em.close();
        }
    }

    private Language getOrCreateLanguage(EntityManager em, String language) {
        this.exclusiveLockTable(em, "Language");
        TypedQuery query = em.createQuery("SELECT lng FROM Language lng WHERE lng.code = :code", Language.class);
        query.setParameter("code", (Object)language);
        return query.getResultList().stream().findFirst().orElseGet(() -> {
            Language lang = new Language(language);
            em.persist((Object)lang);
            return lang;
        });
    }

    private Storage getOrCreateStorage(EntityManager em, String storageId) {
        this.exclusiveLockTable(em, "Storage");
        TypedQuery query = em.createQuery("SELECT s FROM Storage s WHERE s.storageId = :storageId", Storage.class);
        query.setParameter("storageId", (Object)storageId);
        return query.getResultList().stream().findFirst().orElseGet(() -> {
            Storage storage = new Storage(storageId);
            em.persist((Object)storage);
            return storage;
        });
    }

    private Project getOrCreateProject(EntityManager em, String projectName) {
        this.exclusiveLockTable(em, "Project");
        TypedQuery query = em.createQuery("SELECT p FROM Project p WHERE p.name = :name", Project.class);
        query.setParameter("name", (Object)projectName);
        return query.getResultList().stream().findFirst().orElseGet(() -> {
            Project project = new Project(projectName);
            em.persist((Object)project);
            return project;
        });
    }

    private void exclusiveLockTable(EntityManager em, String table) {
        Query lock = em.createNativeQuery(String.format("UPDATE %s SET ID=0 WHERE 1=0", table));
        lock.executeUpdate();
    }

    private ProjectTranslation convertFrom(Translation trans) {
        return new ProjectTranslation.Builder(trans.getValue(), trans.getTranslatedValue(), trans.getLanguage().getCode()).featureKey(trans.getFeatureKey()).featureName(trans.getFeatureName()).context(trans.getContext()).resourceId(trans.getResourceId()).storageId(trans.getStorage().getStorageId()).projectName(trans.getProject().getName()).build();
    }
}

