/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.flags.ui;

import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.internal.flags.ui.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class FlagsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.flags.ui";
    private static FlagsPlugin plugin;
    private volatile Injector injector;
    private BundleContext bundleContext;

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        FlagsPlugin.log(FlagsPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.bundleContext = null;
        super.stop(context);
    }

    public static FlagsPlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        SharedImages.initializeImageRegistry(reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<FlagsPlugin> clazz = FlagsPlugin.class;
        synchronized (FlagsPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule((Plugin)this)});
        }
        catch (Exception e) {
            FlagsPlugin.log(FlagsPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    public IPreferenceStore getPreferenceStore(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)projectScope, PLUGIN_ID);
        store.setSearchContexts(new IScopeContext[]{projectScope, InstanceScope.INSTANCE});
        return store;
    }
}

