/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.extension.check;

import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.form.service.extension.ExtensionEqualityHelper;
import com._1c.g5.v8.dt.md.extension.adopt.IModelObjectAdopter;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.extension.check.Messages;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class BaseFormEqualityCheck
extends BasicCheck {
    private static final String CHECK_ID = "extension-base-form-equality";
    private final IV8ProjectManager v8ProjectManager;
    private final IModelObjectAdopter modelObjectAdopter;

    @Inject
    public BaseFormEqualityCheck(IV8ProjectManager v8ProjectManager, IModelObjectAdopter modelObjectAdopter) {
        this.v8ProjectManager = v8ProjectManager;
        this.modelObjectAdopter = modelObjectAdopter;
    }

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.BaseFormEqualityCheck_title).description(Messages.BaseFormEqualityCheck_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.CRITICAL).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.ERROR).topObject(FormPackage.Literals.FORM).checkTop();
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Form form = (Form)object;
        if (form.getBaseForm() != null || !(this.v8ProjectManager.getProject((EObject)form) instanceof IExtensionProject)) {
            return;
        }
        Form sourceForm = (Form)this.modelObjectAdopter.getSource((EObject)form);
        if (sourceForm == null) {
            return;
        }
        ExtensionEqualityHelper equalityHelper = new ExtensionEqualityHelper();
        if (!monitor.isCanceled() && !equalityHelper.equals((EObject)form, (EObject)sourceForm)) {
            resultAcceptor.addIssue(Messages.BaseFormEqualityCheck_Extension_base_form_is_different_from_configuration_form__must_be_updated);
        }
    }
}

