/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.extension;

import com._1c.g5.modeling.xml.AbstractXmlResource;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.sync.SynchronizableProject;
import com.e1c.langtool.v8.dt.extension.ITranslatingExtensionProject;
import com.e1c.langtool.v8.dt.internal.extension.ExtPlugin;
import com.e1c.langtool.v8.dt.internal.extension.TranslatedExtensionProject;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.platform.AbstractTranslateV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.e1c.langtool.v8.dt.projectsettings.TranslatedProjectManifest;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedExtensionProject;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TranslatingExtensionProject
extends AbstractTranslateV8Project
implements ITranslatingExtensionProject,
SynchronizableProject {
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private Provider<ResourceSetImpl> resourceSetProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    private IResourceChangeListener projectManifestChangeListener = new ProjectManifestChangeListener();
    private volatile List<TranslateLanguage> modelLanguages;
    private volatile List<TranslateLanguage> allLanguages;
    private volatile List<V8TranslatedExtensionProject> v8TranslatedProjects;
    private volatile List<ITranslatedProject> translatedProjects;
    private volatile TranslateLanguage defaultLanguage;

    public TranslatingExtensionProject(IProject project) {
        super(project);
    }

    public List<TranslateLanguage> getModelLanguages() {
        if (this.modelLanguages == null) {
            ArrayList<TranslateLanguage> languageList = new ArrayList<TranslateLanguage>();
            for (TranslateLanguage language : this.getInterfaceLanguages()) {
                if (!language.getOption().equals((Object)TranslationOption.MODEL_AND_INTERFACE)) continue;
                languageList.add(language);
            }
            this.modelLanguages = ImmutableList.copyOf(languageList);
        }
        return this.modelLanguages;
    }

    public List<TranslateLanguage> getInterfaceLanguages() {
        if (this.allLanguages == null) {
            this.readProjectManifestFile();
        }
        return this.allLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITranslatedProject> getTranslatedProjects() {
        if (this.translatedProjects == null) {
            if (this.v8TranslatedProjects == null) {
                this.readProjectManifestFile();
            }
            TranslatingExtensionProject translatingExtensionProject = this;
            synchronized (translatingExtensionProject) {
                this.translatedProjects = this.v8TranslatedProjects.stream().map(settingsProject -> {
                    IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(settingsProject.getName());
                    TranslatedExtensionProject project = new TranslatedExtensionProject(oldProject, (V8TranslatedExtensionProject)settingsProject, this);
                    ExtPlugin.getDefault().getInjector().injectMembers((Object)project);
                    return project;
                }).collect(Collectors.toList());
            }
        }
        return this.translatedProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslateLanguage getDefaultLanguage() {
        if (this.defaultLanguage == null) {
            TranslatingExtensionProject translatingExtensionProject = this;
            synchronized (translatingExtensionProject) {
                Language language = this.getConfiguration() == null ? this.loadFromConfiguration() : this.getConfiguration().getDefaultLanguage();
                this.defaultLanguage = this.getDefaultLanguageFromSettings(language);
                if (this.defaultLanguage == null && language != null) {
                    V8TranslateLanguage v8Lang = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
                    v8Lang.setOption(TranslationOption.MODEL_AND_INTERFACE);
                    LanguageUtil.copyLanguageContent((Language)language, (V8TranslateLanguage)v8Lang);
                    this.defaultLanguage = v8Lang;
                }
            }
        }
        return this.defaultLanguage;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurationProvider.getConfiguration(this.getProject());
    }

    public boolean isTranslating() {
        return !this.getInterfaceLanguages().isEmpty();
    }

    @Override
    public ITranslatingConfigurationProject getTranslatingConfigurationProject() {
        IProject baseProject;
        IV8Project v8project = this.v8ProjectManager.getProject(this.getProject());
        if (v8project instanceof IExtensionProject && (baseProject = ((IExtensionProject)v8project).getParentProject()) != null && this.translatingProjectManager.getProject(baseProject) instanceof ITranslatingConfigurationProject) {
            return (ITranslatingConfigurationProject)this.translatingProjectManager.getProject(baseProject);
        }
        return null;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.projectManifestChangeListener);
        this.resetProjectManifest();
        super.dispose();
    }

    private Language loadFromConfiguration() {
        URI uri;
        Resource resource;
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        IFile file = this.getProject().getFile("src/Configuration/Configuration.mdo");
        if (file.exists() && !(resource = resourceSet.getResource(uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)).getContents().isEmpty()) {
            EObject obj;
            Object language;
            if (resource instanceof AbstractXmlResource) {
                ((AbstractXmlResource)resource).setLinker(null);
            }
            if ((language = (obj = (EObject)resource.getContents().get(0)).eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__DEFAULT_LANGUAGE, true)) instanceof Language) {
                if (((Language)language).eIsProxy()) {
                    String fragment = EcoreUtil.getURI((EObject)((Language)language)).fragment();
                    String defaultLanguageName = this.extractLanguageNameFromUriFragment(fragment);
                    EList languages = (EList)obj.eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__LANGUAGES, true);
                    for (Language lang : languages) {
                        if (!lang.getName().equals(defaultLanguageName)) continue;
                        return lang;
                    }
                } else {
                    return (Language)language;
                }
            }
        }
        return null;
    }

    private TranslateLanguage getDefaultLanguageFromSettings(Language defaultLanguage) {
        if (defaultLanguage instanceof TranslateLanguage) {
            return (TranslateLanguage)defaultLanguage;
        }
        if (defaultLanguage == null) {
            return null;
        }
        for (TranslateLanguage language : this.getInterfaceLanguages()) {
            if (!defaultLanguage.getUuid().equals(language.getUuid()) || !defaultLanguage.getLanguageCode().equals(language.getLanguageCode())) continue;
            return language;
        }
        return null;
    }

    protected synchronized void readProjectManifestFile() {
        this.modelLanguages = null;
        this.defaultLanguage = null;
        this.translatedProjects = null;
        List loadedLanguages = TranslateLanguageManifest.loadAllIfAccessible((IProject)this.getProject());
        List loadedProjects = TranslatedProjectManifest.loadAllIfAccessible((IProject)this.getProject());
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && !project.getName().equals(this.getProject().getName()) && this.checkProjectAsDependent(project)) {
                loadedLanguages.addAll(this.readLanguagesFromExternalProject(project));
            }
            ++n2;
        }
        Collections.sort(loadedLanguages, (l1, l2) -> l1.getName().compareTo(l2.getName()));
        Collections.sort(loadedProjects, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        this.allLanguages = ImmutableList.copyOf((Collection)loadedLanguages);
        this.v8TranslatedProjects = ImmutableList.copyOf((Collection)loadedProjects.stream().filter(V8TranslatedExtensionProject.class::isInstance).map(V8TranslatedExtensionProject.class::cast).collect(Collectors.toList()));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.projectManifestChangeListener);
    }

    private String extractLanguageNameFromUriFragment(String fragment) {
        String preffix = "::Language.";
        int index = fragment.indexOf("::Language.");
        if (index > -1 && fragment.length() > index + "::Language.".length()) {
            return fragment.substring(index + "::Language.".length());
        }
        return null;
    }

    private boolean checkProjectAsDependent(IProject project) {
        if (DependentManifestUtils.checkManifest((IProject)project)) {
            try {
                IProject sourceProject = DependentManifestUtils.readManifest((IProject)project, (IProgressMonitor)new NullProgressMonitor());
                if (sourceProject.getName().equals(this.getProject().getName())) {
                    return true;
                }
            }
            catch (ManifestException e) {
                ExtPlugin.logError(e);
            }
        }
        return false;
    }

    private Collection<V8TranslateLanguage> readLanguagesFromExternalProject(IProject project) {
        try {
            return TranslateLanguageManifest.loadAllIfAccessible((IProject)project);
        }
        catch (ManifestException e) {
            ExtPlugin.logError(e);
            return Collections.emptyList();
        }
    }

    protected synchronized void resetProjectManifest() {
        this.modelLanguages = null;
        this.defaultLanguage = null;
        this.translatedProjects = null;
        this.allLanguages = null;
        this.v8TranslatedProjects = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.projectManifestChangeListener);
    }

    private class ProjectManifestChangeListener
    implements IResourceChangeListener {
        private ProjectManifestChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (TranslatingExtensionProject.this.allLanguages == null && TranslatingExtensionProject.this.v8TranslatedProjects == null || event == null) {
                return;
            }
            if (event.getType() != 1) {
                return;
            }
            if (event.getDelta() == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta.getResource() instanceof IProject && TranslatingExtensionProject.this.getProject().equals((Object)delta.getResource())) {
                    IResourceDelta resourceDelta = delta.findMember(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
                    if (resourceDelta != null) {
                        TranslatingExtensionProject.this.resetProjectManifest();
                        return;
                    }
                    resourceDelta = delta.findMember((IPath)new Path("DT-INF"));
                    if (resourceDelta != null) {
                        TranslatingExtensionProject.this.resetProjectManifest();
                        return;
                    }
                }
                ++n2;
            }
        }
    }
}

