/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ls.exporter.internal;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.mcore.impl.LocalStringMapEntryImpl;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.core.ext.IBmObjectExporterExtension;
import com.e1c.langtool.v8.dt.ls.exporter.LsBmExporter;
import com.e1c.langtool.v8.dt.settings.LocalizableTopEObjects;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class LstrBasicBmObjectExporter
implements IBmObjectExporterExtension {
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private LocalizableTopEObjects localizableTopEObjects;
    private LsBmExporter lsExporter = LsBmExporter.create();

    public Collection<EClass> targets() {
        return this.localizableTopEObjects.getAllEClass();
    }

    public void beforeExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) throws CoreException {
        List<String> languageCodes = this.getLanguageCodes(file.getProject());
        if (languageCodes.isEmpty()) {
            return;
        }
        ArrayDeque<LocalStringMapEntryImpl> deleteQueue = new ArrayDeque<LocalStringMapEntryImpl>();
        TreeIterator iterator = clone.eAllContents();
        while (iterator.hasNext()) {
            EObject content = (EObject)iterator.next();
            if (!(content instanceof LocalStringMapEntryImpl) || !languageCodes.contains(((LocalStringMapEntryImpl)content).getTypedKey())) continue;
            deleteQueue.add((LocalStringMapEntryImpl)content);
        }
        while (!deleteQueue.isEmpty()) {
            LocalStringMapEntryImpl item = (LocalStringMapEntryImpl)deleteQueue.remove();
            item.getEMap().removeKey((Object)item.getTypedKey());
        }
    }

    public void afterExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) throws CoreException {
        this.lsExporter.export(bmObject, file, exportedExtraFiles);
    }

    protected List<String> getLanguageCodes(IProject project) {
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        ArrayList languageCodes = Lists.newArrayList();
        if (translating != null && translating.isTranslating()) {
            translating.getInterfaceLanguages().forEach(l -> languageCodes.add(l.getLanguageCode()));
        }
        return languageCodes;
    }
}

