/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ls.importer;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.provider.TransactionalBmContentImporter;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.collector.V8FeatureValue;
import com.e1c.langtool.v8.dt.format.FormatInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.format.FormatUtils;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ls.importer.Utils;
import com.e1c.langtool.v8.dt.settings.DtFeatureSettings;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractLstrContentImporter
extends TransactionalBmContentImporter {
    public static final String LSTR_EXT = "lstr";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IFeatureSettingsService featureSettingsService;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    private FormatInternalizeTokenProvider formatTokenProvider;

    @Inject
    public AbstractLstrContentImporter(IBmModelManager bmModelManager, IQualifiedNameFilePathConverter qualifiedNameFilePathConverter) {
        super(bmModelManager);
    }

    public String getPipelineSegment() {
        return "IMP_LSTR";
    }

    public Set<String> dependsOn() {
        return Collections.singleton("IMP_OTHER");
    }

    public boolean supports(IPath path) {
        String ext = path.getFileExtension();
        return ext != null && LSTR_EXT.equals(ext);
    }

    protected ITranslationStorageProvider.Storage getCurrentStorage(IProject project) {
        StorageID storageID = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
        return this.storageManager.getStorage(project, storageID);
    }

    protected void importInterfaces(EObject obj, IPath path, IProject project, ITranslationStorageProvider.Storage storage, Collection<TranslateLanguage> languages) {
        IFile file = project.getFile(path);
        TranslationProperties properties = this.preferences.getTranslationProperties(project);
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        TranslateLanguage sourceLanguage = translating.getDefaultLanguage();
        String sourceLanguageCode = sourceLanguage == null ? "" : sourceLanguage.getLanguageCode();
        Map<EObject, Collection<EStructuralFeature>> allLocalStrings = Utils.getAllLocalStrings(obj);
        for (Map.Entry<EObject, Collection<EStructuralFeature>> entry : allLocalStrings.entrySet()) {
            URI objectUri = EcoreUtil.getURI((EObject)entry.getKey());
            Language lang = entry.getKey() instanceof Language ? (Language)entry.getKey() : null;
            V8TranslateLanguage v8Lang = lang == null ? null : (V8TranslateLanguage)translating.getInterfaceLanguages().stream().filter(V8TranslateLanguage.class::isInstance).filter(l -> lang.getName().equals(l.getName())).map(V8TranslateLanguage.class::cast).findFirst().orElse(null);
            for (EStructuralFeature feature : entry.getValue()) {
                EFeatureSettings settings = this.featureSettingsService.getSettings(feature, entry.getKey());
                EMap values = (EMap)entry.getKey().eGet(feature);
                FeatureKey featureKey = this.featureKeyProvider.getFeatureKey(entry.getKey(), (FeatureSettings)settings);
                FeatureValue featureValue = new V8FeatureValue.Builder().setFeatureKey(featureKey).setFeatureSettings(settings).setValue((String)values.get((Object)sourceLanguageCode)).setFile(file).setObjectUri(objectUri).build();
                for (TranslateLanguage language : languages) {
                    String translation = storage.getTranslation(featureValue, language);
                    if (settings instanceof DtFeatureSettings && ((DtFeatureSettings)settings).isFormat()) {
                        translation = FormatUtils.processFormatContent((String)translation, (ScriptVariant)ScriptVariant.ENGLISH, (FormatInternalizeTokenProvider)this.formatTokenProvider);
                    }
                    if (StringUtils.isNotEmpty((String)translation)) {
                        values.put((Object)language.getLanguageCode(), (Object)translation);
                        continue;
                    }
                    if (v8Lang != null && lang != null && ((EMap)v8Lang.eGet(feature)).containsKey((Object)language.getLanguageCode())) {
                        values.put((Object)language.getLanguageCode(), (Object)((String)((EMap)v8Lang.eGet(feature)).get((Object)language.getLanguageCode())));
                        continue;
                    }
                    values.removeKey((Object)language.getLanguageCode());
                }
                if (!properties.fillEmptyInterfaceTranslation()) continue;
                for (TranslateLanguage language : languages) {
                    if (values.containsKey((Object)language.getLanguageCode()) && !StringUtils.isNullOrEmpty((String)((String)values.get((Object)language.getLanguageCode())))) continue;
                    AbstractLstrContentImporter.fillupEmptyInterface(properties, (EMap<String, String>)values, language);
                }
            }
        }
    }

    protected static void fillupEmptyInterface(TranslationProperties properties, EMap<String, String> values, TranslateLanguage language) {
        TranslateLanguage newLang = properties.getLanguageToFillEmptyInterfaceTranslation(language);
        if (newLang == null) {
            return;
        }
        HashSet checked = Sets.newHashSet((Object[])new String[]{language.getLanguageCode()});
        while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
            String value = (String)values.get((Object)newLang.getLanguageCode());
            if (StringUtils.isNullOrEmpty((String)value)) {
                checked.add(newLang.getLanguageCode());
                newLang = properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                continue;
            }
            values.put((Object)language.getLanguageCode(), (Object)value);
            return;
        }
    }

    protected byte[] handleResourceCreationOrModification(IBmPlatformTransaction transaction, IBmNamespace namespace, IDtProject project, IPath path, InputStream content, boolean fullOverride) {
        return new byte[0];
    }

    protected void handleResourceDeletion(IBmPlatformTransaction transaction, IBmNamespace namespace, IDtProject project, IPath path) {
    }
}

