/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ls.importer;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.provider.BmContentImportSupport;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.ls.importer.AbstractLstrContentImporter;
import com.e1c.langtool.v8.dt.ls.importer.internal.LsPlugin;
import com.e1c.langtool.v8.dt.resourcestorage.IV8FileNameConverter;
import com.e1c.langtool.v8.dt.resourcestorage.V8FileNameConverter;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public final class LsDataContentImporter
extends AbstractLstrContentImporter {
    @Inject
    private IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    private IV8FileNameConverter v8FileNameConverter = (IV8FileNameConverter)LsPlugin.getDefault().getInjector().getInstance(V8FileNameConverter.class);

    public static AbstractLstrContentImporter create() {
        return (AbstractLstrContentImporter)((Object)LsPlugin.getDefault().getInjector().getInstance(LsDataContentImporter.class));
    }

    @Inject
    public LsDataContentImporter(IBmModelManager bmModelManager, IQualifiedNameFilePathConverter qualifiedNameFilePathConverter) {
        super(bmModelManager, qualifiedNameFilePathConverter);
    }

    @Override
    public byte[] handleResourceCreationOrModification(IBmPlatformTransaction transaction, IBmNamespace namespace, IDtProject project, IPath path, InputStream content, boolean fullOverride) {
        BmContentImportSupport.NonCloseableHashingInputStream hashingIn = new BmContentImportSupport.NonCloseableHashingInputStream(Hashing.sha256(), content);
        IProject wsProject = project.getWorkspaceProject();
        if (wsProject == null) {
            return hashingIn.hash().asBytes();
        }
        IFile file = wsProject.getFile(path);
        Set v8files = this.v8FileNameConverter.getV8File(file);
        if (v8files == null || v8files.isEmpty()) {
            return hashingIn.hash().asBytes();
        }
        IFile objectFile = null;
        IBmObject internalObject = null;
        for (IFile v8file : v8files) {
            QualifiedName lsBaseFqn;
            if (!v8file.exists() || (lsBaseFqn = this.qualifiedNameFilePathConverter.getFqn(v8file)) == null || (internalObject = transaction.getTopObjectByFqn(namespace, lsBaseFqn.toString())) == null) continue;
            objectFile = v8file;
            break;
        }
        if (internalObject == null || objectFile == null) {
            return hashingIn.hash().asBytes();
        }
        TranslateLanguage language = this.v8FileNameConverter.getLanguage(file);
        if (language == null) {
            return hashingIn.hash().asBytes();
        }
        ITranslationStorageProvider.Storage storage = this.getCurrentStorage(wsProject);
        if (storage == null) {
            return hashingIn.hash().asBytes();
        }
        this.importInterfaces((EObject)internalObject, objectFile.getProjectRelativePath(), wsProject, storage, Arrays.asList(language));
        return hashingIn.hash().asBytes();
    }
}

