/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.right.templates;

import com._1c.g5.v8.dt.core.platform.IDerivedDataManagerProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.right.templates.model.BinaryExpression;
import com._1c.g5.v8.dt.right.templates.model.Conditional;
import com._1c.g5.v8.dt.right.templates.model.Expression;
import com._1c.g5.v8.dt.right.templates.model.Function;
import com._1c.g5.v8.dt.right.templates.model.IfStatement;
import com._1c.g5.v8.dt.right.templates.model.Literal;
import com._1c.g5.v8.dt.right.templates.model.OuterParameter;
import com._1c.g5.v8.dt.right.templates.model.RootTemplate;
import com._1c.g5.v8.dt.right.templates.model.RtPackage;
import com._1c.g5.v8.dt.right.templates.model.Statement;
import com._1c.g5.v8.dt.right.templates.model.StrContains;
import com._1c.g5.v8.dt.right.templates.model.StringLiteral;
import com._1c.g5.v8.dt.right.templates.model.Template;
import com._1c.g5.v8.dt.right.templates.model.TemplateParameter;
import com._1c.g5.v8.dt.right.templates.model.TextStatement;
import com._1c.g5.v8.dt.right.templates.model.UnaryExpression;
import com._1c.g5.v8.dt.right.templates.model.ValueLiteral;
import com.e1c.langtool.IBasicProcessor;
import com.e1c.langtool.v8.dt.DerivedDataUtils;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class RightTemplateProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    protected final EObject object;
    private boolean processChildObjects = true;
    protected IProgressMonitor monitor;
    @Inject
    private IDerivedDataManagerProvider derivedDataManagerProvider;
    @Inject
    protected IResourceLookup resourceLookup;
    private boolean waitDerivedDataComputation = true;

    public RightTemplateProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (this.isWaitDerivedDataComputation()) {
            DerivedDataUtils.DerivedDataAttr attr = new DerivedDataUtils.DerivedDataAttr(this.object, 0x6DDD00L, DerivedDataUtils.MD_SEGMENTS);
            DerivedDataUtils.waitComputation((IDerivedDataManagerProvider)this.derivedDataManagerProvider, (IResourceLookup)this.resourceLookup, (DerivedDataUtils.IDerivedDataAttr)attr);
        }
        if (this.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    protected boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(RtPackage.eINSTANCE);
    }

    protected boolean isWaitDerivedDataComputation() {
        return this.waitDerivedDataComputation;
    }

    protected void setWaitDerivedDataComputation(boolean waitDerivedDataComputation) {
        this.waitDerivedDataComputation = waitDerivedDataComputation;
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    protected void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    protected void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof RootTemplate) {
            this.doProcessInternal((RootTemplate)obj);
        } else if (obj instanceof Template) {
            this.doProcessInternal((Template)obj);
        } else if (obj instanceof TextStatement) {
            this.doProcessInternal((TextStatement)obj);
        } else if (obj instanceof IfStatement) {
            this.doProcessInternal((IfStatement)obj);
        } else if (obj instanceof Statement) {
            this.doProcessInternal((Statement)obj);
        } else if (obj instanceof Conditional) {
            this.doProcessInternal((Conditional)obj);
        } else if (obj instanceof OuterParameter) {
            this.doProcessInternal((OuterParameter)obj);
        } else if (obj instanceof TemplateParameter) {
            this.doProcessInternal((TemplateParameter)obj);
        } else if (obj instanceof StrContains) {
            this.doProcessInternal((StrContains)obj);
        } else if (obj instanceof Function) {
            this.doProcessInternal((Function)obj);
        } else if (obj instanceof BinaryExpression) {
            this.doProcessInternal((BinaryExpression)obj);
        } else if (obj instanceof UnaryExpression) {
            this.doProcessInternal((UnaryExpression)obj);
        } else if (obj instanceof StringLiteral) {
            this.doProcessInternal((StringLiteral)obj);
        } else if (obj instanceof ValueLiteral) {
            this.doProcessInternal((ValueLiteral)obj);
        } else if (obj instanceof Literal) {
            this.doProcessInternal((Literal)obj);
        } else if (obj instanceof Expression) {
            this.doProcessInternal((Expression)obj);
        }
    }

    private void doProcessInternal(RootTemplate obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, RootTemplate.class);
        this.doProcessInternal(obj.getTemplate());
    }

    private void doProcessInternal(Template obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Template.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getStatements());
    }

    private void doProcessInternal(TextStatement obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, TextStatement.class);
    }

    private void doProcessInternal(IfStatement obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, IfStatement.class);
        this.doProcessInternal(obj.getIfPart());
        this.doProcessInternal((Collection<? extends EObject>)obj.getElsIfParts());
        this.doProcessInternal(obj.getElseTemplate());
    }

    private void doProcessInternal(Statement obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Statement.class);
    }

    private void doProcessInternal(Conditional obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Conditional.class);
        this.doProcessInternal((EObject)obj.getPredicate());
        this.doProcessInternal(obj.getTemplate());
    }

    private void doProcessInternal(OuterParameter obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, OuterParameter.class);
    }

    private void doProcessInternal(TemplateParameter obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, TemplateParameter.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getParams());
    }

    private void doProcessInternal(StrContains obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, StrContains.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getParams());
    }

    private void doProcessInternal(Function obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Function.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getParams());
    }

    private void doProcessInternal(BinaryExpression obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, BinaryExpression.class);
        this.doProcessInternal((EObject)obj.getLeft());
        this.doProcessInternal((EObject)obj.getRight());
    }

    private void doProcessInternal(UnaryExpression obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, UnaryExpression.class);
        this.doProcessInternal((EObject)obj.getOperand());
    }

    private void doProcessInternal(StringLiteral obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, StringLiteral.class);
    }

    private void doProcessInternal(ValueLiteral obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ValueLiteral.class);
    }

    private void doProcessInternal(Literal obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Literal.class);
    }

    private void doProcessInternal(Expression obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Expression.class);
    }
}

