/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.right.templates.translator;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.right.templates.model.BooleanLiteral;
import com._1c.g5.v8.dt.right.templates.model.OuterParameter;
import com._1c.g5.v8.dt.right.templates.model.StrContains;
import com._1c.g5.v8.dt.right.templates.model.StringLiteral;
import com._1c.g5.v8.dt.right.templates.model.TemplateParameter;
import com._1c.g5.v8.dt.right.templates.model.TemplateParameterType;
import com._1c.g5.v8.dt.right.templates.model.TextStatement;
import com._1c.g5.v8.dt.right.templates.model.ValueLiteral;
import com._1c.g5.v8.dt.rights.model.RestrictionTemplate;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.internal.right.templates.CorePlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.right.templates.InternalizeTokenProvider;
import com.e1c.langtool.v8.dt.right.templates.RightTemplatesUtil;
import com.e1c.langtool.v8.dt.right.templates.settings.RightTemplateFeatureSettings;
import com.e1c.langtool.v8.dt.right.templates.translator.TemplateNameParameterTranslationProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.google.inject.Inject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;

public class RightTemplateTextProcessor
extends MultiTextEditParseTreeVisitor {
    private static final String SKIP_SYMBOLS_REGEX = "^[(\\)\\\"+-\\/\\\\=\\{\\}*\\%&\\.\\,\\<\\>0-9]+$";
    private static final Pattern SKIP_SYMBOLS_PATTERN = Pattern.compile("^[(\\)\\\"+-\\/\\\\=\\{\\}*\\%&\\.\\,\\<\\>0-9]+$");
    private static final String KEYWORD_ON_RU = "\u041f\u041e";
    private static final String KEYWORD_ON = "ON";
    private static final String AMPERSAND_SYMBOL = "&";
    private static final Set<String> KEYWORDS_BY_PREFFIX_RU = Set.of("\u0418\u041d\u0414\u0415\u041a\u0421\u0418\u0420\u041e\u0412\u0410\u0422\u042c", "\u0418\u0422\u041e\u0413\u0418", "\u0421\u0413\u0420\u0423\u041f\u041f\u0418\u0420\u041e\u0412\u0410\u0422\u042c", "\u0423\u041f\u041e\u0420\u042f\u0414\u041e\u0427\u0418\u0422\u042c");
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private InternalizeTokenProvider internalizeTokenProvider;
    @Inject
    private TemplateNameParameterTranslationProvider templateNameParameterTranslationProvider;
    @Inject
    protected ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IDependentModelProvider dependentModelProvider;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    private final EObject root;
    private final IProjectTranslationProvider translationProvider;
    private final ITranslatedV8Project project;
    private final CancelIndicator monitor;
    private IFile resourceFile;
    private final Set<Integer> processedNode = new HashSet<Integer>();
    private final MultiTextEdit edit;

    protected RightTemplateTextProcessor(MultiTextEdit edit, EObject root, IProjectTranslationProvider translationProvider, CancelIndicator monitor) {
        super(edit);
        this.root = root;
        this.translationProvider = translationProvider;
        this.monitor = monitor;
        this.edit = edit;
        this.project = translationProvider.getProject();
    }

    public boolean visit(ICompositeNode node) {
        return !this.monitor.isCanceled();
    }

    public boolean visit(ILeafNode node) {
        if (node.isHidden()) {
            this.processComments(node);
            return !this.monitor.isCanceled();
        }
        String text = node.getText();
        if (this.isSkipSymbols(text)) {
            return true;
        }
        EObject grammarElement = node.getGrammarElement();
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        String replace = null;
        if (grammarElement instanceof EnumLiteralDeclaration) {
            replace = this.getReplaceText((EnumLiteralDeclaration)grammarElement);
            this.addReplaceIfNotEmpty(node, replace);
            return true;
        }
        if (grammarElement instanceof Keyword) {
            replace = this.getReplaceText((Keyword)grammarElement, node);
            this.addReplaceIfNotEmpty(node, replace);
        } else {
            replace = this.getReplaceText(semanticElement);
            this.addReplaceIfNotEmpty(node, replace);
        }
        return true;
    }

    private boolean isSkipSymbols(String text) {
        return SKIP_SYMBOLS_PATTERN.matcher(text).matches();
    }

    private String getReplaceText(EObject object) {
        if (object == null) {
            return null;
        }
        String replace = null;
        if (object instanceof TextStatement) {
            replace = this.getReplaceText((TextStatement)object);
        } else if (object instanceof TemplateParameter) {
            replace = this.getReplaceText((TemplateParameter)object);
        } else if (object instanceof StrContains) {
            replace = this.getReplaceText((StrContains)object);
        } else if (object instanceof OuterParameter) {
            replace = this.getReplaceText((OuterParameter)object);
        } else if (object instanceof BooleanLiteral) {
            replace = this.getReplaceText((BooleanLiteral)object);
        } else if (object instanceof StringLiteral) {
            replace = this.getReplaceText((StringLiteral)object);
        } else if (object instanceof ValueLiteral) {
            replace = this.getReplaceText((ValueLiteral)object);
        } else {
            Pair translation = this.namedEObjectNameProvider.getTranslatedName(object, this.translationProvider);
            if (translation != null) {
                replace = (String)translation.getValue();
            } else if (CorePlugin.getDefault().isDebugging()) {
                CorePlugin.log(CorePlugin.createWarningStatus("RightTemplateTextProcessor: unknown replace text type: " + object.getClass().toString()));
            }
        }
        return replace;
    }

    private String getReplaceText(Keyword keyword, ILeafNode node) {
        Keyword prev;
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        boolean isRussian = this.project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        if (!isRussian && KEYWORD_ON_RU.equalsIgnoreCase(keyword.getValue()) && (prev = this.getPreviousKeyword(node)) != null && !KEYWORDS_BY_PREFFIX_RU.contains(prev.getValue())) {
            return KEYWORD_ON;
        }
        return this.internalizeTokenProvider.getInternalizeKeyword(keyword, isRussian);
    }

    private Keyword getPreviousKeyword(ILeafNode node) {
        ILeafNode current = node;
        while (current != null && current.hasPreviousSibling()) {
            INode prev = current.getPreviousSibling();
            if (prev instanceof ILeafNode && prev.getGrammarElement() instanceof Keyword) {
                return (Keyword)prev.getGrammarElement();
            }
            if (prev instanceof ICompositeNode) {
                Keyword keyword = null;
                for (ILeafNode leaf : ((ICompositeNode)prev).getLeafNodes()) {
                    if (!(leaf.getGrammarElement() instanceof Keyword)) continue;
                    keyword = (Keyword)leaf.getGrammarElement();
                }
                if (keyword != null) {
                    return keyword;
                }
            }
            current = prev;
            while (current != null && !current.hasPreviousSibling()) {
                current = current.getParent();
            }
        }
        return null;
    }

    protected String getTranslation(EObject source, EFeatureSettings featureSettings) {
        String value = (String)source.eGet(featureSettings.getEFeature());
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey(source, (FeatureSettings)featureSettings);
        ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, (FeatureSettings)featureSettings, value);
        String translation = this.translationProvider.getTranslation(source, (ContextTranslationKey)key, this.project.getDefaultLanguage());
        if (StringUtils.isNotEmpty((String)translation)) {
            return translation;
        }
        return null;
    }

    private String getReplaceText(TextStatement object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, RightTemplateFeatureSettings.Literals.TEXT_STATEMENT__CONTENT);
        boolean isParameter = ((String)object.eGet(RightTemplateFeatureSettings.Literals.TEXT_STATEMENT__CONTENT.getEFeature())).startsWith(AMPERSAND_SYMBOL);
        if (replace != null && isParameter) {
            replace = replace.replaceFirst(AMPERSAND_SYMBOL, "");
        }
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return null;
    }

    private String getReplaceText(TemplateParameter object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        if (object.getType().equals((Object)TemplateParameterType.PARAMETER)) {
            Map<String, String> map = this.templateNameParameterTranslationProvider.getParameters(this.getTemplate(), this.translationProvider);
        } else if (object.getType().equals((Object)TemplateParameterType.WRONG_TYPE)) {
            return null;
        }
        return null;
    }

    private String getReplaceText(StrContains object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        return null;
    }

    private String getReplaceText(OuterParameter object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, RightTemplateFeatureSettings.Literals.OUTER_PARAMETER__NAME);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return null;
    }

    private String getReplaceText(BooleanLiteral object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        CorePlugin.log(CorePlugin.createWarningStatus("RightTemplateTextProcessor: BooleanLiteral replace unsupported"));
        return null;
    }

    private String getReplaceText(StringLiteral object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        String literalContent = RightTemplatesUtil.getString(object).trim();
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)RightTemplateFeatureSettings.Literals.STRING_LITERAL__CONTENT);
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.getResourceFile(), featureKey, (FeatureSettings)RightTemplateFeatureSettings.Literals.STRING_LITERAL__CONTENT, literalContent, false);
        String replace = this.translationProvider.getTranslation((EObject)object, (ContextTranslationKey)featureValue, this.project.getDefaultLanguage());
        if (StringUtils.isNotEmpty((String)replace)) {
            return RightTemplatesUtil.formatStringLiteral(replace);
        }
        return null;
    }

    private String getReplaceText(ValueLiteral object) {
        if (!this.project.isChangeDefaultLanguage() && !this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = this.getTranslation((EObject)object, RightTemplateFeatureSettings.Literals.VALUE_LITERAL__VALUE);
        if (StringUtils.isNotEmpty((String)replace)) {
            return replace;
        }
        return null;
    }

    private String getReplaceText(EnumLiteralDeclaration object) {
        if (!this.project.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        EObject container = object.eContainer();
        if (container != null && container instanceof Alternatives && !container.eContents().isEmpty()) {
            EObject replaceObject;
            EList eContents = container.eContents();
            int index = -1;
            if (eContents.size() > 2) {
                index = eContents.indexOf((Object)object);
            }
            if (index <= 1) {
                index = 0;
            } else if (index % 2 > 0) {
                --index;
            }
            if (this.project.getScriptVariant() == ScriptVariant.RUSSIAN && eContents.size() > 1) {
                ++index;
            }
            if ((replaceObject = (EObject)eContents.get(index)) instanceof EnumLiteralDeclaration) {
                replace = ((EnumLiteralDeclaration)replaceObject).getLiteral().getValue();
            }
        }
        return replace;
    }

    private RestrictionTemplate getTemplate() {
        EObject parent = this.dependentModelProvider.getParent(this.root);
        if (parent != null && parent instanceof RestrictionTemplate) {
            return (RestrictionTemplate)parent;
        }
        return null;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            EObject parent;
            EObject current = this.root;
            while ((parent = this.dependentModelProvider.getParent(current = (EObject)current.eResource().getContents().get(0))) != null && (current = parent) != null) {
            }
            this.resourceFile = this.resourceLookup.getPlatformResource(current);
        }
        return this.resourceFile;
    }

    /*
     * Unable to fully structure code
     */
    private void processComments(ILeafNode node) {
        if (!node.isHidden() || !QlUtil.isCommentNode((ILeafNode)node) || this.processedNode.contains(node.getStartLine())) {
            return;
        }
        lines = QlUtil.getCommentBlock((ILeafNode)node);
        text = QlUtil.getCommentText((List)lines);
        if (StringUtils.isBlank((String)text)) {
            return;
        }
        featureKey = QlUtil.getCommentFeatureKey((ITranslationFeatureKeyProvider)this.translationKeyProvider, (EObject)this.root, (String)text);
        contextKey = new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, RightTemplateFeatureSettings.Literals.COMMENT__DESCRIPTION, text);
        parts = text.replace("\r", "").split("\n", -1);
        translation = this.translationProvider.getStoredTranslation((ContextTranslationKey)contextKey, this.project.getDefaultLanguage(), new ITranslationStorageProvider.Storage.Type[0]);
        if (translation == null || translation.isEmpty()) {
            return;
        }
        translations = translation.replace("\r", "").split("\n", -1);
        newParts = new ArrayList<String>();
        if (translations.length == parts.length) {
            newParts.addAll(List.of(translations));
        } else if (translations.length < parts.length) {
            newParts.addAll(List.of(translations));
            while (parts.length > newParts.size()) {
                newParts.add("");
            }
        } else if (translations.length > parts.length) {
            newParts.addAll(List.of(Arrays.copyOf(translations, parts.length)));
            lastIndex = newParts.size() - 1;
            sb = new StringBuilder();
            i = lastIndex;
            while (i < translations.length) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(translations[i]);
                ++i;
            }
            newParts.set(lastIndex, sb.toString());
        }
        i = 0;
        j = 0;
        ** GOTO lbl54
        {
            ++j;
            do {
                if (j < lines.size() && QlUtil.getCommentText(List.of((ILeafNode)lines.get(j))).isEmpty()) continue block2;
                if (j < lines.size() && !parts[i].isEmpty()) {
                    line = (ILeafNode)lines.get(j++);
                    txt = line.getText().stripTrailing();
                    this.addReplace(line.getOffset() + txt.length() - parts[i].length(), parts[i], (String)newParts.get(i));
                }
                ++i;
lbl54:
                // 2 sources

            } while (i < parts.length && i < newParts.size() && j < lines.size());
        }
        lines.forEach((Consumer<ILeafNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.xtext.nodemodel.ILeafNode ), (Lorg/eclipse/xtext/nodemodel/ILeafNode;)V)((RightTemplateTextProcessor)this));
    }

    private void addReplace(int offset, String source, String replace) {
        if (!source.equals(replace)) {
            this.edit.addChild((TextEdit)new ReplaceEdit(offset, source.length(), replace));
        }
    }

    private /* synthetic */ void lambda$0(ILeafNode n) {
        boolean bl = this.processedNode.add(n.getStartLine());
    }
}

