/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.right.templates.translator;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.rights.model.RestrictionTemplate;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.right.templates.TemplateNameParameterProvider;
import com.e1c.langtool.v8.dt.right.templates.settings.RightTemplateFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class TemplateNameParameterTranslationProvider {
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private TemplateNameParameterProvider templateNameParameterProvider;

    public Map<String, String> getParameters(RestrictionTemplate template, IProjectTranslationProvider translationProvider) {
        List<String> parameters = this.templateNameParameterProvider.getParameters(template.getName());
        if (!parameters.isEmpty()) {
            FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)template, RightTemplateFeatureSettings.Literals.RESTRICTION_TEMPLATE__PARAMETER_NAME);
            TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
            IFile file = this.resourceLookup.getPlatformResource((EObject)template);
            return parameters.stream().collect(Collectors.toMap(p -> p, p -> {
                ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(file, featureKey, RightTemplateFeatureSettings.Literals.RESTRICTION_TEMPLATE__PARAMETER_NAME, p);
                String translation = translationProvider.getTranslation((EObject)template, (ContextTranslationKey)contextKey, language);
                if (StringUtils.isNotEmpty((String)translation)) {
                    return translation;
                }
                return p;
            }));
        }
        return Map.of();
    }
}

