/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.moxel.i18n;

import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.moxel.LanguageInfo;
import com._1c.g5.v8.dt.moxel.MoxelFactory;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.v8.dt.moxel.content.LocalString;
import com._1c.g5.wiring.ServiceAccess;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.moxel.MoxelProcessor;
import com.e1c.langtool.v8.dt.moxel.settings.MoxelFeatureSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class MoxelLoadingPostprocessor
extends MoxelProcessor {
    private static final IPath CONFIGURATION_PATH = new Path("src/Congiguration/Configuration.mdo");
    private final IFile resourceFile;
    private final String defaultLanguageCode;
    private final Collection<TranslateLanguage> languages;
    private final ITranslationStorageProvider.ContextStorage storage;
    private final TranslationProperties properties;
    private ITranslationFeatureKeyProvider featureKeyProvider = (ITranslationFeatureKeyProvider)ServiceAccess.get(ITranslationFeatureKeyProvider.class);

    public MoxelLoadingPostprocessor(SpreadsheetDocument document, IFile resourceFile, String defaultLanguageCode, Collection<TranslateLanguage> languages, ITranslationStorageProvider.ContextStorage storage, TranslationProperties properties) {
        super((EObject)document);
        this.resourceFile = resourceFile;
        this.defaultLanguageCode = defaultLanguageCode;
        this.languages = languages;
        this.storage = storage;
        this.properties = properties;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz) {
        if (clazz == LocalString.class) {
            this.doProcessInternal((LocalString)object);
        } else if (clazz == SpreadsheetDocument.class) {
            this.doProcessInternal((SpreadsheetDocument)object);
        }
    }

    private void doProcessInternal(SpreadsheetDocument object) {
        if (object.getLanguageSettings() == null) {
            object.setLanguageSettings(MoxelFactory.eINSTANCE.createLanguageSettings());
        }
        Map languageCodes = this.languages.stream().collect(Collectors.toMap(TranslateLanguage::getLanguageCode, Function.identity()));
        for (LanguageInfo languageInfo : object.getLanguageSettings().getLanguages()) {
            languageCodes.remove(languageInfo.getLanguageId());
        }
        for (TranslateLanguage language : languageCodes.values()) {
            LanguageInfo languageInfo = MoxelFactory.eINSTANCE.createLanguageInfo();
            languageInfo.setLanguageCode(language.getName());
            languageInfo.setLanguageId(language.getLanguageCode());
            String description = language.getPresentation();
            if (StringUtils.isNullOrEmpty((String)description) && language instanceof Language) {
                FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)((Language)language), (FeatureSettings)MdFeatureSettings.Literals.MD_OBJECT__SYNONYM);
                ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.resourceFile.getProject().getFile(CONFIGURATION_PATH), featureKey, (FeatureSettings)MdFeatureSettings.Literals.MD_OBJECT__SYNONYM, (String)((Language)language).getSynonym().get((Object)this.defaultLanguageCode));
                description = this.storage.getTranslation((ContextTranslationKey)contextKey, language);
            }
            languageInfo.setDescription(description);
            object.getLanguageSettings().getLanguages().add((Object)languageInfo);
        }
    }

    private void doProcessInternal(LocalString object) {
        if (object != null) {
            FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)MoxelFeatureSettings.Literals.LOCAL_STRING__CONTENT);
            EMap localStrings = object.getContent();
            ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.resourceFile, featureKey, (FeatureSettings)MoxelFeatureSettings.Literals.LOCAL_STRING__CONTENT, (String)localStrings.get((Object)this.defaultLanguageCode));
            Set existingCodes = localStrings.keySet();
            for (TranslateLanguage language : this.languages) {
                String languageCode = language.getLanguageCode();
                String translation = this.storage.getTranslation((ContextTranslationKey)contextKey, language);
                if (StringUtils.isNullOrEmpty((String)translation)) {
                    if (existingCodes.contains(languageCode)) continue;
                    localStrings.removeKey((Object)languageCode);
                    continue;
                }
                localStrings.put((Object)languageCode, (Object)translation);
            }
            if (this.properties.fillEmptyInterfaceTranslation()) {
                for (TranslateLanguage language : this.languages) {
                    if (localStrings.containsKey((Object)language.getLanguageCode()) && !StringUtils.isNullOrEmpty((String)((String)localStrings.get((Object)language.getLanguageCode())))) continue;
                    this.fillupEmptyInterface((EMap<String, String>)localStrings, language);
                }
            }
        }
    }

    private void fillupEmptyInterface(EMap<String, String> values, TranslateLanguage language) {
        TranslateLanguage newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(language);
        if (newLang == null) {
            return;
        }
        HashSet<String> checked = new HashSet<String>();
        checked.add(language.getLanguageCode());
        while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
            String value = (String)values.get((Object)newLang.getLanguageCode());
            if (StringUtils.isNullOrEmpty((String)value)) {
                checked.add(newLang.getLanguageCode());
                newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                continue;
            }
            values.put((Object)language.getLanguageCode(), (Object)value);
            return;
        }
    }
}

