/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.moxel.i18n.extension;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.provider.IResourceContentExporterExtension;
import com._1c.g5.v8.dt.core.provider.IResourceContentExporterExtensionManager;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.moxel.LanguageInfo;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.v8.dt.moxel.content.LocalString;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.moxel.settings.MoxelFeatureSettings;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

@Singleton
@LifecycleService(name="MoxelV8ExporterExtension")
public class MoxelV8ExporterExtension
implements IResourceContentExporterExtension {
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final ITranslatingProjectManager translatingProjectManager;
    private final ITranslationStorageManager storageManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final IResourceContentExporterExtensionManager resourceContentExporterExtensionManager;
    private boolean initialized = false;

    @Inject
    public MoxelV8ExporterExtension(ITranslationFeatureKeyProvider featureKeyProvider, ITranslatingProjectManager translatingProjectManager, ITranslationStorageManager storageManager, IStorageSettingsManager storageSettingsManager, IResourceContentExporterExtensionManager resourceContentExporterExtensionManager) {
        this.featureKeyProvider = featureKeyProvider;
        this.translatingProjectManager = translatingProjectManager;
        this.storageManager = storageManager;
        this.storageSettingsManager = storageSettingsManager;
        this.resourceContentExporterExtensionManager = resourceContentExporterExtensionManager;
    }

    public void beforeExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) {
        if (!(clone instanceof SpreadsheetDocument)) {
            return;
        }
        IProject project = file.getProject();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return;
        }
        String defaultLanguageCode = translatingProject.getDefaultLanguage().getLanguageCode();
        List languages = translatingProject.getInterfaceLanguages();
        StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
        ITranslationStorageProvider.Storage editingStorage = this.storageManager.getStorage(project, storageId);
        if (!(editingStorage instanceof ITranslationStorageProvider.ContextStorage)) {
            return;
        }
        ITranslationStorageProvider.ContextStorage currentStorage = (ITranslationStorageProvider.ContextStorage)editingStorage;
        this.updateLanguages((SpreadsheetDocument)clone, languages);
        HashSet<ContextTranslationKey> affectedKeys = new HashSet<ContextTranslationKey>();
        TreeIterator iterator = clone.eAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (!(object instanceof LocalString)) continue;
            affectedKeys.add(this.updateLocalString((LocalString)object, defaultLanguageCode, file, languages, currentStorage));
        }
        for (TranslateLanguage language : languages) {
            Map hashes = currentStorage.saveFiles(affectedKeys, language, Hashing.sha256());
            if (hashes.isEmpty()) continue;
            hashes.forEach((iFile, hash) -> exportedExtraFiles.put((IFile)iFile, (byte[])hash));
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.resourceContentExporterExtensionManager.registerExtension((IResourceContentExporterExtension)this);
    }

    private void updateLanguages(SpreadsheetDocument object, Collection<TranslateLanguage> languages) {
        Set languageCodes = languages.stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toSet());
        Iterator iterator = object.getLanguageSettings().getLanguages().iterator();
        while (iterator.hasNext()) {
            LanguageInfo language = (LanguageInfo)iterator.next();
            if (!languageCodes.contains(language.getLanguageId())) continue;
            iterator.remove();
        }
    }

    private ContextTranslationKey updateLocalString(LocalString localString, String defaultLanguageCode, IFile currentFile, Collection<TranslateLanguage> languages, ITranslationStorageProvider.ContextStorage currentStorage) {
        EMap localStringsMap = localString.getContent();
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)localString, (FeatureSettings)MoxelFeatureSettings.Literals.LOCAL_STRING__CONTENT);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(currentFile, featureKey, (FeatureSettings)MoxelFeatureSettings.Literals.LOCAL_STRING__CONTENT, (String)localStringsMap.get((Object)defaultLanguageCode));
        for (TranslateLanguage language : languages) {
            if (localStringsMap.containsKey((Object)language.getLanguageCode())) {
                currentStorage.setTranslation((ContextTranslationKey)contextKey, language, (String)localStringsMap.get((Object)language.getLanguageCode()), false);
            } else {
                currentStorage.removeTranslation((ContextTranslationKey)contextKey, language, false);
            }
            localString.getContent().removeKey((Object)language.getLanguageCode());
        }
        return contextKey;
    }
}

