/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.moxel.i18n.extension;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.provider.IResourceContentImporterExtension;
import com._1c.g5.v8.dt.core.provider.IResourceContentImporterExtensionManager;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.wiring.ServiceAccess;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.internal.moxel.MoxelPlugin;
import com.e1c.langtool.v8.dt.internal.moxel.i18n.AddedInterfaceAdapter;
import com.e1c.langtool.v8.dt.internal.moxel.i18n.MoxelLoadingPostprocessor;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

@Singleton
@LifecycleService(name="MoxelV8ImporterExtension")
public class MoxelV8ImporterExtension
implements IResourceContentImporterExtension {
    private final IResourceLookup resourceLookup;
    private final ITranslationStorageManager storageManager;
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final IResourceContentImporterExtensionManager resourceContentExporterExtensionManager;
    private final IBmModelManager bmModelManager;
    private boolean initialized = false;

    @Inject
    public MoxelV8ImporterExtension(IResourceLookup resourceLookup, ITranslationStorageManager storageManager, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, IResourceContentImporterExtensionManager resourceContentExporterExtensionManager, IBmModelManager bmModelManager) {
        this.resourceLookup = resourceLookup;
        this.storageManager = storageManager;
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
        this.resourceContentExporterExtensionManager = resourceContentExporterExtensionManager;
        this.bmModelManager = bmModelManager;
    }

    public void afterImport(IBmObject importedObject, IBmEngine engine, Resource resource, IPath path) {
        if (!(importedObject instanceof SpreadsheetDocument)) {
            return;
        }
        IProject project = this.resourceLookup.getProject((EObject)importedObject);
        if (project == null) {
            return;
        }
        IBmTransaction transaction = engine.getCurrentTransaction();
        if (transaction == null) {
            this.bmModelManager.executeReadWriteTask(project, tr -> {
                this.doAfterImport((IBmObject)tr.toTransactionObject((EObject)importedObject), path, project);
                return null;
            });
        } else {
            this.doAfterImport((IBmObject)transaction.toTransactionObject((EObject)importedObject), path, project);
        }
    }

    private void doAfterImport(IBmObject importedObject, IPath path, IProject project) {
        ITranslatingProject translatingProject;
        IFile file = project.getFile(path);
        if (MoxelPlugin.getDefault().isDebugging()) {
            MoxelPlugin.log(MoxelPlugin.createInfoStatus("Read SpreadsheetDocument to add interfaces to file: " + String.valueOf(file)));
        }
        if (!(translatingProject = this.translatingProjectManager.getProject(project)).isTranslating()) {
            return;
        }
        StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
        ITranslationStorageProvider.Storage editingStorage = this.storageManager.getStorage(project, storageId);
        if (!(editingStorage instanceof ITranslationStorageProvider.ContextStorage)) {
            return;
        }
        ITranslationStorageProvider.ContextStorage storage = (ITranslationStorageProvider.ContextStorage)editingStorage;
        String defaultLanguageCode = translatingProject.getDefaultLanguage().getLanguageCode();
        List languages = translatingProject.getInterfaceLanguages();
        if (MoxelPlugin.getDefault().isDebugging()) {
            MoxelPlugin.log(MoxelPlugin.createInfoStatus("Start add interfaces to file: " + String.valueOf(file)));
        }
        TranslationProperties properties = this.getTranslationProperties(project);
        MoxelLoadingPostprocessor postprocessor = new MoxelLoadingPostprocessor((SpreadsheetDocument)importedObject, file, defaultLanguageCode, languages, storage, properties);
        postprocessor.process((IProgressMonitor)new NullProgressMonitor());
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)importedObject, AddedInterfaceAdapter.class);
        if (adapter == null) {
            importedObject.eAdapters().add((Object)new AddedInterfaceAdapter());
        }
        if (MoxelPlugin.getDefault().isDebugging()) {
            MoxelPlugin.log(MoxelPlugin.createInfoStatus("Finished add interfaces to file: " + String.valueOf(file)));
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.resourceContentExporterExtensionManager.registerExtension((IResourceContentImporterExtension)this);
    }

    private TranslationProperties getTranslationProperties(IProject project) {
        TranslationPreferences prefs = (TranslationPreferences)ServiceAccess.get(TranslationPreferences.class);
        return prefs.getTranslationProperties(project);
    }
}

