/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.moxel.i18n.xml.extension;

import com._1c.g5.v8.dt.common.PreferenceUtils;
import com._1c.g5.v8.dt.common.StringUtils;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.export.ExportException;
import com._1c.g5.v8.dt.export.IExportArtifactBuilder;
import com._1c.g5.v8.dt.export.xml.IExportContext;
import com._1c.g5.v8.dt.export.xml.IExporter;
import com._1c.g5.v8.dt.export.xml.writer.ExportXmlStreamWriter;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.md.export.xml.IXmlExporterExtension;
import com._1c.g5.v8.dt.md.export.xml.IXmlExporterExtensionManager;
import com._1c.g5.v8.dt.metadata.mdclass.BasicTemplate;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.TemplateType;
import com._1c.g5.v8.dt.moxel.LanguageInfo;
import com._1c.g5.v8.dt.moxel.LanguageSettings;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.v8.dt.moxel.util.V8MoxelSerializer;
import com._1c.g5.v8.dt.xml.LineFeedConverter;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import com.e1c.langtool.v8.dt.internal.moxel.MoxelPlugin;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Singleton
@LifecycleService(name="MoxelXmlExporterExtension")
public class MoxelXmlExporterExtension
implements IXmlExporterExtension {
    private final IDocumentProcessingSettingsManager documentProcessingSettingsManager;
    private final ITranslatingProjectManager translatingProjectManager;
    private final IXmlExporterExtensionManager xmlExporterExtensionManager;
    private final IDtProjectManager dtProjectManager;
    private boolean initialized = false;

    @Inject
    public MoxelXmlExporterExtension(IDocumentProcessingSettingsManager documentProcessingSettingsManager, ITranslatingProjectManager translatingProjectManager, IXmlExporterExtensionManager xmlExporterExtensionManager, IDtProjectManager dtProjectManager) {
        this.documentProcessingSettingsManager = (IDocumentProcessingSettingsManager)Preconditions.checkNotNull((Object)documentProcessingSettingsManager);
        this.translatingProjectManager = (ITranslatingProjectManager)Preconditions.checkNotNull((Object)translatingProjectManager);
        this.xmlExporterExtensionManager = (IXmlExporterExtensionManager)Preconditions.checkNotNull((Object)xmlExporterExtensionManager);
        this.dtProjectManager = (IDtProjectManager)Preconditions.checkNotNull((Object)dtProjectManager);
    }

    public void copyTemplateWithLineFeedConversion(IExporter exporter, EObject eObject, IExportContext exportContext, IExportArtifactBuilder artifactBuilder, Path source, Path target, LineFeedConverter.ConvertOption ... options) throws ExportException {
        block31: {
            BasicTemplate template = (BasicTemplate)eObject;
            IProject project = exportContext.getExportProject();
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
            if (!translatingProject.isTranslating()) {
                return;
            }
            if (MoxelPlugin.getDefault() == null) {
                MoxelPlugin.log(MoxelPlugin.createErrorStatus("Moxel-I18n-Plugin didn't start yet", null));
            }
            Path outputPath = exporter.getOutputPath((EObject)template, (EStructuralFeature)MdClassPackage.Literals.BASIC_TEMPLATE__TEMPLATE, exportContext.getProjectVersion());
            if (MoxelPlugin.getDefault().isDebugging()) {
                MoxelPlugin.log(MoxelPlugin.createInfoStatus("Start export Moxel file: " + String.valueOf(outputPath)));
            }
            this.documentProcessingSettingsManager.lockDocumentSaveProcessing();
            try {
                try {
                    EObject spreadsheetTemplate = template.getTemplate();
                    if (!(spreadsheetTemplate instanceof SpreadsheetDocument)) break block31;
                    SpreadsheetDocument spreadsheet = (SpreadsheetDocument)spreadsheetTemplate;
                    if (outputPath == null) {
                        MoxelPlugin.log(MoxelPlugin.createErrorStatus("Unable to determine Moxel output file. Template: " + String.valueOf(template), null));
                        break block31;
                    }
                    if (MoxelPlugin.getDefault().isDebugging()) {
                        MoxelPlugin.log(MoxelPlugin.createInfoStatus("Sart serialize Moxel file: " + String.valueOf(outputPath)));
                    }
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.serializeXML(spreadsheet, translatingProject, outputStream);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    try {
                        Throwable throwable = null;
                        Object var17_21 = null;
                        try (BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);){
                            Throwable throwable2 = null;
                            Object var20_26 = null;
                            try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(artifactBuilder.newOutputStream(target));){
                                LineFeedConverter.convert((InputStream)bufferedInput, (OutputStream)bufferedOutput, (LineFeedConverter.ConvertOption[])options);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            if (MoxelPlugin.getDefault().isDebugging()) {
                                MoxelPlugin.log(MoxelPlugin.createInfoStatus("Finish successfully write Moxel file: " + String.valueOf(target)));
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        MoxelPlugin.logError(e);
                    }
                }
                catch (Throwable e) {
                    String message = MessageFormat.format("Cannot add interfaces at xml export to Moxel: {0}", outputPath);
                    MoxelPlugin.log(MoxelPlugin.createErrorStatus(message, e));
                    this.documentProcessingSettingsManager.unlockDocumentSaveProcessing();
                }
            }
            finally {
                this.documentProcessingSettingsManager.unlockDocumentSaveProcessing();
            }
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.xmlExporterExtensionManager.registerExtension((IXmlExporterExtension)this);
    }

    public boolean overridesTemplateCopying(EObject eObject, IExportContext exportContext) {
        BasicTemplate template;
        if (eObject instanceof BasicTemplate && (template = (BasicTemplate)eObject).getTemplateType() == TemplateType.SPREADSHEET_DOCUMENT) {
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(exportContext.getExportProject());
            return translatingProject.isTranslating();
        }
        return false;
    }

    private void serializeXML(SpreadsheetDocument spreadsheet, ITranslatingProject translatingProject, OutputStream outputStream) throws XMLStreamException, ExportException {
        IProject project = translatingProject.getProject();
        String lineSeparator = PreferenceUtils.getLineSeparator((IProject)project);
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        new V8MoxelSerializer(dtProject, spreadsheet).serializeXML(outputStream, lineSeparator);
    }

    private class TranslatingProjectV8MoxelSerializer
    extends V8MoxelSerializer {
        private final SpreadsheetDocument sheet;
        private final ITranslatingProject translatingProject;

        public TranslatingProjectV8MoxelSerializer(SpreadsheetDocument sheet, ITranslatingProject translatingProject) {
            super(MoxelXmlExporterExtension.this.dtProjectManager.getDtProject(translatingProject.getProject()), sheet);
            this.sheet = (SpreadsheetDocument)Preconditions.checkNotNull((Object)sheet);
            this.translatingProject = (ITranslatingProject)Preconditions.checkNotNull((Object)translatingProject);
        }

        public void writeLanguageSettings(ExportXmlStreamWriter streamWriter) throws XMLStreamException {
            LanguageSettings languageSettings = this.sheet.getLanguageSettings();
            if (languageSettings != null) {
                streamWriter.writeStartElement("languageSettings");
                if (StringUtils.isEmpty((String)languageSettings.getCurrentLanguage())) {
                    streamWriter.writeEmptyElement("currentLanguage");
                } else {
                    this.writeStringElement(streamWriter, "currentLanguage", languageSettings.getCurrentLanguage());
                }
                if (StringUtils.isEmpty((String)languageSettings.getDefaultLanguage())) {
                    streamWriter.writeEmptyElement("defaultLanguage");
                } else {
                    this.writeStringElement(streamWriter, "defaultLanguage", languageSettings.getDefaultLanguage());
                }
                this.writeLanguageInfos(languageSettings, streamWriter);
                streamWriter.writeEndElement();
            }
        }

        private void writeLanguageInfos(LanguageSettings languageSettings, ExportXmlStreamWriter streamWriter) throws XMLStreamException {
            Set<String> interfaceLanguageCodes = this.getInterfaceLanguageCodes();
            for (LanguageInfo item : languageSettings.getLanguages()) {
                if (interfaceLanguageCodes.contains(item.getLanguageId())) continue;
                streamWriter.writeStartElement("languageInfo");
                this.writeStringElement(streamWriter, "id", item.getLanguageId());
                this.writeStringElement(streamWriter, "code", item.getLanguageCode());
                if (StringUtils.isEmpty((String)item.getDescription())) {
                    streamWriter.writeEmptyElement("description");
                } else {
                    this.writeStringElement(streamWriter, "description", item.getDescription());
                }
                streamWriter.writeEndElement();
            }
        }

        private void writeStringElement(ExportXmlStreamWriter streamWriter, String elementName, String value) throws XMLStreamException {
            streamWriter.writeStartElement(elementName);
            streamWriter.writeCharacters(Strings.nullToEmpty((String)value));
            streamWriter.writeInlineEndElement();
        }

        private Set<String> getInterfaceLanguageCodes() {
            return this.translatingProject.getInterfaceLanguages().stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toSet());
        }
    }
}

