/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.moxel;

import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.moxel.MoxelPlugin;
import com.e1c.langtool.v8.dt.moxel.MoxelProcessor;
import com.e1c.langtool.v8.dt.moxel.MoxelUtils;
import com.e1c.langtool.v8.dt.moxel.settings.MoxelFeatureSettings;
import com.google.inject.Inject;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class MoxelFeaturesCollector
extends MoxelProcessor
implements FeatureValueCollector {
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IFeatureValueCollectingService collectingService;
    private ICollectingParameters parameters;
    private CollectingContext context;
    private BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;

    public static MoxelFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        MoxelFeaturesCollector collector = new MoxelFeaturesCollector(object, parameters, addAction);
        MoxelPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public MoxelFeaturesCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super(object);
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        super.setProcessChildObjects(parameters.isCollectChildObjects());
        this.addAction = addAction;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz) {
        if (object == null) {
            return;
        }
        FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)this.monitor);
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, null, this.getDefaultLanguageCode(this.object), (obj, fv) -> {
                this.addAction.accept(obj, (FeatureValue)fv);
                this.collectParameters(obj, (FeatureValue)fv);
            });
        }
        return this.context;
    }

    private void collectParameters(Object obj, FeatureValue fv) {
        if (!this.parameters.isCollectModelStrings() || !fv.getContextKey().getFeatureSettings().isInterface() || StringUtils.isNullOrEmpty((String)fv.getContextKey().getValue()) || !(obj instanceof EObject)) {
            return;
        }
        Map<String, String> params = MoxelUtils.getParamsMapFromNls(fv.getContextKey().getValue());
        if (params.isEmpty()) {
            return;
        }
        IFile file = TranslationUtils.getTranslationSourceFile((ContextTranslationKey)fv.getContextKey());
        String langCode = this.getDefaultLanguageCode((EObject)obj);
        FeatureKey featureKey = fv.getContextKey().getFeatureKey().skipLast(1);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String param = entry.getKey();
            if (StringUtils.isNullOrEmpty((String)param)) continue;
            String[] paramParts = param.split("\\.");
            int i = 0;
            while (i < paramParts.length) {
                String paramPart = paramParts[i];
                FeatureKey paramKey = featureKey.append((FeatureKey)SegmentFeatureKey.create((String[])new String[]{paramPart, MoxelFeatureSettings.Literals.LOCAL_STRING__PARAM.getName()}));
                PersistableFeatureValue paramValue = new PersistableFeatureValue(file, paramKey, MoxelFeatureSettings.Literals.LOCAL_STRING__PARAM, paramPart, fv.isComputedValue());
                if (StringUtils.isNotEmpty((String)paramPart) && obj instanceof EObject) {
                    paramValue.getLocalStrings().put(langCode, paramPart);
                }
                if (TranslationUtils.isValidValueForCollectModelType((boolean)paramValue.isComputedValue(), (boolean)paramValue.isTag(), (boolean)paramValue.isUnknown(), (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
                    this.addAction.accept(obj, (FeatureValue)paramValue);
                }
                ++i;
            }
        }
    }

    private String getDefaultLanguageCode(EObject context) {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }
}

