/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.moxel;

import com._1c.g5.v8.dt.metadata.common.UrlPicture;
import com._1c.g5.v8.dt.moxel.Cell;
import com._1c.g5.v8.dt.moxel.ColumnsArea;
import com._1c.g5.v8.dt.moxel.CommentDrawing;
import com._1c.g5.v8.dt.moxel.Drawing;
import com._1c.g5.v8.dt.moxel.Format;
import com._1c.g5.v8.dt.moxel.Group;
import com._1c.g5.v8.dt.moxel.GroupDrawing;
import com._1c.g5.v8.dt.moxel.LanguageSettings;
import com._1c.g5.v8.dt.moxel.MoxelPackage;
import com._1c.g5.v8.dt.moxel.NamedItemCells;
import com._1c.g5.v8.dt.moxel.Row;
import com._1c.g5.v8.dt.moxel.RowsArea;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.v8.dt.moxel.TextDrawing;
import com._1c.g5.v8.dt.moxel.content.Area;
import com._1c.g5.v8.dt.moxel.content.BaseDrawingProperties;
import com._1c.g5.v8.dt.moxel.content.CellReference;
import com._1c.g5.v8.dt.moxel.content.CellsProperties;
import com._1c.g5.v8.dt.moxel.content.ColumnsProperties;
import com._1c.g5.v8.dt.moxel.content.ContentPackage;
import com._1c.g5.v8.dt.moxel.content.LocalString;
import com._1c.g5.v8.dt.moxel.content.RowsProperties;
import com._1c.g5.v8.dt.moxel.impl.NamedItemMapItemImpl;
import com.e1c.langtool.IBasicProcessor;
import com.e1c.langtool.v8.dt.internal.moxel.MoxelPlugin;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.EcoreUtil2;

public abstract class MoxelProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    protected final EObject object;
    private boolean processChildObjects = true;
    protected IProgressMonitor monitor;

    public MoxelProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (MoxelProcessor.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    protected static boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(MoxelPackage.eINSTANCE) || objectPackage.equals(ContentPackage.eINSTANCE);
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof SpreadsheetDocument) {
            this.doProcessInternal((SpreadsheetDocument)obj);
        } else if (obj instanceof Group) {
            this.doProcessInternal((Group)obj);
        } else if (obj instanceof Cell) {
            this.doProcessInternal((Cell)obj);
        } else if (obj instanceof Row) {
            this.doProcessInternal((Row)obj);
        } else if (obj instanceof LocalString) {
            this.doProcessInternal((LocalString)obj);
        } else if (obj instanceof Format) {
            this.doProcessInternal((Format)obj);
        } else if (obj instanceof CommentDrawing) {
            this.doProcessInternal((CommentDrawing)obj);
        } else if (obj instanceof TextDrawing) {
            this.doProcessInternal((TextDrawing)obj);
        } else if (obj instanceof GroupDrawing) {
            this.doProcessInternal((GroupDrawing)obj);
        } else if (obj instanceof Drawing) {
            this.doProcessInternal((Drawing)obj);
        } else if (obj instanceof UrlPicture) {
            this.doProcessInternal((UrlPicture)obj);
        } else if (obj instanceof NamedItemMapItemImpl) {
            this.doProcessInternal((NamedItemMapItemImpl)obj);
        } else if (obj instanceof CellsProperties) {
            this.doProcessInternal((CellsProperties)obj);
        } else if (obj instanceof RowsProperties) {
            this.doProcessInternal((RowsProperties)obj);
        } else if (obj instanceof ColumnsProperties) {
            this.doProcessInternal((ColumnsProperties)obj);
        } else if (obj instanceof BaseDrawingProperties) {
            this.doProcessInternal((BaseDrawingProperties)obj);
        } else if (MoxelPlugin.getDefault().isDebugging()) {
            System.err.println("Moxel doesn't have class handler: " + obj.getClass().toString());
        }
    }

    private void doProcessInternal(SpreadsheetDocument obj) {
        EMap namedItems;
        if (obj == null) {
            return;
        }
        this.doProcess(obj, SpreadsheetDocument.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getDrawings());
        this.doProcessInternal(obj.getLeftHeader());
        this.doProcessInternal(obj.getCenterHeader());
        this.doProcessInternal(obj.getRightHeader());
        this.doProcessInternal(obj.getLeftFooter());
        this.doProcessInternal(obj.getCenterFooter());
        this.doProcessInternal(obj.getRightFooter());
        this.doProcessInternal((EObject)obj.getViewSettings());
        this.doProcessInternal((Collection<? extends EObject>)obj.getRowGroups());
        this.doProcessInternal((Collection<? extends EObject>)obj.getColumnGroups());
        this.doProcessInternal((Collection<? extends EObject>)obj.getFormats());
        this.doProcessInternal(obj.getLanguageSettings());
        EMap rows = obj.getRows();
        if (rows != null) {
            for (Row row : rows.values()) {
                this.doProcessInternal(row);
            }
        }
        if ((namedItems = obj.getNamedItems()) != null) {
            for (Object namedItem : namedItems) {
                if (!(namedItem instanceof NamedItemMapItemImpl)) continue;
                this.doProcessInternal((NamedItemMapItemImpl)namedItem);
            }
        }
        this.doProcessInternal((Collection<? extends EObject>)obj.getPictures());
    }

    private void doProcessInternal(Group obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Group.class);
        this.doProcessInternal(obj.getText());
    }

    private void doProcessInternal(Drawing obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Drawing.class);
        this.doProcessInternal((EObject)obj.getDetailValue());
        if (obj == this.object && obj.getFormatIndex() > -1) {
            Format format = this.getFormat((EObject)obj, obj.getFormatIndex());
            this.doProcessInternal(format);
        }
    }

    private void doProcessInternal(GroupDrawing obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GroupDrawing.class);
        this.doProcessInternal((EObject)obj.getDetailValue());
        this.doProcessInternal((Collection<? extends EObject>)obj.getNestedDrawings());
        if (obj == this.object && obj.getFormatIndex() > -1) {
            Format format = this.getFormat((EObject)obj, obj.getFormatIndex());
            this.doProcessInternal(format);
        }
    }

    private void doProcessInternal(Cell obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Cell.class);
        this.doProcessInternal(obj.getNoteDrawing());
        this.doProcessInternal(obj.getText());
        this.doProcessInternal((EObject)obj.getDetailValue());
        this.doProcessInternal((EObject)obj.getValue());
        if (obj == this.object && obj.getFormatIndex() > -1) {
            Format format = this.getFormat((EObject)obj, obj.getFormatIndex());
            this.doProcessInternal(format);
        }
    }

    private Format getFormat(EObject obj, int formatIndex) {
        SpreadsheetDocument doc = (SpreadsheetDocument)EcoreUtil2.getContainerOfType((EObject)obj, SpreadsheetDocument.class);
        if (doc != null && doc.getFormats().size() > formatIndex) {
            return (Format)doc.getFormats().get(formatIndex);
        }
        return null;
    }

    private void doProcessInternal(CommentDrawing obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, CommentDrawing.class);
        this.doProcessInternal((EObject)obj.getDetailValue());
        this.doProcessInternal(obj.getText());
        this.doProcessInternal((EObject)obj.getValue());
        if (obj == this.object && obj.getFormatIndex() > -1) {
            Format format = this.getFormat((EObject)obj, obj.getFormatIndex());
            this.doProcessInternal(format);
        }
    }

    private void doProcessInternal(TextDrawing obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, TextDrawing.class);
        this.doProcessInternal((EObject)obj.getDetailValue());
        this.doProcessInternal(obj.getText());
        this.doProcessInternal((EObject)obj.getValue());
        if (obj == this.object && obj.getFormatIndex() > -1) {
            Format format = this.getFormat((EObject)obj, obj.getFormatIndex());
            this.doProcessInternal(format);
        }
    }

    private void doProcessInternal(Row obj) {
        EMap cells;
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Row.class);
        if (this.processChildObjects && (cells = obj.getCells()) != null) {
            this.doProcessInternal(cells.values());
        }
        if (obj == this.object && obj.getFormatIndex() > -1) {
            Format format = this.getFormat((EObject)obj, obj.getFormatIndex());
            this.doProcessInternal(format);
        }
    }

    private void doProcessInternal(NamedItemMapItemImpl obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, NamedItemMapItemImpl.class);
    }

    private void doProcessInternal(LocalString obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, LocalString.class);
    }

    private void doProcessInternal(Format obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Format.class);
        this.doProcessInternal(obj.getDataFormat());
        this.doProcessInternal(obj.getEditFormat());
        this.doProcessInternal(obj.getMask());
    }

    private void doProcessInternal(UrlPicture obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, UrlPicture.class);
    }

    private void doProcessInternal(CellsProperties obj) {
        CellReference ref;
        if (obj == null) {
            return;
        }
        Cell cell = MoxelProcessor.lookupCell(obj.getCellReference());
        this.doProcessInternal(cell);
        if (cell != null) {
            EObject spreadsheet = obj.getCellReference().getSpreadsheet();
            int formatIndex = cell.getFormatIndex();
            if (spreadsheet instanceof SpreadsheetDocument && ((SpreadsheetDocument)spreadsheet).getFormats().size() > formatIndex && formatIndex >= 0) {
                this.doProcessInternal((Format)((SpreadsheetDocument)spreadsheet).getFormats().get(formatIndex));
            }
        }
        if ((ref = obj.getCellReference()) == null || ref.getSpreadsheet() == null || !(ref.getSpreadsheet() instanceof SpreadsheetDocument)) {
            return;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        for (Map.Entry namedItem : spreadsheet.getNamedItems()) {
            if (!(namedItem instanceof NamedItemMapItemImpl) || !((String)namedItem.getKey()).equals(obj.getAreaName())) continue;
            this.doProcessInternal((NamedItemMapItemImpl)namedItem);
            break;
        }
    }

    private void doProcessInternal(RowsProperties obj) {
        if (obj == null) {
            return;
        }
        CellReference ref = obj.getCellReference();
        if (ref == null || ref.getSpreadsheet() == null || !(ref.getSpreadsheet() instanceof SpreadsheetDocument)) {
            return;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        int index = ref.getRowIndex();
        for (Map.Entry namedItem : spreadsheet.getNamedItems()) {
            Area area;
            if (!(namedItem instanceof NamedItemMapItemImpl) || !(namedItem.getValue() instanceof NamedItemCells) || !((area = ((NamedItemCells)namedItem.getValue()).getArea()) instanceof RowsArea) || ((RowsArea)area).getBegin() != index) continue;
            this.doProcessInternal((NamedItemMapItemImpl)namedItem);
        }
    }

    private void doProcessInternal(ColumnsProperties obj) {
        if (obj == null) {
            return;
        }
        CellReference ref = obj.getCellReference();
        if (ref == null || ref.getSpreadsheet() == null) {
            return;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        int index = ref.getColumnIndex();
        for (Map.Entry namedItem : spreadsheet.getNamedItems()) {
            Area area;
            if (!(namedItem instanceof NamedItemMapItemImpl) || !(namedItem.getValue() instanceof NamedItemCells) || !((area = ((NamedItemCells)namedItem.getValue()).getArea()) instanceof ColumnsArea) || ((ColumnsArea)area).getBegin() != index) continue;
            this.doProcessInternal((NamedItemMapItemImpl)namedItem);
        }
    }

    private void doProcessInternal(BaseDrawingProperties obj) {
        if (obj == null) {
            return;
        }
        Drawing drawing = MoxelProcessor.lookupDrowing(obj.getCellReference());
        this.doProcessInternal((EObject)drawing);
        if (drawing != null) {
            SpreadsheetDocument spreadsheet = (SpreadsheetDocument)obj.getCellReference().getSpreadsheet();
            int formatIndex = drawing.getFormatIndex();
            if (spreadsheet.getFormats().size() > formatIndex && formatIndex >= 0) {
                this.doProcessInternal((Format)spreadsheet.getFormats().get(formatIndex));
            }
        }
    }

    private void doProcessInternal(LanguageSettings obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, LanguageSettings.class);
    }

    private static Cell lookupCell(CellReference ref) {
        if (ref == null || ref.getSpreadsheet() == null) {
            return null;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        Row row = (Row)spreadsheet.getRows().get((Object)ref.getRowIndex());
        if (row == null) {
            return null;
        }
        return (Cell)row.getCells().get((Object)ref.getColumnIndex());
    }

    private static Drawing lookupDrowing(CellReference ref) {
        if (ref == null || ref.getSpreadsheet() == null) {
            return null;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        return (Drawing)spreadsheet.getDrawings().get(Integer.valueOf(ref.getRowIndex()).intValue());
    }
}

