/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt;

import com.e1c.langtool.v8.dt.IContextDefCacheProviderCleanable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ContextDefCacheCleaner {
    private final Map<IProject, PreferenceListener> projectListeners = new HashMap<IProject, PreferenceListener>();
    private final Map<IProject, Set<IEclipsePreferences>> projectPreferences = new HashMap<IProject, Set<IEclipsePreferences>>();

    public synchronized void init(IContextDefCacheProviderCleanable cacheProvider, IProject project, boolean isRussian) {
        IEclipsePreferences prefMobile;
        if (this.projectListeners.containsKey(project)) {
            return;
        }
        PreferenceListener changeListener = new PreferenceListener(project, cacheProvider, isRussian);
        ProjectScope projectScope = new ProjectScope(project);
        HashSet<IEclipsePreferences> preferences = new HashSet<IEclipsePreferences>();
        IEclipsePreferences prefManaged = projectScope.getNode("ManagedEnvironments");
        if (prefManaged != null) {
            prefManaged.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)changeListener);
            preferences.add(prefManaged);
        }
        if ((prefMobile = projectScope.getNode("MobileEnvironments")) != null) {
            prefMobile.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)changeListener);
            preferences.add(prefMobile);
        }
        this.projectPreferences.put(project, preferences);
    }

    public synchronized void dispose(IProject project) {
        Set preferences = this.projectPreferences.getOrDefault(project, Collections.emptySet());
        IEclipsePreferences.IPreferenceChangeListener listener = this.projectListeners.get(project);
        if (listener != null) {
            for (IEclipsePreferences preference : preferences) {
                preference.removePreferenceChangeListener(listener);
            }
            this.projectListeners.remove(project);
            this.projectPreferences.remove(project);
        }
    }

    private class PreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IContextDefCacheProviderCleanable cacheProvider;
        private final boolean isRussian;
        private final IProject project;

        public PreferenceListener(IProject project, IContextDefCacheProviderCleanable cacheProvider, boolean isRussian) {
            this.cacheProvider = cacheProvider;
            this.isRussian = isRussian;
            this.project = project;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.cacheProvider.clearCache(this.project, this.isRussian);
        }
    }
}

