/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt;

import com.e1c.langtool.common.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Utils {
    public static final String FQN_KEY = "Key";
    public static final String FQN_PARAM = "Param";
    public static final String FQN_COMMENT = "Comment";
    private static final Pattern STR_TEMPLATE_PATTERN = Pattern.compile("%(\\d+)");

    private Utils() {
    }

    public static URI getObjectURIRelativeTo(URI baseURI, EObject object) {
        return baseURI.appendFragment(EcoreUtil.getRelativeURIFragmentPath(null, (EObject)object));
    }

    public static String[] getParamsFromNls(String nlsString) {
        return Utils.getParamsMapFromNls(nlsString).keySet().toArray(new String[0]);
    }

    public static Map<String, String> getParamsMapFromNls(String nlsString) {
        String param;
        String source;
        if (StringUtils.isNullOrEmpty((String)nlsString)) {
            return Maps.newHashMap();
        }
        Matcher m = StringUtils.PERCENT_PARAMETER_PATTERN.matcher(nlsString);
        HashMap params = Maps.newHashMap();
        while (m.find()) {
            source = m.group(0);
            param = m.group(1);
            if (!StringUtils.isNotEmpty((String)param)) continue;
            params.put(param, source);
        }
        m = StringUtils.SQUARE_BRACKETS_PARAMETER_PATTERN.matcher(nlsString);
        while (m.find()) {
            source = m.group(0);
            param = m.group(1);
            if (!StringUtils.isNotEmpty((String)param)) continue;
            params.put(param, source);
        }
        return params;
    }

    public static Map<String, String> getStrTemplateParams(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            return Maps.newHashMap();
        }
        HashMap params = Maps.newHashMap();
        Matcher m = STR_TEMPLATE_PATTERN.matcher(value);
        while (m.find()) {
            String source = m.group(0);
            String param = m.group(1);
            if (!StringUtils.isNotEmpty((String)param)) continue;
            params.put(param, source);
        }
        return params;
    }
}

