/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.check;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.g5.v8.dt.check.CheckParameterDefinition;
import com.e1c.g5.v8.dt.check.ICheckDefinition;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.ext.ITopObjectFilter;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.v8.dt.check.Messages;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;

public class CheckTranslationExistExtension
implements IBasicCheckExtension {
    public static final String CHECK_COMPUTED_STRING_TRANSLATION_PARAMETER_NAME = "checkComputedStringTranslation";
    private final IResourceLookup resourceLookup;
    private final IStorageSettingsManager storageSettingsManager;
    private final ITranslatingProjectManager projectManager;

    @Inject
    public CheckTranslationExistExtension(IResourceLookup resourceLookup, ITranslatingProjectManager projectManager, IStorageSettingsManager storageSettingsManager) {
        this.resourceLookup = resourceLookup;
        this.projectManager = projectManager;
        this.storageSettingsManager = storageSettingsManager;
    }

    public void configureContextCollector(ICheckDefinition definition) {
        CheckParameterDefinition parameterDefinition = new CheckParameterDefinition(CHECK_COMPUTED_STRING_TRANSLATION_PARAMETER_NAME, Boolean.class, Boolean.FALSE.toString(), Messages.CheckTranslationExistExtension_Check_auto_computed_strings_has_translations);
        definition.addParameterDefinition(parameterDefinition);
    }

    public ITopObjectFilter contributeTopObjectFilter() {
        return (object, prameters) -> {
            IProject project = this.resourceLookup.getProject((EObject)object);
            if (project == null) {
                return false;
            }
            ITranslatingProject translatingProject = this.projectManager.getProject(project);
            if (!translatingProject.isTranslating() || translatingProject.getInterfaceLanguages().isEmpty()) {
                return false;
            }
            List ids = this.storageSettingsManager.getReadStorageIds(project);
            return ids != null && !ids.isEmpty();
        };
    }
}

