/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.collector;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.common.StringUtils;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FileFeatureValue;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.emf.collector.EFeatureValue;
import com.e1c.langtool.emf.collector.EmfFeatureValue;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class V8FeatureValue
extends EmfFeatureValue
implements FileFeatureValue {
    private static final long serialVersionUID = -6688866429776741874L;
    @Inject
    private transient IBmModelManager bmModelManager;
    @Inject
    private transient IProjectFileSystemSupportProvider fileSystemSupportProvider;
    @Inject
    private transient IResourceLookup resourceLookup;
    private static final String URI_FRAGMENT_ROOTOBJECT = "/";
    private String fullPath;
    private transient IFile file;
    private final String comment;

    protected V8FeatureValue(URI objectUri, EFeatureSettings settings, FeatureKey featureKey, String featureValue, boolean computedValue, String comment, boolean isUnknown, boolean isTag) {
        super(objectUri, settings, featureKey, featureValue, computedValue, isUnknown, isTag);
        this.comment = comment;
        DtPlugin.getDefault().getInjector().injectMembers((Object)this);
    }

    public IPath getResourceId() {
        return this.getFile().getProjectRelativePath();
    }

    public IFile getFile() {
        if (this.file == null && StringUtils.isNotEmpty((String)this.fullPath)) {
            Path path = new Path(this.fullPath);
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        if (this.file != null) {
            return this.file;
        }
        this.file = this.resourceLookup.getPlatformResource(this.getResourceUri());
        if (this.file != null) {
            return this.file;
        }
        boolean isPlatformUri = this.getResourceUri().isPlatform();
        if (isPlatformUri) {
            Path path = new Path(this.getResourceUri().toPlatformString(true));
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        } else {
            IPath path;
            URI rootObjectUri = this.getResourceUri().appendFragment(URI_FRAGMENT_ROOTOBJECT);
            IBmModel model = this.bmModelManager.getModel(rootObjectUri);
            if (model == null) {
                return this.file;
            }
            IBmTransaction transaction = model.getEngine().getCurrentTransaction();
            boolean isNewTransaction = false;
            if (transaction == null) {
                transaction = model.getEngine().beginReadOnlyTransaction(true);
                isNewTransaction = true;
            }
            IProject project = this.bmModelManager.getProject(model);
            try {
                IBmObject object = transaction.getObjectByUri(rootObjectUri);
                IProjectFileSystemSupport fileSystemSupport = this.fileSystemSupportProvider.getProjectFileSystemSupport(project);
                path = fileSystemSupport.getPath((EObject)object);
            }
            finally {
                if (isNewTransaction) {
                    transaction.commit();
                }
            }
            if (path != null && !path.isEmpty()) {
                this.file = project.getFile(path);
            }
        }
        if (this.file != null) {
            this.fullPath = this.file.getFullPath().toString();
        }
        return this.file;
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.fullPath == null ? 0 : this.fullPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        V8FeatureValue other = (V8FeatureValue)((Object)obj);
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        return !(this.fullPath == null ? other.fullPath != null : !this.fullPath.equals(other.fullPath));
    }

    public static class Builder {
        private URI objectUri;
        private IFile file;
        private ContextTranslationKey contextKey;
        private EFeatureSettings eSettings;
        private FeatureSettings settings;
        private FeatureKey featureKey;
        private String featureValue;
        private boolean computedValue;
        private boolean isUnknown;
        private boolean isTag;
        private final Map<String, String> localStrings = Maps.newHashMap();
        private String comment;

        @Deprecated
        public static Builder fromUri(URI objectUri) {
            Builder builder = new Builder();
            builder.objectUri = objectUri;
            return builder;
        }

        public static Builder fromFeatureValue(FeatureValue fv) {
            Builder builder = new Builder();
            if (fv instanceof EFeatureValue) {
                builder.objectUri = ((EFeatureValue)fv).getResourceUri();
            }
            builder.contextKey = fv.getContextKey();
            builder.featureKey = fv.getContextKey().getFeatureKey();
            builder.settings = fv.getContextKey().getFeatureSettings();
            builder.featureValue = fv.getContextKey().getValue();
            builder.computedValue = fv.isComputedValue();
            if (fv.getContextKey().getFeatureSettings() instanceof EFeatureSettings) {
                builder.eSettings = (EFeatureSettings)fv.getContextKey().getFeatureSettings();
            }
            builder.localStrings.clear();
            for (Map.Entry entry : fv.getLocalStrings().entrySet()) {
                builder.localStrings.put((String)entry.getKey(), (String)entry.getValue());
            }
            if (fv instanceof FileFeatureValue) {
                builder.file = ((FileFeatureValue)fv).getFile();
            } else if (fv.getContextKey() != null) {
                builder.file = TranslationUtils.getTranslationSourceFile((ContextTranslationKey)fv.getContextKey());
            }
            builder.setComment(fv.getComment());
            return builder;
        }

        public Builder setObjectUri(URI objectUri) {
            this.objectUri = objectUri;
            return this;
        }

        public Builder setFile(IFile file) {
            this.file = file;
            this.contextKey = null;
            return this;
        }

        public IFile getFile() {
            return this.file;
        }

        public Builder setFeatureSettings(EFeatureSettings settings) {
            this.eSettings = settings;
            this.settings = settings;
            this.contextKey = null;
            return this;
        }

        public FeatureKey getFeatureKey() {
            return this.featureKey;
        }

        public Builder setFeatureKey(FeatureKey featureKey) {
            this.featureKey = featureKey;
            this.contextKey = null;
            return this;
        }

        public String getValue() {
            return this.featureValue;
        }

        public Builder setValue(String featureValue) {
            this.featureValue = featureValue;
            this.contextKey = null;
            return this;
        }

        public Builder setComputedValue(boolean computedValue) {
            this.computedValue = computedValue;
            return this;
        }

        public boolean isComputedValue() {
            return this.computedValue;
        }

        public boolean isUnknown() {
            return this.isUnknown;
        }

        public boolean isTag() {
            return this.isTag;
        }

        public Map<String, String> getLocalStrings() {
            return this.localStrings;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public FeatureValue build() {
            if (this.objectUri == null && this.contextKey == null && this.file == null) {
                throw new IllegalArgumentException("Object URI, context key and file cannot be null");
            }
            if (this.eSettings == null && this.settings == null && this.file == null) {
                throw new IllegalArgumentException("Feature settings cannot be null");
            }
            if (this.featureKey == null) {
                throw new IllegalArgumentException("Feature key cannot be null");
            }
            if (this.file == null) {
                V8FeatureValue v8fv = new V8FeatureValue(this.objectUri, this.eSettings, this.featureKey, this.featureValue, this.computedValue, this.comment, this.isUnknown, this.isTag);
                this.file = v8fv.getFile();
            }
            if (this.contextKey == null) {
                this.contextKey = new ContextTranslationKeyImpl(this.file, this.featureKey, this.settings, this.featureValue);
            }
            PersistableFeatureValue newFeatureValue = new PersistableFeatureValue(this.contextKey, this.computedValue, this.comment);
            if (!this.localStrings.isEmpty()) {
                newFeatureValue.getLocalStrings().putAll(this.localStrings);
            }
            return newFeatureValue;
        }
    }
}

