/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.collector;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureCollectorFactory;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;

public class V8FileFeatureCollectorFactory
implements FeatureCollectorFactory {
    private static final Set<String> SKIP_EXT = Set.of("bsl");
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    private IDtProjectManager dtProjectManager;
    @Inject
    private IWorkspaceOrchestrator workspaceOrchestrator;

    public boolean isSupport(Object object) {
        if (!(object instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)object;
        if (file.getFileExtension() != null && SKIP_EXT.contains(file.getFileExtension())) {
            return false;
        }
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(file);
        return fqn != null && !fqn.isEmpty();
    }

    public Set<FeatureValueCollector> createCollectors(Object object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isLegal((boolean)(object instanceof IFile), (String)"Object must be IFile");
        IFile file = (IFile)object;
        IProject project = file.getProject();
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        if (dtProject == null) {
            return Collections.emptySet();
        }
        Object handle = this.workspaceOrchestrator.beginBackgroundOperation("create-v8-file-collector", Arrays.asList(dtProject), ProjectPipelineJob.BUILD);
        this.workspaceOrchestrator.endOperation(handle);
        IBmModel model = this.modelManager.getModel(project);
        if (model == null) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet collectors = Sets.newLinkedHashSet();
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        boolean isNewTransaction = false;
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(true);
            isNewTransaction = true;
        }
        try {
            QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(file);
            if (fqn != null && !fqn.isEmpty()) {
                IBmObject topObject = transaction.getTopObjectByFqn(fqn.toString());
                TranslationSource source = TranslationUtils.getTranslationSource((Object)topObject);
                if (source != null && topObject != null && this.collectingService.hasCollector((Object)topObject)) {
                    collectors.addAll(this.collectingService.createCollectors(source, parameters, addAction));
                } else if (topObject == null) {
                    URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    Resource resource = model.getEngine().getExternalResource(uri);
                    if (resource != null && !resource.getContents().isEmpty() && this.collectingService.hasCollector(resource.getContents().get(0))) {
                        source = TranslationUtils.getTranslationSource((Object)resource.getContents().get(0));
                        collectors.addAll(this.collectingService.createCollectors(source, parameters, addAction));
                    }
                }
            }
        }
        finally {
            if (isNewTransaction) {
                transaction.commit();
            }
        }
        return collectors;
    }
}

