/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.format;

import com._1c.g5.v8.dt.common.StringUtils;
import com._1c.g5.v8.dt.core.format.FormatStringParameter;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.inject.Singleton;

@Singleton
public class FormatInternalizeTokenProvider {
    public static final String NUMERAL_TYPE = "NM";
    public static final String BOOLEAN_FRACTION = "FS";
    public static final String BOOLEAN_FRACTION_RU = "\u0414\u041f";
    private static final String NUMERAL_TYPE_RU = "\u0427\u0421";
    private static final String NUMBER_PRESENTATION_RU = "\u041f\u0427";
    private static final String NUMBER_PRESENTATION = "NP";
    private static final String NUMBER_IN_WORDS_TYPE_RU = "\u0418\u0418";
    private static final String NUMBER_IN_WORDS_TYPE = "AU";
    private static final String GENDER_RU = "\u041f\u041b";
    private static final String GENDER = "GN";
    private static final String CASE_RU = "\u041f\u0414";
    private static final String CASE = "CS";
    protected BiMap<String, String> enumTokens;
    protected BiMap<String, String> dateFormatTokens;
    protected BiMap<String, String> dateFormatSymbols;
    protected BiMap<String, String> localDateFormatTokens;
    protected BiMap<String, String> numberInWordsType;
    protected BiMap<String, String> cases;
    protected BiMap<String, String> gender;
    protected BiMap<String, String> numberPresentation;
    protected BiMap<String, String> numeralType;
    private BiMap<String, String> booleanKeys;
    private BiMap<String, String> booleanType;

    public String getInternalizeEnumValue(String enumValue, boolean isRussian) {
        this.init();
        if (isRussian) {
            return this.getInternalizeEnumValue(enumValue, ScriptVariant.RUSSIAN);
        }
        return this.getInternalizeEnumValue(enumValue, ScriptVariant.ENGLISH);
    }

    public String getInternalizeEnumValue(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        FormatStringParameter token = FormatStringParameter.get((String)enumValue);
        if (token != null) {
            return token.getLocaleName(scriptVariant);
        }
        if (ScriptVariant.RUSSIAN.equals((Object)scriptVariant)) {
            if (enumValue.equals(BOOLEAN_FRACTION)) {
                return BOOLEAN_FRACTION_RU;
            }
            return (String)this.enumTokens.get((Object)enumValue);
        }
        return (String)this.enumTokens.inverse().get((Object)enumValue);
    }

    public String getInternalizeDateFormatValue(String enumValue, boolean isRussian) {
        this.init();
        if (isRussian) {
            return this.getInternalizeDateFormatValue(enumValue, ScriptVariant.RUSSIAN);
        }
        return this.getInternalizeDateFormatValue(enumValue, ScriptVariant.ENGLISH);
    }

    public String getInternalizeDateFormatValue(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.dateFormatTokens.get((Object)enumValue);
        }
        return (String)this.dateFormatTokens.inverse().get((Object)enumValue);
    }

    public String getInternalizeDateFormatSybmol(String symbol, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.dateFormatSymbols.get((Object)symbol);
        }
        return (String)this.dateFormatSymbols.inverse().get((Object)symbol);
    }

    public String getInternalizeLocalDateFormatValue(String enumValue, boolean isRussian) {
        this.init();
        if (isRussian) {
            return this.getInternalizeLocalDateFormatValue(enumValue, ScriptVariant.RUSSIAN);
        }
        return this.getInternalizeLocalDateFormatValue(enumValue, ScriptVariant.ENGLISH);
    }

    public String getInternalizeLocalDateFormatValue(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.localDateFormatTokens.get((Object)enumValue);
        }
        return (String)this.localDateFormatTokens.inverse().get((Object)enumValue);
    }

    public String getCase(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.cases.get((Object)enumValue);
        }
        return (String)this.cases.inverse().get((Object)enumValue);
    }

    public String getGender(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.gender.get((Object)enumValue);
        }
        return (String)this.gender.inverse().get((Object)enumValue);
    }

    public String getNumberInWordsType(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.numberInWordsType.get((Object)enumValue);
        }
        return (String)this.numberInWordsType.inverse().get((Object)enumValue);
    }

    public String getNumberPresentation(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.numberPresentation.get((Object)enumValue);
        }
        return (String)this.numberPresentation.inverse().get((Object)enumValue);
    }

    public String getNumeralType(String enumValue, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return (String)this.numeralType.get((Object)enumValue);
        }
        return (String)this.numeralType.inverse().get((Object)enumValue);
    }

    public String getBooleanType(String key, ScriptVariant scriptVariant) {
        this.init();
        if (scriptVariant == ScriptVariant.RUSSIAN) {
            return StringUtils.capitalize((String)((String)this.booleanType.get((Object)key.toLowerCase())));
        }
        return StringUtils.capitalize((String)((String)this.booleanType.inverse().get((Object)key.toLowerCase())));
    }

    public boolean isDataFormat(String enumValue) {
        FormatStringParameter token = FormatStringParameter.get((String)enumValue);
        return FormatStringParameter.DATE_FORMAT.equals((Object)token);
    }

    public boolean isLocalDataFormat(String enumValue) {
        FormatStringParameter token = FormatStringParameter.get((String)enumValue);
        return FormatStringParameter.DATE_LOCAL_FORMAT.equals((Object)token);
    }

    public boolean isCase(String enumValue) {
        return CASE.equals(enumValue) || CASE_RU.equals(enumValue);
    }

    public boolean isGender(String enumValue) {
        return GENDER.equals(enumValue) || GENDER_RU.equals(enumValue);
    }

    public boolean isNumberInWordsType(String enumValue) {
        return NUMBER_IN_WORDS_TYPE.equals(enumValue) || NUMBER_IN_WORDS_TYPE_RU.equals(enumValue);
    }

    public boolean isNumberPresentation(String enumValue) {
        return NUMBER_PRESENTATION.equals(enumValue) || NUMBER_PRESENTATION_RU.equals(enumValue);
    }

    public boolean isNumeralType(String enumValue) {
        return NUMERAL_TYPE.equals(enumValue) || NUMERAL_TYPE_RU.equals(enumValue);
    }

    public boolean isBooleanType(String key) {
        return this.booleanKeys.containsKey((Object)key) || this.booleanKeys.containsValue((Object)key);
    }

    public boolean isEnumType(String enumValue) {
        return this.enumTokens.containsKey((Object)enumValue) || this.enumTokens.containsValue((Object)enumValue);
    }

    protected void init() {
        this.initEnumTokens();
        this.initDateFormatTokens();
        this.initDateFormatSymbols();
        this.initLocalDateFormatTokens();
        this.initCases();
        this.initGender();
        this.initNumberInWordsType();
        this.initNumberPresentation();
        this.initNumeralType();
        this.initBooleanParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initEnumTokens() {
        if (this.enumTokens != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.enumTokens != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"L", (Object)"\u041b");
            builder.put((Object)"ND", (Object)"\u0427\u0426");
            builder.put((Object)"NFD", (Object)"\u0427\u0414\u0426");
            builder.put((Object)"NS", (Object)NUMERAL_TYPE_RU);
            builder.put((Object)"NDS", (Object)"\u0427\u0420\u0414");
            builder.put((Object)"NGS", (Object)"\u0427\u0420\u0413");
            builder.put((Object)"NZ", (Object)"\u0427\u041d");
            builder.put((Object)"NLZ", (Object)"\u0427\u0412\u041d");
            builder.put((Object)"NG", (Object)"\u0427\u0413");
            builder.put((Object)"NN", (Object)"\u0427\u041e");
            builder.put((Object)"DF", (Object)"\u0414\u0424");
            builder.put((Object)"DLF", (Object)"\u0414\u041b\u0424");
            builder.put((Object)"DE", (Object)BOOLEAN_FRACTION_RU);
            builder.put((Object)"BF", (Object)"\u0411\u041b");
            builder.put((Object)"BT", (Object)"\u0411\u0418");
            builder.put((Object)"NF", (Object)"\u0427\u0424");
            builder.put((Object)CASE, (Object)CASE_RU);
            builder.put((Object)NUMBER_PRESENTATION, (Object)NUMBER_PRESENTATION_RU);
            builder.put((Object)"FP", (Object)"\u0424\u041f");
            builder.put((Object)GENDER, (Object)GENDER_RU);
            builder.put((Object)"SN", (Object)"\u041d\u041f");
            builder.put((Object)"FN", (Object)"\u041d\u0414");
            builder.put((Object)NUMBER_IN_WORDS_TYPE, (Object)NUMBER_IN_WORDS_TYPE_RU);
            this.enumTokens = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isFormatKey(String key) {
        this.init();
        return this.isDataFormat(key) || this.isLocalDataFormat(key) || this.isBooleanType(key) || this.isCase(key) || this.isGender(key) || this.isNumberInWordsType(key) || this.isNumberPresentation(key) || this.isNumeralType(key) || this.isEnumType(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDateFormatTokens() {
        if (this.dateFormatTokens != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.dateFormatTokens != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"d", (Object)"\u0434");
            builder.put((Object)"dd", (Object)"\u0434\u0434");
            builder.put((Object)"ddd", (Object)"\u0434\u0434\u0434");
            builder.put((Object)"dddd", (Object)"\u0434\u0434\u0434\u0434");
            builder.put((Object)"M", (Object)"\u041c");
            builder.put((Object)"MM", (Object)"\u041c\u041c");
            builder.put((Object)"MMM", (Object)"\u041c\u041c\u041c");
            builder.put((Object)"MMMM", (Object)"\u041c\u041c\u041c\u041c");
            builder.put((Object)"q", (Object)"\u043a");
            builder.put((Object)"y", (Object)"\u0433");
            builder.put((Object)"yy", (Object)"\u0433\u0433");
            builder.put((Object)"yyyy", (Object)"\u0433\u0433\u0433\u0433");
            builder.put((Object)"h", (Object)"\u0447");
            builder.put((Object)"hh", (Object)"\u0447\u0447");
            builder.put((Object)"H", (Object)"\u0427");
            builder.put((Object)"HH", (Object)"\u0427\u0427");
            builder.put((Object)"m", (Object)"\u043c");
            builder.put((Object)"mm", (Object)"\u043c\u043c");
            builder.put((Object)"s", (Object)"\u0441");
            builder.put((Object)"ss", (Object)"\u0441\u0441");
            builder.put((Object)"tt", (Object)"\u0432\u0432");
            this.dateFormatTokens = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDateFormatSymbols() {
        if (this.dateFormatSymbols != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.dateFormatSymbols != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"d", (Object)"\u0434");
            builder.put((Object)"M", (Object)"\u041c");
            builder.put((Object)"q", (Object)"\u043a");
            builder.put((Object)"y", (Object)"\u0433");
            builder.put((Object)"h", (Object)"\u0447");
            builder.put((Object)"H", (Object)"\u0427");
            builder.put((Object)"m", (Object)"\u043c");
            builder.put((Object)"s", (Object)"\u0441");
            builder.put((Object)"t", (Object)"\u0432");
            this.dateFormatSymbols = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNumeralType() {
        if (this.numeralType != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.numeralType != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"Cardinal", (Object)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435");
            builder.put((Object)"Ordinal", (Object)"\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u043e\u0435");
            this.numeralType = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCases() {
        if (this.cases != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.cases != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"Nominative", (Object)"\u0418\u043c\u0435\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
            builder.put((Object)"Genitive", (Object)"\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
            builder.put((Object)"Dative", (Object)"\u0414\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
            builder.put((Object)"Accusative", (Object)"\u0412\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
            builder.put((Object)"Instrumental", (Object)"\u0422\u0432\u043e\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
            builder.put((Object)"Prepositional", (Object)"\u041f\u0440\u0435\u0434\u043b\u043e\u0436\u043d\u044b\u0439");
            this.cases = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNumberPresentation() {
        if (this.numberPresentation != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.numberPresentation != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"Number", (Object)"\u0427\u0438\u0441\u043b\u043e");
            builder.put((Object)"NumberInWords", (Object)"\u0427\u0438\u0441\u043b\u043e\u041f\u0440\u043e\u043f\u0438\u0441\u044c\u044e");
            builder.put((Object)"NumberWithEnding", (Object)"\u0427\u0438\u0441\u043b\u043e\u0421\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u043c");
            builder.put((Object)"Auto", (Object)"\u0410\u0432\u0442\u043e");
            this.numberPresentation = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initGender() {
        if (this.gender != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.gender != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"Masculine", (Object)"\u041c\u0443\u0436\u0441\u043a\u043e\u0439");
            builder.put((Object)"Feminine", (Object)"\u0416\u0435\u043d\u0441\u043a\u0438\u0439");
            this.gender = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNumberInWordsType() {
        if (this.numberInWordsType != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.numberInWordsType != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"DontUse", (Object)"\u041d\u0435\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c");
            builder.put((Object)"Use", (Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c");
            this.numberInWordsType = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLocalDateFormatTokens() {
        if (this.localDateFormatTokens != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.localDateFormatTokens != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"D", (Object)"\u0414");
            builder.put((Object)"DD", (Object)"\u0414\u0414");
            builder.put((Object)"T", (Object)"\u0412");
            builder.put((Object)"DT", (Object)"\u0414\u0412");
            builder.put((Object)"DDT", (Object)"\u0414\u0414\u0412");
            this.localDateFormatTokens = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBooleanParameters() {
        if (this.booleanKeys != null) {
            return;
        }
        Class<FormatInternalizeTokenProvider> clazz = FormatInternalizeTokenProvider.class;
        synchronized (FormatInternalizeTokenProvider.class) {
            if (this.booleanKeys != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)"SN", (Object)"\u041d\u041f");
            builder.put((Object)"FN", (Object)"\u041d\u0414");
            builder.put((Object)BOOLEAN_FRACTION, (Object)BOOLEAN_FRACTION_RU);
            this.booleanKeys = builder.build();
            builder = ImmutableBiMap.builder();
            builder.put((Object)"true", (Object)"\u0438\u0441\u0442\u0438\u043d\u0430");
            builder.put((Object)"false", (Object)"\u043b\u043e\u0436\u044c");
            this.booleanType = builder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

