/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.camelcase.ICamelCaseManager;
import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import com.e1c.langtool.v8.dt.internal.ExternalDependenciesModule;
import com.e1c.langtool.v8.dt.internal.ServiceModule;
import com.e1c.langtool.v8.dt.internal.collector.DtCollectingCacheManager;
import com.e1c.langtool.v8.dt.internal.platform.ExternalProjectRegistratorService;
import com.e1c.langtool.v8.dt.internal.stat.DtStatisticsService;
import com.e1c.langtool.v8.dt.languagecleaner.LanguageCleaner;
import com.e1c.langtool.v8.dt.languageconverter.LanguageConverter;
import com.e1c.langtool.v8.dt.settings.LocalizableTopEObjects;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class DtPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt";
    public static boolean TRACE_XTEXT_EDITINGS = false;
    public static boolean DEBUG_CONTEXT_DEF = false;
    private static DtPlugin plugin;
    private static BundleContext context;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;

    public static DtPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        DtPlugin.log(DtPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static void logError(String message, Throwable throwable) {
        DtPlugin.log(DtPlugin.createErrorStatus(message, throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        TRACE_XTEXT_EDITINGS = Boolean.valueOf(Platform.getDebugOption((String)"com.e1c.langtool.v8.dt/trace/xtextedits"));
        DEBUG_CONTEXT_DEF = Boolean.valueOf(Platform.getDebugOption((String)"com.e1c.langtool.v8.dt/debug/contextdef"));
        this.registrator = new InjectorAwareServiceRegistrator(bundleContext, this::getInjector);
        ServiceInitialization.schedule(() -> {
            this.registrator.managedService(ExternalProjectRegistratorService.class).activateBeforeRegistration().registerInjected();
            this.registrator.service(IDocumentProcessingSettingsManager.class).registerInjected();
            this.registrator.managedService(TranslationPreferences.class).activateBeforeRegistration().registerInjected();
            this.registrator.service(LocalizableTopEObjects.class).registerInjected();
            this.registrator.service(ICamelCaseManager.class).registerInjected();
            this.registrator.service(DtCollectingCacheManager.class).registerInjected();
            this.registrator.service(DtStatisticsService.class).registerInjected();
            this.registrator.service(LanguageCleaner.class).registerInjected();
            this.registrator.service(LanguageConverter.class).registerInjected();
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registrator.unregisterServices();
        context = null;
        plugin = null;
        this.injector = null;
        super.stop(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<DtPlugin> clazz = DtPlugin.class;
        synchronized (DtPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            DtPlugin.log(DtPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

