/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.camelcase;

import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.ProjectMultiThreadCollectingOperation;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.e1c.langtool.v8.dt.camelcase.ICamelCaseInterfaceProvider;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.camelcase.AbstrackCamelCaseStorage;
import com.e1c.langtool.v8.dt.internal.camelcase.CamelCaseStorage;
import com.e1c.langtool.v8.dt.internal.camelcase.CamelCaseStorageInMemory;
import com.e1c.langtool.v8.dt.internal.camelcase.ICamelCaseStorage;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.framework.Bundle;

public class CamelCaseInterfaceProvider
implements ICamelCaseInterfaceProvider {
    public static final String CACHE_FILE_PREFFIX = "camelcase";
    private static final int MAX_NAME_LENGTH = 80;
    private final IProject project;
    private Map<String, ICamelCaseStorage> storages = new ConcurrentHashMap<String, ICamelCaseStorage>();
    private final IFeatureValueCollectingService collectingService;
    private final ITranslatingProjectManager translatingProjectManager;
    private final ValidatorRegistry registry;
    private final ITranslationStorageManager storageManager;

    public CamelCaseInterfaceProvider(ITranslatingProject project, IFeatureValueCollectingService collectingService, ITranslatingProjectManager translatingProjectManager, ValidatorRegistry registry, ITranslationStorageManager storageManager) {
        this.collectingService = collectingService;
        this.translatingProjectManager = translatingProjectManager;
        this.registry = registry;
        this.storageManager = storageManager;
        this.project = project.getProject();
    }

    @Override
    public synchronized void computeData(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        @NonNull ITranslatingProject translationProject = this.translatingProjectManager.getProject(this.project);
        List modelLanguages = translationProject.getModelLanguages();
        TranslateLanguage defaultLanguage = translationProject.getDefaultLanguage();
        if (defaultLanguage == null) {
            return;
        }
        String sourceLanguageCode = defaultLanguage.getLanguageCode();
        BiConsumer<Object, FeatureValue> action = (object, featureValue) -> {
            if (monitor.isCanceled()) {
                return;
            }
            for (final TranslateLanguage language : modelLanguages) {
                String translation;
                String nameStorage = sourceLanguageCode + "-" + language.getLanguageCode();
                ICamelCaseStorage cacheStorage = this.storages.get(nameStorage);
                String source = featureValue.getContextKey().getValue();
                String sourceCameCase = this.toCamelCase(source);
                if (sourceCameCase.length() <= 0 || sourceCameCase.length() > 80 || (translation = this.getTranslation((FeatureValue)featureValue, language)).isEmpty()) continue;
                String translationCamelCase = this.toCamelCase(translation);
                FeatureValueValidator.ValidationContext context = new FeatureValueValidator.ValidationContext((FeatureValue)featureValue, translationCamelCase){
                    private final /* synthetic */ FeatureValue val$featureValue;
                    private final /* synthetic */ String val$translationCamelCase;
                    {
                        this.val$featureValue = featureValue;
                        this.val$translationCamelCase = string;
                    }

                    public IProject getProject() {
                        return CamelCaseInterfaceProvider.this.project;
                    }

                    public ITranslationStorageProvider.Storage getStorage() {
                        return CamelCaseInterfaceProvider.this.storageManager.getStorage(CamelCaseInterfaceProvider.this.project, StorageSettingsUtils.EDIT_DEFAULT_STORAGE_ID);
                    }

                    public TranslateLanguage getLanguage() {
                        return language;
                    }

                    public TranslationKey getTranslationKey() {
                        IFile file = this.val$featureValue.getContextKey().getSourceProject().getFile(this.val$featureValue.getContextKey().getResourceId());
                        FeatureKey featureKey = this.val$featureValue.getContextKey().getFeatureKey().skipLast(1).append(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME.getName());
                        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, this.val$translationCamelCase);
                    }
                };
                @NonNull FeatureValueValidator validator = this.registry.getValidator((FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME);
                if (translationCamelCase.length() <= 0 || translationCamelCase.length() > 80 || !validator.isValid(translationCamelCase, context).isOK()) continue;
                IPath resourceId = featureValue.getContextKey().getResourceId();
                try {
                    cacheStorage.put(resourceId, sourceCameCase.toLowerCase(), translationCamelCase);
                }
                catch (Exception e) {
                    DtPlugin.logError(e);
                    CamelCaseStorageInMemory storageInMemory = new CamelCaseStorageInMemory();
                    storageInMemory.start();
                    storageInMemory.put(resourceId, sourceCameCase.toLowerCase(), translationCamelCase);
                    ICamelCaseStorage old = this.storages.put(nameStorage, storageInMemory);
                    this.stopIfPossible(old);
                }
            }
        };
        ICollectingParameters parameters = this.createCollectingParameters();
        if (this.storages.entrySet().stream().filter(k -> ((ICamelCaseStorage)k.getValue()).invalidatedResources().hasNext()).count() == 0L) {
            boolean collect = true;
            for (Map.Entry<String, ICamelCaseStorage> storage : this.storages.entrySet()) {
                ICamelCaseStorage camelCaseStorage = storage.getValue();
                camelCaseStorage.startBatch();
                try {
                    if (!collect) continue;
                    try {
                        ProjectMultiThreadCollectingOperation operation = ProjectMultiThreadCollectingOperation.Builder.newBuilder().project(this.project).collectingService(this.collectingService).parameters(parameters).build();
                        operation.process(action, monitor);
                        collect = false;
                    }
                    catch (Exception e) {
                        DtPlugin.logError(e);
                    }
                }
                finally {
                    camelCaseStorage.endBatch();
                }
            }
        } else {
            boolean collect = true;
            for (Map.Entry<String, ICamelCaseStorage> storage : this.storages.entrySet()) {
                ICamelCaseStorage camelCaseStorage = storage.getValue();
                camelCaseStorage.startBatch();
                if (collect) {
                    Iterator<IPath> invalidatedResources = camelCaseStorage.invalidatedResources();
                    while (invalidatedResources.hasNext()) {
                        IPath location = invalidatedResources.next();
                        IFile file = this.project.getFile(location);
                        try {
                            this.collectingService.collectFile(file, parameters, action, monitor);
                            collect = false;
                        }
                        catch (Exception e) {
                            DtPlugin.logError(e);
                        }
                    }
                }
                camelCaseStorage.endBatch();
            }
        }
        if (this.storages.entrySet().stream().filter(k -> ((ICamelCaseStorage)k.getValue()).isBatch()).count() == 0L) {
            if (monitor.isCanceled()) {
                this.dispose();
            }
            this.storages.forEach((k, v) -> {
                try {
                    v.computeAgregate(monitor);
                }
                catch (Exception e) {
                    DtPlugin.logError(e);
                    CamelCaseStorageInMemory storageInMemory = new CamelCaseStorageInMemory();
                    storageInMemory.start();
                    ICamelCaseStorage old = this.storages.put((String)k, storageInMemory);
                    this.stopIfPossible(old);
                }
            });
        }
    }

    @Override
    public String getFirst(String source, TranslateLanguage sourceLanguage, TranslateLanguage targetLanguage, IProgressMonitor monitor) {
        ICamelCaseStorage storage = this.storages.get(sourceLanguage.getLanguageCode() + "-" + targetLanguage.getLanguageCode());
        if (storage == null) {
            return "";
        }
        String first = "";
        try {
            first = storage.getFirst(source, monitor);
        }
        catch (Exception e) {
            DtPlugin.logError(e);
        }
        return first;
    }

    @Override
    public List<String> getAll(String source, TranslateLanguage sourceLanguage, TranslateLanguage targetLanguage, IProgressMonitor monitor) {
        ICamelCaseStorage storage = this.storages.get(sourceLanguage.getLanguageCode() + "-" + targetLanguage.getLanguageCode());
        if (storage == null) {
            return Collections.emptyList();
        }
        List<String> all = Collections.emptyList();
        try {
            all = storage.getAll(source, monitor);
        }
        catch (Exception | IllegalAccessError e) {
            DtPlugin.logError(e);
        }
        return all;
    }

    @Override
    public void dispose() {
        for (Map.Entry<String, ICamelCaseStorage> storage : this.storages.entrySet()) {
            if (storage.getValue() == null) continue;
            this.stopIfPossible(storage.getValue());
        }
        this.storages.clear();
        ITranslatingProject translationProject = this.translatingProjectManager.getProject(this.project);
        List modelLanguages = translationProject.getModelLanguages();
        List translateLanguages = modelLanguages.stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toList());
        TranslateLanguage defaultLanguage = translationProject.getDefaultLanguage();
        if (defaultLanguage == null) {
            return;
        }
        String sourceLanguageCode = defaultLanguage.getLanguageCode();
        for (String language : translateLanguages) {
            String nameStorage = sourceLanguageCode + "-" + language;
            File file = this.getProjectCacheFile(nameStorage);
            TranslationUtils.cleanUpMabDbFiles((File)file);
        }
    }

    @Override
    public void stop() {
        for (Map.Entry<String, ICamelCaseStorage> entry : this.storages.entrySet()) {
            if (entry.getValue() == null) continue;
            this.stopIfPossible(entry.getValue());
        }
        this.storages.clear();
    }

    @Override
    public boolean dataComputed() {
        this.createOrOpenStorages();
        return this.storages.entrySet().stream().allMatch(e -> ((ICamelCaseStorage)e.getValue()).dataComputed());
    }

    @Override
    public void invalidate(IFile resource) {
        this.openStoragesIfExist();
        for (Map.Entry<String, ICamelCaseStorage> storage : this.storages.entrySet()) {
            try {
                storage.getValue().invalidate(resource);
            }
            catch (Exception | IllegalAccessError e) {
                DtPlugin.logError(e);
                CamelCaseStorageInMemory storageInMemory = new CamelCaseStorageInMemory();
                storageInMemory.start();
                ICamelCaseStorage old = storage.setValue(storageInMemory);
                this.stopIfPossible(old);
            }
        }
    }

    private void createOrOpenStorages() {
        @NonNull ITranslatingProject translationProject = this.translatingProjectManager.getProject(this.project);
        List modelLanguages = translationProject.getModelLanguages();
        List translateLanguages = modelLanguages.stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toList());
        TranslateLanguage defaultLanguage = translationProject.getDefaultLanguage();
        if (defaultLanguage == null) {
            return;
        }
        String sourceLanguageCode = defaultLanguage.getLanguageCode();
        for (String language : translateLanguages) {
            String nameStorage = sourceLanguageCode + "-" + language;
            this.storages.computeIfAbsent(nameStorage, k -> this.createStorage(nameStorage));
        }
    }

    private void openStoragesIfExist() {
        @NonNull ITranslatingProject translationProject = this.translatingProjectManager.getProject(this.project);
        List modelLanguages = translationProject.getModelLanguages();
        List translateLanguages = modelLanguages.stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toList());
        TranslateLanguage defaultLanguage = translationProject.getDefaultLanguage();
        if (defaultLanguage == null) {
            return;
        }
        String sourceLanguageCode = defaultLanguage.getLanguageCode();
        for (String language : translateLanguages) {
            File file;
            String nameStorage = sourceLanguageCode + "-" + language;
            if (this.storages.containsKey(nameStorage) || !(file = this.getProjectCacheFile(nameStorage)).exists()) continue;
            this.storages.computeIfAbsent(nameStorage, k -> this.createStorage(nameStorage));
        }
    }

    private ICollectingParameters createCollectingParameters() {
        return CollectingParameters.builder().collectInterface().collectChildObjects().collectSubResources().enableCache().build();
    }

    private String getTranslation(FeatureValue featureValue, TranslateLanguage language) {
        return this.getReader().getStoredTranslation((TranslationKey)featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
    }

    private IProjectTranslationReader getReader() {
        return this.storageManager.getTranslationReader(this.project);
    }

    private String toCamelCase(String name) {
        return StringUtils.textToCamelCase((String)name);
    }

    private ICamelCaseStorage createStorage(String fileName) {
        File file = this.getProjectCacheFile(fileName);
        AbstrackCamelCaseStorage storage = new CamelCaseStorage(file);
        try {
            storage.start();
            return storage;
        }
        catch (Throwable e) {
            this.stopIfPossible(storage);
            TranslationUtils.cleanUpMabDbFiles((File)file);
            try {
                storage.start();
                return storage;
            }
            catch (Throwable e2) {
                DtPlugin.logError(e2);
                this.stopIfPossible(storage);
                storage = new CamelCaseStorageInMemory();
                storage.start();
                return storage;
            }
        }
    }

    private File getProjectCacheFile(String fileName) {
        IPath path = Platform.getStateLocation((Bundle)DtPlugin.getDefault().getBundle());
        IPath folder = path.append(CACHE_FILE_PREFFIX).append(this.project.getName());
        folder.toFile().mkdirs();
        return folder.append(fileName).toFile();
    }

    private void stopIfPossible(ICamelCaseStorage storage) {
        if (storage != null) {
            try {
                storage.stop();
            }
            catch (Throwable e2) {
                DtPlugin.logError(e2);
            }
        }
    }
}

