/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.camelcase;

import com.e1c.langtool.collector.PathSerializer;
import com.e1c.langtool.v8.dt.internal.camelcase.AbstrackCamelCaseStorage;
import com.e1c.langtool.v8.dt.internal.camelcase.ResourceDataSerializer;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IPath;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

final class CamelCaseStorage
extends AbstrackCamelCaseStorage {
    private static final int CACHE_SIZE = 64000;
    private static final int DELAY = 1000;
    private static final String CACHE_RESOURCE_MAP_NAME = "resourceStorage";
    private static final String CACHE_MAP_NAME = "storage";
    private static final String INVALIDATED_RESOURCE_MAP_NAME = "invalidated";
    private final File file;
    private final AtomicBoolean storageCalculated;
    private volatile DB db;
    private volatile ConcurrentMap<IPath, Map<String, Map<String, Integer>>> cache;
    private volatile ConcurrentMap<String, List<String>> aggregatedCache;
    private volatile Set<IPath> invalidated;
    private volatile boolean started;
    private volatile AtomicInteger startedBatch;

    public CamelCaseStorage(File file) {
        this.file = file;
        this.storageCalculated = new AtomicBoolean(false);
    }

    @Override
    protected AtomicInteger getStartedBatch() {
        if (this.startedBatch == null) {
            this.startedBatch = new AtomicInteger();
        }
        return this.startedBatch;
    }

    @Override
    protected Map<IPath, Map<String, Map<String, Integer>>> getCache() {
        return this.cache;
    }

    @Override
    protected Map<String, List<String>> getAggregatedCache() {
        return this.aggregatedCache;
    }

    @Override
    protected Set<IPath> getInvalidated() {
        return this.invalidated;
    }

    @Override
    protected AtomicBoolean getStorageCalculated() {
        return this.storageCalculated;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.initializeDb();
        this.started = true;
    }

    @Override
    public void stop() {
        if (this.started && this.db != null && !this.db.isClosed()) {
            this.db.close();
        }
        this.db = null;
        this.started = false;
    }

    @Override
    public boolean isStoped() {
        return this.db == null;
    }

    private synchronized void initializeDb() {
        if (this.db == null || this.db.isClosed()) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ResourceDataSerializer.class.getClassLoader());
                PathSerializer pathSerializer = new PathSerializer();
                this.db = DBMaker.newFileDB((File)this.file).closeOnJvmShutdown().asyncWriteFlushDelay(1000).transactionDisable().cacheLRUEnable().cacheSize(64000).snapshotEnable().make();
                this.aggregatedCache = this.db.createHashMap(CACHE_MAP_NAME).keySerializer(Serializer.STRING).counterEnable().makeOrGet();
                this.storageCalculated.set(!this.aggregatedCache.isEmpty());
                this.cache = this.db.createHashMap(CACHE_RESOURCE_MAP_NAME).keySerializer((Serializer)pathSerializer).valueSerializer((Serializer)new ResourceDataSerializer()).counterEnable().makeOrGet();
                this.invalidated = this.db.createHashSet(INVALIDATED_RESOURCE_MAP_NAME).serializer((Serializer)pathSerializer).counterEnable().makeOrGet();
                this.cache.size();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }
}

