/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.languageprocessor;

import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.languageprocessor.Messages;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class BmLanguageProcessorTask
extends AbstractBmTask<Void> {
    private final IObjectLanguageProcessor languageProcessor;
    private final Set<Long> bmFeatures;
    private final LanguageProcessorParameters parameters;

    public BmLanguageProcessorTask(IObjectLanguageProcessor languageProcessor, Set<Long> bmFeatures, LanguageProcessorParameters parameters) {
        this.languageProcessor = languageProcessor;
        this.bmFeatures = bmFeatures;
        this.parameters = parameters;
    }

    public Void execute(IBmTransaction transaction, IProgressMonitor monitor) {
        if (this.parameters.isKeepLanguages() && !this.parameters.getLanguagesCodes().contains(this.parameters.getDefaultLanguageCode())) {
            this.parameters.getLanguagesCodes().add(this.parameters.getDefaultLanguageCode());
        }
        for (Long bmId : this.bmFeatures) {
            if (monitor.isCanceled()) {
                if (DtPlugin.getDefault().isDebugging()) {
                    DtPlugin.log(DtPlugin.createWarningStatus(Messages.LanguageProcessor_Language_processor_task_canceled));
                }
                return null;
            }
            try {
                this.languageProcessor.process(transaction, bmId, this.parameters);
            }
            catch (Exception e) {
                DtPlugin.logError(e);
            }
        }
        return null;
    }
}

