/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.platform;

import com._1c.g5.modeling.xml.AbstractXmlResource;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.sync.SynchronizableProject;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.platform.TranslatedConfigurationProject;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.platform.AbstractTranslateV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.e1c.langtool.v8.dt.projectsettings.TranslatedProjectManifest;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TranslatingConfigurationProject
extends AbstractTranslateV8Project
implements ITranslatingConfigurationProject,
SynchronizableProject {
    private static final IPath PATH_DT_INF_FOLDER = new Path("DT-INF");
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private Provider<ResourceSetImpl> resourceSetProvider;
    private final IResourceChangeListener projectManifestChangeListener = new ProjectManifestChangeListener();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile List<TranslateLanguage> modelLanguages;
    private volatile List<TranslateLanguage> allLanguages;
    private volatile List<V8TranslatedProject> v8TranslatedProjects;
    private volatile List<ITranslatedProject> translatedProjects;
    private volatile TranslateLanguage defaultLanguage;

    public TranslatingConfigurationProject(IProject project) {
        super(project);
    }

    public List<TranslateLanguage> getModelLanguages() {
        this.lock.readLock().lock();
        try {
            if (this.modelLanguages != null) {
                List<TranslateLanguage> list = this.modelLanguages;
                return list;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.modelLanguages == null) {
                ArrayList<TranslateLanguage> languageList = new ArrayList<TranslateLanguage>();
                for (TranslateLanguage language : this.getInterfaceLanguages()) {
                    if (!language.getOption().equals((Object)TranslationOption.MODEL_AND_INTERFACE)) continue;
                    languageList.add(language);
                }
                this.modelLanguages = List.copyOf(languageList);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.modelLanguages;
    }

    public List<TranslateLanguage> getInterfaceLanguages() {
        this.lock.readLock().lock();
        try {
            if (this.allLanguages != null) {
                List<TranslateLanguage> list = this.allLanguages;
                return list;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.allLanguages == null) {
                this.readProjectManifestFile();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.allLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITranslatedProject> getTranslatedProjects() {
        block12: {
            this.lock.readLock().lock();
            try {
                if (this.translatedProjects != null) {
                    List<ITranslatedProject> list = this.translatedProjects;
                    return list;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                if (this.translatedProjects != null) break block12;
                if (this.v8TranslatedProjects == null) {
                    this.readProjectManifestFile();
                }
                TranslatingConfigurationProject translatingConfigurationProject = this;
                synchronized (translatingConfigurationProject) {
                    this.translatedProjects = this.v8TranslatedProjects.stream().map(settingsProject -> {
                        IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(settingsProject.getName());
                        TranslatedConfigurationProject project = new TranslatedConfigurationProject(oldProject, (V8TranslatedProject)settingsProject, this);
                        DtPlugin.getDefault().getInjector().injectMembers((Object)project);
                        return project;
                    }).collect(Collectors.toList());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return this.translatedProjects;
    }

    public TranslateLanguage getDefaultLanguage() {
        this.lock.readLock().lock();
        try {
            if (this.defaultLanguage != null) {
                TranslateLanguage translateLanguage = this.defaultLanguage;
                return translateLanguage;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.defaultLanguage == null) {
                Language language = this.getConfiguration() == null ? this.loadFromConfiguration() : this.getConfiguration().getDefaultLanguage();
                this.defaultLanguage = this.getDefaultLanguageFromSettings(language);
                if (this.defaultLanguage == null && language != null) {
                    V8TranslateLanguage v8Lang = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
                    v8Lang.setOption(TranslationOption.MODEL_AND_INTERFACE);
                    LanguageUtil.copyLanguageContent((Language)language, (V8TranslateLanguage)v8Lang);
                    this.defaultLanguage = v8Lang;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.defaultLanguage;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurationProvider.getConfiguration(this.getProject());
    }

    public boolean isTranslating() {
        return !this.getInterfaceLanguages().isEmpty();
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.projectManifestChangeListener);
        this.resetProjectManifest();
        super.dispose();
    }

    private TranslateLanguage getDefaultLanguageFromSettings(Language defaultLanguage) {
        if (defaultLanguage instanceof TranslateLanguage) {
            return (TranslateLanguage)defaultLanguage;
        }
        if (defaultLanguage == null) {
            return null;
        }
        for (TranslateLanguage language : this.getInterfaceLanguages()) {
            if (!defaultLanguage.getUuid().equals(language.getUuid()) || !defaultLanguage.getLanguageCode().equals(language.getLanguageCode())) continue;
            return language;
        }
        return null;
    }

    private void readProjectManifestFile() {
        this.modelLanguages = null;
        this.defaultLanguage = null;
        this.translatedProjects = null;
        List<V8TranslateLanguage> loadedLanguages = TranslateLanguageManifest.loadAllIfAccessible(this.getProject());
        List<V8TranslatedProject> loadedProjects = TranslatedProjectManifest.loadAllIfAccessible(this.getProject());
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && !project.equals((Object)this.getProject()) && this.checkProjectAsDependent(project)) {
                loadedLanguages.addAll(this.readLanguagesFromExternalProject(project));
            }
            ++n2;
        }
        Collections.sort(loadedLanguages, (l1, l2) -> l1.getName().compareTo(l2.getName()));
        Collections.sort(loadedProjects, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        this.allLanguages = List.copyOf(loadedLanguages);
        this.v8TranslatedProjects = List.copyOf(loadedProjects);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.projectManifestChangeListener);
    }

    private void resetProjectManifest() {
        this.lock.writeLock().lock();
        try {
            this.modelLanguages = null;
            this.defaultLanguage = null;
            this.translatedProjects = null;
            this.allLanguages = null;
            this.v8TranslatedProjects = null;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener(this.projectManifestChangeListener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean checkProjectAsDependent(IProject project) {
        if (DependentManifestUtils.checkManifest(project)) {
            try {
                IProject sourceProject = DependentManifestUtils.readManifest(project, (IProgressMonitor)new NullProgressMonitor());
                if (sourceProject.equals((Object)this.getProject())) {
                    return true;
                }
            }
            catch (ManifestException e) {
                DtPlugin.logError(e);
            }
        }
        return false;
    }

    private Collection<V8TranslateLanguage> readLanguagesFromExternalProject(IProject project) {
        try {
            return TranslateLanguageManifest.loadAllIfAccessible(project);
        }
        catch (ManifestException e) {
            DtPlugin.logError(e);
            return Collections.emptyList();
        }
    }

    private Language loadFromConfiguration() {
        URI uri;
        Resource resource;
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        IFile file = this.getProject().getFile("src/Configuration/Configuration.mdo");
        if (file.exists() && !(resource = resourceSet.getResource(uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)).getContents().isEmpty()) {
            EObject obj;
            Object language;
            if (resource instanceof AbstractXmlResource) {
                ((AbstractXmlResource)resource).setLinker(null);
            }
            if ((language = (obj = (EObject)resource.getContents().get(0)).eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__DEFAULT_LANGUAGE, true)) instanceof Language) {
                if (((Language)language).eIsProxy()) {
                    String fragment = EcoreUtil.getURI((EObject)((Language)language)).fragment();
                    String defaultLanguageName = this.extractLanguageNameFromUriFragment(fragment);
                    EList languages = (EList)obj.eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__LANGUAGES, true);
                    for (Language lang : languages) {
                        if (!lang.getName().equals(defaultLanguageName)) continue;
                        return lang;
                    }
                } else {
                    return (Language)language;
                }
            }
        }
        return null;
    }

    private String extractLanguageNameFromUriFragment(String fragment) {
        String preffix = "::Language.";
        int index = fragment.indexOf("::Language.");
        if (index > -1 && fragment.length() > index + "::Language.".length()) {
            return fragment.substring(index + "::Language.".length());
        }
        return null;
    }

    private class ProjectManifestChangeListener
    implements IResourceChangeListener {
        private ProjectManifestChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event == null || event.getType() != 1 || event.getDelta() == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta.getResource() instanceof IProject && TranslatingConfigurationProject.this.getProject().equals((Object)delta.getResource()) && (delta.findMember(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES) != null || delta.findMember(PATH_DT_INF_FOLDER) != null)) {
                    CompletableFuture.runAsync(() -> TranslatingConfigurationProject.this.resetProjectManifest());
                    return;
                }
                ++n2;
            }
        }
    }
}

