/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.stat;

import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.lifecycle.ProjectStartType;
import com._1c.g5.v8.dt.core.lifecycle.ProjectStopType;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.stat.StatisticsService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;

@Singleton
@LifecycleService(name="DtStatisticsService")
public class DtStatisticsService {
    private final StatisticsService statisticsService;

    @Inject
    public DtStatisticsService(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    @LifecycleParticipant(phase=LifecyclePhase.INITIALIZATION)
    public void init(ProjectContext projectContext) {
        ProjectStartType startType;
        IDtProject dtProject = projectContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null && (startType = projectContext.getStartType()) == ProjectStartType.CLEAN_IMPORT) {
            this.statisticsService.getManager(project).removeStatistic();
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.STORAGE_CLOSING)
    public void dispose(ProjectContext lifecycleContext) {
        IDtProject dtProject = lifecycleContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        ProjectStopType stopType = lifecycleContext.getStopType();
        if (project != null) {
            boolean shouldRemove = stopType != ProjectStopType.IDE_SHUTDOWN;
            Job[] jobArray = Job.getJobManager().find((Object)"Statistics");
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getState() != 0) {
                    job.cancel();
                    shouldRemove = true;
                }
                ++n2;
            }
            if (shouldRemove) {
                this.statisticsService.getManager(project).removeStatistic();
            }
        }
    }
}

