/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.languageprocessor;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.bm.integration.IBatchSessionController;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.bm.integration.IBmTask;
import com._1c.g5.v8.derived.IDerivedDataManager;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IConfigurationAware;
import com._1c.g5.v8.dt.core.platform.IDerivedDataManagerProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IExternalObjectProject;
import com._1c.g5.v8.dt.core.platform.IExternalObjectProjectManager;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionsPackage;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingException;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.ProjectMultiThreadCollectingOperation;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.resource.ResourceTranslationSource;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import com.e1c.langtool.v8.dt.languageprocessor.Messages;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class LanguageProcessor {
    @Inject
    private IFeatureValueCollectingService featureValueCollectingService;
    @Inject
    private IDerivedDataManagerProvider derivedDataManagerProvider;
    @Inject
    private IBmModelManager bmModelManager;
    @Inject
    private IDtProjectManager dtProjectManager;
    @Inject
    private IWorkspaceOrchestrator orchestrator;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IExternalObjectProjectManager externalObjectProjectManager;

    protected abstract AbstractBmTask<Void> createBmProcessorTask(IProject var1, EPackage var2, Set<Long> var3, LanguageProcessorParameters var4);

    protected abstract AbstractBmTask<Void> createNonBmProcessorTask(EPackage var1, Set<URI> var2, LanguageProcessorParameters var3);

    /*
     * WARNING - void declaration
     */
    protected void fillFeatures(IProject project, Map<EPackage, Set<Long>> bmFeatures, Map<EPackage, Set<URI>> nonBmFeatures, LanguageProcessorParameters parameters, IProgressMonitor monitor) {
        HashSet<? extends TranslateLanguage> v8Languages = new HashSet<TranslateLanguage>(parameters.getTranslateLanguages());
        CollectingParameters collectingParameters = CollectingParameters.builder().collectChildObjects().collectInterface().collectSubResources().continueAfterFirstError().collectEmptyValue().setLanguages(v8Languages).disableCache().setKeepLanguagesMode(parameters.isKeepLanguages()).build();
        ProjectMultiThreadCollectingOperation operation = ProjectMultiThreadCollectingOperation.Builder.newBuilder().project(project).collectingService(this.featureValueCollectingService).parameters((ICollectingParameters)collectingParameters).subTaskName((done, total) -> MessageFormat.format(Messages.LanguageProcessor_Collected_works__0__1, done, total)).build();
        BiConsumer<Object, FeatureValue> collectConsumer = (sourceObject, featureValue) -> this.collectFeatureValues(sourceObject, (FeatureValue)featureValue, bmFeatures, nonBmFeatures, parameters);
        operation.process(collectConsumer, monitor);
        Collection errors = collectingParameters.getErrors();
        if (!errors.isEmpty()) {
            for (Exception error : errors) {
                void collectingException;
                Exception exception = error;
                if (!(exception instanceof CollectingException)) continue;
                CollectingException cfr_ignored_0 = (CollectingException)exception;
                CollectingException cfr_ignored_1 = (CollectingException)exception;
                if (collectingException.getSourcePath() == null) continue;
                IFile file = project.getFile(collectingException.getSourcePath());
                ResourceTranslationSource translationSource = new ResourceTranslationSource((IResource)file, project);
                this.featureValueCollectingService.forEachCollected((TranslationSource)translationSource, (ICollectingParameters)collectingParameters, monitor, collectConsumer);
            }
        }
    }

    protected V8TranslateLanguage createDerivedLanguage(Language language) {
        V8TranslateLanguage translateLanguage = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
        LanguageUtil.copyLanguageContent((Language)language, (V8TranslateLanguage)translateLanguage);
        return translateLanguage;
    }

    protected void processBmObjects(IProject project, Map<EPackage, Set<Long>> collectedWorks, LanguageProcessorParameters parameters, SubMonitor monitor) {
        IBmModel bmModel = this.bmModelManager.getModel(project);
        Collection allProjects = this.dtProjectManager.getDtProjects();
        this.checkMonitor(monitor);
        IDerivedDataManager derivedDataManager = this.derivedDataManagerProvider.get(project);
        derivedDataManager.disableImplicitWaiting();
        Object processModelOperationHandle = this.orchestrator.beginExclusiveOperation(Messages.LanguageProcessor_Process_objects_step_1, allProjects, ProjectPipelineJob.BUILD);
        monitor.setTaskName(Messages.LanguageProcessor_Process_objects_step_1);
        monitor.subTask("");
        try {
            Object batchSessionHandle = this.createBatchSessionHandle(bmModel);
            try {
                try {
                    ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                        ArrayList<AbstractBmTask<Void>> tasks = new ArrayList<AbstractBmTask<Void>>();
                        for (Map.Entry entry : collectedWorks.entrySet()) {
                            this.checkMonitor(monitor);
                            AbstractBmTask<Void> task = this.createBmProcessorTask(project, (EPackage)entry.getKey(), (Set)entry.getValue(), parameters);
                            if (task == null) continue;
                            tasks.add(task);
                        }
                        monitor.setWorkRemaining(tasks.size());
                        for (AbstractBmTask abstractBmTask : tasks) {
                            bmModel.executeInBatchSession(batchSessionHandle, (IBmTask)abstractBmTask);
                        }
                    }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    DtPlugin.logError(e);
                    bmModel.endBatchSession(batchSessionHandle);
                }
            }
            finally {
                bmModel.endBatchSession(batchSessionHandle);
            }
        }
        finally {
            this.orchestrator.endOperation(processModelOperationHandle);
            monitor.done();
            bmModel.waitAllEnqueuedEventsSent();
            derivedDataManager.enableImplicitWaiting();
        }
    }

    protected void processNonBmObjects(IProject project, Map<EPackage, Set<URI>> collectedWorks, LanguageProcessorParameters parameters, SubMonitor monitor) {
        IBmModel bmModel = this.bmModelManager.getModel(project);
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        this.checkMonitor(monitor);
        Object processModelOperationHandle = this.orchestrator.beginExclusiveOperation(Messages.LanguageProcessor_Process_objects_step_2, Collections.singleton(dtProject), ProjectPipelineJob.BUILD);
        monitor.setTaskName(Messages.LanguageProcessor_Process_objects_step_2);
        try {
            try {
                ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                    ArrayList<AbstractBmTask<Void>> tasks = new ArrayList<AbstractBmTask<Void>>();
                    for (Map.Entry entry : collectedWorks.entrySet()) {
                        this.checkMonitor(monitor);
                        AbstractBmTask<Void> task = this.createNonBmProcessorTask((EPackage)entry.getKey(), (Set)entry.getValue(), parameters);
                        if (task == null) continue;
                        tasks.add(task);
                    }
                    monitor.setWorkRemaining(tasks.size());
                    for (AbstractBmTask abstractBmTask : tasks) {
                        bmModel.getGlobalContext().execute((IBmTask)abstractBmTask);
                    }
                }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                DtPlugin.logError(e);
            }
        }
        finally {
            this.orchestrator.endOperation(processModelOperationHandle);
            monitor.done();
        }
    }

    protected void checkMonitor(SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void collectFeatureValues(Object sourceObject, FeatureValue featureValue, Map<EPackage, Set<Long>> bmFeatures, Map<EPackage, Set<URI>> nonBmFeatures, LanguageProcessorParameters parameters) {
        Object object;
        boolean needUpdate = this.isNeedToUpdateObject(parameters, sourceObject, featureValue);
        if (needUpdate && (object = sourceObject) instanceof EObject) {
            EObject rootContainer;
            EList contents;
            EObject sourceEObject;
            EObject eObject = (EObject)object;
            EObject cfr_ignored_0 = (EObject)object;
            Resource resource = sourceEObject.eResource();
            if (resource != null && (contents = resource.getContents()) != null && !contents.isEmpty() && this.isNeedRootContainer((rootContainer = (EObject)contents.get(0)).eClass().getEPackage())) {
                sourceEObject = rootContainer;
            }
            this.appendFeatures(featureValue, sourceEObject, bmFeatures, nonBmFeatures);
        }
    }

    protected void deleteLanguages(final IProject project, final LanguageProcessorParameters parameters, final SubMonitor monitor) {
        IBmModel bmModel = this.bmModelManager.getModel(project);
        Collection allProjects = this.dtProjectManager.getDtProjects();
        this.checkMonitor(monitor);
        IDerivedDataManager derivedDataManager = this.derivedDataManagerProvider.get(project);
        derivedDataManager.disableImplicitWaiting();
        Object processModelOperationHandle = this.orchestrator.beginExclusiveOperation(Messages.LanguageProcessor_Process_objects_step_1, allProjects, ProjectPipelineJob.BUILD);
        monitor.setTaskName(Messages.LanguageProcessor_Deleting_languages);
        try {
            Object batchSessionHandle = this.createBatchSessionHandle(bmModel);
            try {
                try {
                    ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                        this.checkMonitor(monitor);
                        AbstractBmTask<Void> task = new AbstractBmTask<Void>(){

                            /*
                             * WARNING - void declaration
                             */
                            public Void execute(IBmTransaction transaction, IProgressMonitor progressMonitor) {
                                Set<Language> languagesToDelete = LanguageProcessor.this.getLanguagesToDelete(project, parameters);
                                IV8Project v8Project = LanguageProcessor.this.v8ProjectManager.getProject(project);
                                IV8Project iV8Project = v8Project;
                                if (iV8Project instanceof IConfigurationAware) {
                                    void configurationAwareProject;
                                    IConfigurationAware iConfigurationAware = (IConfigurationAware)iV8Project;
                                    IConfigurationAware cfr_ignored_0 = (IConfigurationAware)iV8Project;
                                    Configuration configuration = configurationAwareProject.getConfiguration();
                                    languagesToDelete.forEach(l -> {
                                        boolean bl = configuration.getLanguages().remove(l);
                                    });
                                } else {
                                    Assert.isTrue((boolean)(v8Project instanceof IExternalObjectProject));
                                    Set langCodesToDelete = languagesToDelete.stream().map(l -> l.getLanguageCode()).collect(Collectors.toSet());
                                    IExternalObjectProject externalProject = (IExternalObjectProject)v8Project;
                                    List<Language> newLanguages = externalProject.getLanguages().stream().filter(l -> !langCodesToDelete.contains(l.getLanguageCode())).toList();
                                    LanguageProcessor.this.externalObjectProjectManager.setLanguages(externalProject, newLanguages, (IProgressMonitor)monitor);
                                }
                                return null;
                            }
                        };
                        bmModel.executeInBatchSession(batchSessionHandle, (IBmTask)task);
                    }, (ISchedulingRule)project, 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    DtPlugin.logError(e);
                    bmModel.endBatchSession(batchSessionHandle);
                }
            }
            finally {
                bmModel.endBatchSession(batchSessionHandle);
            }
        }
        finally {
            this.orchestrator.endOperation(processModelOperationHandle);
            monitor.done();
            bmModel.waitAllEnqueuedEventsSent();
            derivedDataManager.enableImplicitWaiting();
        }
    }

    private Set<Language> getLanguagesToDelete(IProject project, LanguageProcessorParameters parameters) {
        HashSet<Language> languagesToDelete = new HashSet<Language>();
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        IV8Project v8Project = this.v8ProjectManager.getProject(project);
        if (parameters.isKeepLanguages()) {
            ArrayList<Language> projectLanguages = new ArrayList<Language>(v8Project.getLanguages().stream().filter(language -> !language.getLanguageCode().equals(parameters.getDefaultLanguageCode()) && LanguageUtil.getTranslateLanguage((ITranslatingProject)translating, (Language)language).isEmpty()).toList());
            projectLanguages.removeAll(parameters.getProcessingLanguages());
            languagesToDelete.addAll(projectLanguages);
        } else {
            for (Language processingLanguage : parameters.getProcessingLanguages()) {
                Optional translateLanguage = LanguageUtil.getTranslateLanguage((ITranslatingProject)translating, (Language)processingLanguage);
                if (processingLanguage.getLanguageCode().equals(parameters.getDefaultLanguageCode()) && !translateLanguage.isEmpty()) continue;
                languagesToDelete.add(processingLanguage);
            }
        }
        return languagesToDelete;
    }

    private boolean isNeedToUpdateObject(LanguageProcessorParameters parameters, Object sourceObject, FeatureValue featureValue) {
        if (!(sourceObject instanceof EObject)) {
            return false;
        }
        if (((EObject)sourceObject).eClass().getEPackage() instanceof MdClassPackage) {
            return true;
        }
        boolean needUpdate = false;
        if (parameters.isKeepLanguages()) {
            Map localStrings = featureValue.getLocalStrings();
            for (Map.Entry entry : localStrings.entrySet()) {
                if (parameters.getLanguagesCodes().contains(entry.getKey())) continue;
                needUpdate = true;
                break;
            }
        } else {
            for (String languageCode : parameters.getLanguagesCodes()) {
                Map localStrings = featureValue.getLocalStrings();
                needUpdate |= localStrings.containsKey(languageCode);
            }
        }
        return needUpdate;
    }

    private void appendFeatures(FeatureValue featureValue, EObject sourceEObject, Map<EPackage, Set<Long>> bmFeatures, Map<EPackage, Set<URI>> nonBmFeatures) {
        URI sourceURI = EcoreUtil.getURI((EObject)sourceEObject);
        if (sourceEObject instanceof Expressions) {
            sourceURI = URI.createPlatformResourceURI((String)featureValue.getContextKey().getFullPath(), (boolean)true);
        }
        long sourceBmId = -1L;
        if (!sourceURI.isPlatformResource()) {
            sourceBmId = ((IBmObject)sourceEObject).bmGetId();
        }
        if (sourceBmId != -1L) {
            Set idSet = bmFeatures.computeIfAbsent(sourceEObject.eClass().getEPackage(), p -> Sets.newConcurrentHashSet());
            idSet.add(sourceBmId);
        } else {
            Set uriSet = nonBmFeatures.computeIfAbsent(sourceEObject.eClass().getEPackage(), p -> Sets.newConcurrentHashSet());
            uriSet.add(sourceURI);
        }
    }

    private boolean isNeedRootContainer(EPackage ePackage) {
        return BslPackage.eINSTANCE.equals(ePackage) || ExpressionsPackage.eINSTANCE.equals(ePackage);
    }

    private Object createBatchSessionHandle(IBmModel bmModel) {
        BatchSessionController controller = new BatchSessionController();
        return bmModel.beginBatchSession((Object)controller);
    }

    private static final class BatchSessionController
    implements IBatchSessionController {
        private BatchSessionController() {
        }

        public void onBeforeEventProcessing() {
        }

        public void onAfterSave() {
        }

        public void onAfterEventProcessing() {
        }

        public void onBeforeSave(int taskCount) {
        }

        public boolean isParallelSaveAllowed() {
            return true;
        }

        public boolean isAsyncSaveRequired() {
            return true;
        }
    }
}

