/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.languageprocessor;

import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;

public final class LanguageProcessorRegistry {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.v8.dt.languageProcessors";
    private static final String SUBITEM_RESOURCE_PROCESSOR = "translationsProcessor";
    private static final String ATTR_CLASS = "class";
    private volatile List<IObjectLanguageProcessor> registeredResourceLanguageProcessors;

    public IObjectLanguageProcessor getResourceLanguageProcessor(EPackage ePackage) {
        IObjectLanguageProcessor result = null;
        for (IObjectLanguageProcessor resourceLanguageProcessor : this.getRegisteredResourceLanguageProcessors()) {
            if (!resourceLanguageProcessor.isSupported(ePackage)) continue;
            return resourceLanguageProcessor;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IObjectLanguageProcessor> getRegisteredResourceLanguageProcessors() {
        if (this.registeredResourceLanguageProcessors == null) {
            LanguageProcessorRegistry languageProcessorRegistry = this;
            synchronized (languageProcessorRegistry) {
                if (this.registeredResourceLanguageProcessors == null) {
                    IConfigurationElement[] configurationElements;
                    this.registeredResourceLanguageProcessors = new ArrayList<IObjectLanguageProcessor>();
                    IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
                    int n = configurationElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                        try {
                            if (SUBITEM_RESOURCE_PROCESSOR.equals(configurationElement.getName())) {
                                IObjectLanguageProcessor processor = (IObjectLanguageProcessor)configurationElement.createExecutableExtension(ATTR_CLASS);
                                this.registeredResourceLanguageProcessors.add(processor);
                            }
                        }
                        catch (CoreException e) {
                            DtPlugin.logError(e);
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.registeredResourceLanguageProcessors;
    }
}

