/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.projectsettings;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.projectsettings.DependentProjectManifestModel;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.google.common.collect.ImmutableSet;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class DependentManifestUtils {
    public static final String DT_INF = "DT-INF";
    public static final String MANIFEST_FILE = "DEPENDENT.PMF";
    private static final IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();

    public static Set<TranslateLanguage> getInterceptedLanguages(ITranslatingProject project, Set<String> locales) {
        ImmutableSet parentLangs = ImmutableSet.builder().addAll((Iterable)project.getInterfaceLanguages()).addAll((Iterable)project.getModelLanguages()).build();
        Function<String, Optional> findLanguageByCode = arg_0 -> DependentManifestUtils.lambda$0((Set)parentLangs, arg_0);
        return locales.stream().map(findLanguageByCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public static IPath getManifestRawLocation(IProject project) {
        IFile manifest = project.getFolder(DT_INF).getFile(MANIFEST_FILE);
        return project.getWorkspace().getRoot().getRawLocation().append(manifest.getFullPath());
    }

    public static boolean checkManifest(IProject project) {
        return project.getFolder(DT_INF).getFile(MANIFEST_FILE).isAccessible();
    }

    public static IProject readManifest(IProject project, IProgressMonitor monitor) {
        IFile manifest = project.getFolder(DT_INF).getFile(MANIFEST_FILE);
        DependentProjectManifestModel manifestModel = new DependentProjectManifestModel("");
        try {
            manifestModel.parse(new FileInputStream(manifest.getLocation().toFile()));
        }
        catch (IOException e) {
            throw new ManifestException(e);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(manifestModel.getParentProject());
    }

    public static ITranslatingProject readManifest(IProject project, ITranslatingProjectManager projectManager, IProgressMonitor monitor) {
        IFile manifest = project.getFolder(DT_INF).getFile(MANIFEST_FILE);
        DependentProjectManifestModel manifestModel = new DependentProjectManifestModel("");
        try {
            manifestModel.parse(new FileInputStream(manifest.getLocation().toFile()));
        }
        catch (IOException e) {
            throw new ManifestException(e);
        }
        return projectManager.getProject(manifestModel.getParentProject());
    }

    public static void writeManifest(IProject parent, IProject dependent, IProgressMonitor monitor) {
        IFolder dtInfFolder = dependent.getFolder(DT_INF);
        if (!dtInfFolder.exists()) {
            try {
                dtInfFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new ManifestException("Can't create 'DT-INF' folder", e);
            }
        }
        String parentProjectName = parent.getName();
        DependentProjectManifestModel manifestModel = new DependentProjectManifestModel(parentProjectName);
        IFile file = dtInfFolder.getFile(MANIFEST_FILE);
        ISchedulingRule rule = ruleFactory.createRule((IResource)file);
        try {
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                manifestModel.dump(new FileOutputStream(file.getLocation().toFile()));
            }
            catch (IOException e) {
                throw new ManifestException(e);
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
        rule = ruleFactory.createRule((IResource)file);
        try {
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new ManifestException(e);
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public static void removeManifest(IProject project, IProgressMonitor monitor) {
        IFile manifest = project.getFolder(DT_INF).getFile(MANIFEST_FILE);
        try {
            if (manifest.exists()) {
                manifest.delete(false, monitor);
            }
        }
        catch (CoreException e) {
            throw new ManifestException(e);
        }
    }

    private DependentManifestUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static /* synthetic */ Optional lambda$0(Set set, String locale) {
        return set.stream().filter(lang -> lang.getLanguageCode().equals(locale)).findFirst();
    }
}

