/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.projectsettings;

import com._1c.g5.v8.dt.common.FileUtil;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.MdExtendedMetaData;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public final class TranslateLanguageManifest {
    public static URI getUri(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public static IFile getFile(IProject project, V8TranslateLanguage language) {
        String languageName = language.getName();
        IPath path = TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES.append(languageName).append(languageName).addFileExtension("tlx");
        return project.getFile(path);
    }

    public static void delete(IFile lanuguageFile, IProgressMonitor progressMonitor) {
        if (!lanuguageFile.isAccessible()) {
            throw new ManifestException("File to delete is not accessible");
        }
        try {
            lanuguageFile.delete(true, progressMonitor);
        }
        catch (CoreException e) {
            throw new ManifestException(e);
        }
    }

    public static void delete(IProject project, String languageName, IProgressMonitor monitor) {
        IFolder folder = project.getFolder(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
        TranslateLanguageManifest.delete(folder, languageName, monitor);
    }

    public static void delete(IFolder parentFolder, String languageName, IProgressMonitor monitor) {
        if (!parentFolder.isAccessible()) {
            throw new ManifestException("Parent folder must be accessible for '" + languageName + "' language");
        }
        IFolder languageFolder = parentFolder.getFolder(languageName);
        if (!languageFolder.isAccessible()) {
            throw new ManifestException("Language folder must be accessible for '" + languageName + "' language");
        }
        IFile file = languageFolder.getFile(languageName + ".tlx");
        TranslateLanguageManifest.delete(file, monitor);
        try {
            FileUtil.cleanFolderIfEmpty((IContainer)languageFolder);
            FileUtil.cleanFolderIfEmpty((IContainer)parentFolder);
        }
        catch (CoreException e) {
            throw new ManifestException(e);
        }
    }

    public static void saveAll(IFolder parentFolder, Collection<V8TranslateLanguage> languages) {
        for (V8TranslateLanguage language : languages) {
            IFile file = TranslateLanguageManifest.getFile(parentFolder.getProject(), language);
            TranslateLanguageManifest.save(file, language, null, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static byte[] save(IFile file, V8TranslateLanguage translateLanguage, HashFunction hashFunction, IProgressMonitor monitor) {
        Object oldUri;
        XMLResource resource = (XMLResource)translateLanguage.eResource();
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        SignatureComputer signatureComputer = null;
        if (hashFunction != null) {
            signatureComputer = new SignatureComputer(hashFunction);
            options.put("CIPHER", signatureComputer);
        }
        options.put("ENCODING", StandardCharsets.UTF_8.name());
        URI uri = TranslateLanguageManifest.getUri(file);
        IFile oldFile = null;
        if (resource != null) {
            oldUri = resource.getURI();
            if (!uri.equals(oldUri)) {
                resource.setURI(uri);
                Path path = new Path(oldUri.toPlatformString(true));
                oldFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        } else {
            resource = new XMLResourceImpl(uri);
            resource.getContents().add((Object)translateLanguage);
        }
        resource.getDefaultSaveOptions().put("EXTENDED_META_DATA", new MdExtendedMetaData());
        try {
            oldUri = null;
            Object var10_12 = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                resource.save((OutputStream)outputStream, options);
                Throwable throwable = null;
                Object var13_17 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());){
                    if (file.exists()) {
                        file.setContents((InputStream)is, true, true, monitor);
                    } else {
                        FileUtil.createParentFolders((IFile)file);
                        file.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (oldFile != null && oldFile.exists()) {
                        oldFile.delete(true, monitor);
                        FileUtil.cleanFolderIfEmpty((IContainer)oldFile.getParent());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                byte[] byArray = signatureComputer != null ? signatureComputer.signature() : null;
                return byArray;
            }
            catch (Throwable throwable) {
                if (oldUri == null) {
                    oldUri = throwable;
                } else if (oldUri != throwable) {
                    ((Throwable)oldUri).addSuppressed(throwable);
                }
                throw oldUri;
            }
        }
        catch (IOException | CoreException e) {
            throw new ManifestException("Couldn't save the given language to file", e);
        }
    }

    public static void saveAll(IProject project, Collection<V8TranslateLanguage> languages, IProgressMonitor monitor) {
        languages.forEach(lang -> TranslateLanguageManifest.save(project, lang, monitor));
    }

    public static void save(IProject project, V8TranslateLanguage translateLanguage, IProgressMonitor monitor) {
        IFile file = TranslateLanguageManifest.getFile(project, translateLanguage);
        TranslateLanguageManifest.save(file, translateLanguage, null, monitor);
    }

    public static V8TranslateLanguage load(IFile file) {
        V8TranslateLanguage translateLanguage = null;
        XMLResource resource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", StandardCharsets.UTF_8.name());
        options.put("EXTENDED_META_DATA", (Object)new MdExtendedMetaData());
        resourceSet.getLoadOptions().putAll(options);
        URI uri = TranslateLanguageManifest.getUri(file);
        try {
            resource = (XMLResource)resourceSet.getResource(uri, true);
            translateLanguage = (V8TranslateLanguage)resource.getContents().get(0);
        }
        catch (ClassCastException e) {
            throw new ManifestException("The given resource has invalid format", e);
        }
        return translateLanguage;
    }

    public static List<V8TranslateLanguage> loadAllIfAccessible(IProject project) {
        if (!project.isAccessible()) {
            return new ArrayList<V8TranslateLanguage>();
        }
        IFolder parentFolder = project.getFolder(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
        if (parentFolder.isAccessible()) {
            return TranslateLanguageManifest.loadAll(project);
        }
        return new ArrayList<V8TranslateLanguage>();
    }

    public static List<V8TranslateLanguage> loadAll(IProject project) {
        IFolder parentFolder = project.getFolder(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
        return TranslateLanguageManifest.loadAll(parentFolder);
    }

    public static List<V8TranslateLanguage> loadAll(IFolder dtInfFolder) {
        if (!dtInfFolder.isAccessible()) {
            throw new ManifestException("DT-INF folder must be accessible");
        }
        IResource[] members = null;
        try {
            members = dtInfFolder.members();
        }
        catch (CoreException e) {
            throw new ManifestException("DT-INF folder must be accessible");
        }
        ArrayList<V8TranslateLanguage> languages = new ArrayList<V8TranslateLanguage>();
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Path path;
            IFile file;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder && Files.exists((file = ((IFolder)resource).getFile((path = new Path(resource.getName())).addFileExtension("tlx"))).getLocation().toPath(), new LinkOption[0])) {
                V8TranslateLanguage lang = TranslateLanguageManifest.load(file);
                languages.add(lang);
            }
            ++n2;
        }
        return languages;
    }

    private TranslateLanguageManifest() {
        throw new IllegalStateException("It's utility class");
    }

    private static class SignatureComputer
    implements URIConverter.Cipher {
        private final HashFunction hashFunction;
        private HashingOutputStream hashingOutputStream;

        public SignatureComputer(HashFunction hashFunction) {
            this.hashFunction = hashFunction;
        }

        public OutputStream encrypt(OutputStream outputStream) throws Exception {
            this.hashingOutputStream = new HashingOutputStream(this.hashFunction, outputStream);
            return this.hashingOutputStream;
        }

        public void finish(OutputStream outputStream) throws Exception {
        }

        public InputStream decrypt(InputStream inputStream) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void finish(InputStream inputStream) throws Exception {
            throw new UnsupportedOperationException();
        }

        byte[] signature() {
            return this.hashingOutputStream.hash().asBytes();
        }
    }
}

