/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.settings;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

@Singleton
public class LocalizableTopEObjects {
    public static final String EXTENSION_POINT = "com.e1c.langtool.v8.dt.localizableTopEObjects";
    private static final String PACKAGE_URI = "uri";
    private static final String TOP_OBJECT_CLASS_NAME_ATTR = "className";
    private static final String TOP_OBJECT_BM_ATTR = "bm";
    private List<Pair<EClass, Boolean>> topObjectClasses;
    private List<EPackage> packages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<EClass> getAllEClass() {
        if (this.topObjectClasses != null) return this.topObjectClasses.stream().map(Pair::getKey).collect(Collectors.toList());
        Class<LocalizableTopEObjects> clazz = LocalizableTopEObjects.class;
        synchronized (LocalizableTopEObjects.class) {
            if (this.topObjectClasses != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.topObjectClasses.stream().map(Pair::getKey).collect(Collectors.toList());
            }
            this.initRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.topObjectClasses.stream().map(Pair::getKey).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<EClass> getBmEClass() {
        if (this.topObjectClasses != null) return this.topObjectClasses.stream().filter(Pair::getValue).map(Pair::getKey).collect(Collectors.toList());
        Class<LocalizableTopEObjects> clazz = LocalizableTopEObjects.class;
        synchronized (LocalizableTopEObjects.class) {
            if (this.topObjectClasses != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.topObjectClasses.stream().filter(Pair::getValue).map(Pair::getKey).collect(Collectors.toList());
            }
            this.initRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.topObjectClasses.stream().filter(Pair::getValue).map(Pair::getKey).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<EClass> getNonBmEClass() {
        if (this.topObjectClasses != null) return this.topObjectClasses.stream().filter(o -> (Boolean)o.getValue() == false).map(Pair::getKey).collect(Collectors.toList());
        Class<LocalizableTopEObjects> clazz = LocalizableTopEObjects.class;
        synchronized (LocalizableTopEObjects.class) {
            if (this.topObjectClasses != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.topObjectClasses.stream().filter(o -> (Boolean)o.getValue() == false).map(Pair::getKey).collect(Collectors.toList());
            }
            this.initRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.topObjectClasses.stream().filter(o -> (Boolean)o.getValue() == false).map(Pair::getKey).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<EPackage> getAllEPackages() {
        if (this.packages != null) return this.packages;
        Class<LocalizableTopEObjects> clazz = LocalizableTopEObjects.class;
        synchronized (LocalizableTopEObjects.class) {
            if (this.packages != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.packages;
            }
            this.initRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.packages;
        }
    }

    private void initRegistry() {
        Map<String, Set<Pair<String, Boolean>>> loaded = this.loadTopObjects();
        HashSet topObjects = Sets.newHashSet();
        HashSet ePackages = Sets.newHashSet();
        for (Map.Entry<String, Set<Pair<String, Boolean>>> entry : loaded.entrySet()) {
            String uri = entry.getKey();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
            if (ePackage == null) {
                DtPlugin.log(DtPlugin.createErrorStatus(MessageFormat.format("Localizable Top Object's EPackage for nsURI: {0} not found", uri), null));
                continue;
            }
            ePackages.add(ePackage);
            for (Pair<String, Boolean> className : entry.getValue()) {
                EClassifier eClassifier = ePackage.getEClassifier((String)className.getKey());
                if (eClassifier instanceof EClass) {
                    topObjects.add(new Pair((Object)((EClass)eClassifier), (Object)((Boolean)className.getValue())));
                    continue;
                }
                DtPlugin.log(DtPlugin.createErrorStatus(MessageFormat.format("Localizable Top Object's EClass name: {0} not found in nsURI: {1} ", className, uri), null));
            }
        }
        this.packages = ImmutableList.copyOf((Collection)ePackages);
        this.topObjectClasses = ImmutableList.copyOf((Collection)topObjects);
    }

    private Map<String, Set<Pair<String, Boolean>>> loadTopObjects() {
        HashMap result = Maps.newHashMap();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String uri = element.getAttribute(PACKAGE_URI);
            if (!StringUtils.isNullOrEmpty((String)uri)) {
                Set topObjects = result.computeIfAbsent(uri, k -> Sets.newHashSet());
                IConfigurationElement[] children = element.getChildren();
                int j = 0;
                while (j < children.length) {
                    IConfigurationElement child = children[j];
                    String className = child.getAttribute(TOP_OBJECT_CLASS_NAME_ATTR);
                    boolean isBm = Boolean.parseBoolean(child.getAttribute(TOP_OBJECT_BM_ATTR));
                    if (StringUtils.isNotEmpty((String)className)) {
                        topObjects.add(new Pair((Object)className, (Object)isBm));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }
}

