/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.storage;

import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.mcore.ContextDef;
import com._1c.g5.v8.dt.mcore.Ctor;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.Method;
import com._1c.g5.v8.dt.mcore.ParamSet;
import com._1c.g5.v8.dt.mcore.Parameter;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.Type;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.TypeSet;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.IEObjectProvider;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.storage.AbstractContextDefCache;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.IEObjectDescription;

public class ContextDefCache
extends AbstractContextDefCache {
    private static final String METADATA_OBJECT_ENUMERATED_PROPERTIES = "MetadataObjectEnumeratedProperties";
    private final IRuntimeVersionSupport runtimeVersionSupport;
    private final IConfigurationProvider configurationProvider;
    private final TranslationPreferences translationPreferences;
    protected volatile Map<String, String> translations = null;
    private volatile Map<String, Collection<String>> keysByValue;
    private volatile boolean initialized = false;

    @Inject
    public ContextDefCache(IRuntimeVersionSupport runtimeVersionSupport, IConfigurationProvider configurationProvider, TranslationPreferences translationPreferences) {
        this.runtimeVersionSupport = runtimeVersionSupport;
        this.configurationProvider = configurationProvider;
        this.translationPreferences = translationPreferences;
    }

    public synchronized void clear() {
        this.translations = null;
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(IProject project) {
        if (!this.initialized) {
            ContextDefCache contextDefCache = this;
            synchronized (contextDefCache) {
                this.init(project);
                this.initialized = true;
            }
        }
    }

    private void init(IProject project) {
        Type type;
        Object contexDef;
        EObject object;
        IEObjectDescription item2;
        if (this.initialized) {
            return;
        }
        Version version = this.runtimeVersionSupport.getRuntimeVersion(project);
        boolean checkBackTranslation = this.translationPreferences.getTranslationProperties(project).isContextDefStorageCheckBackTranslation();
        IEObjectProvider provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.TYPE_ITEM, version);
        Iterable items = provider.getEObjectDescriptions(null);
        HashMap builder = Maps.newHashMap();
        HashMap builder2 = Maps.newHashMap();
        Configuration context = this.configurationProvider.getConfiguration(project);
        boolean isRussian = context != null ? context.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN) : false;
        for (IEObjectDescription item2 : items) {
            EObject object2 = EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context);
            if (object2 instanceof Type) {
                Type type2 = (Type)object2;
                this.process(type2, (Map<String, Set<String>>)builder, (Map<String, Set<String>>)builder2, isRussian);
                continue;
            }
            if (!(object2 instanceof TypeSet)) continue;
            TypeSet typeSet = (TypeSet)object2;
            this.appendTranslation(builder, builder2, (DuallyNamedElement)typeSet, isRussian);
            for (Type type3 : typeSet.getTypes()) {
                this.process(type3, (Map<String, Set<String>>)builder, (Map<String, Set<String>>)builder2, isRussian);
            }
        }
        provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.METHOD, version);
        items = provider.getEObjectDescriptions(null);
        for (IEObjectDescription item2 : items) {
            object = EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context);
            if (!(object instanceof Method)) continue;
            Method method = (Method)object;
            this.appendTranslation(builder, builder2, (DuallyNamedElement)method, isRussian);
            for (Object paramSet : method.getParamSet()) {
                for (Parameter param : paramSet.getParams()) {
                    this.appendTranslation(builder, builder2, (DuallyNamedElement)param, isRussian);
                }
            }
        }
        provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.PROPERTY, version);
        items = provider.getEObjectDescriptions(null);
        for (IEObjectDescription item2 : items) {
            object = EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context);
            if (!(object instanceof Property)) continue;
            Property property = (Property)object;
            this.appendTranslation(builder, builder2, (DuallyNamedElement)property, isRussian);
            this.process(property, builder, builder2, isRussian, (EObject)context);
        }
        provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.TYPE_ITEM, version);
        item2 = provider.getEObjectDescription(METADATA_OBJECT_ENUMERATED_PROPERTIES);
        if (item2 != null && (contexDef = (type = (Type)EcoreUtil.resolve((EObject)item2.getEObjectOrProxy(), (EObject)context)).getContextDef()) != null) {
            for (Property property : contexDef.allProperties()) {
                this.process(property, builder, builder2, isRussian, (EObject)context);
            }
        }
        this.appendExtraTranslation(builder, builder2, isRussian);
        if (DtPlugin.DEBUG_CONTEXT_DEF) {
            System.out.println(MessageFormat.format("Total Trnaslations Count {0} ", builder.size()));
            for (Map.Entry entry : builder.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                System.out.println(MessageFormat.format("The Key {0} has multile translations: {1} ", entry.getKey(), entry.getValue()));
            }
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : builder.entrySet()) {
            if (((Set)entry.getValue()).size() != 1) continue;
            String translation = (String)((Set)entry.getValue()).iterator().next();
            Set list = (Set)builder2.get(translation);
            if (list.size() == 1 && ((String)list.iterator().next()).equals(entry.getKey()) || !checkBackTranslation) {
                treeMap.put((String)entry.getKey(), translation);
                continue;
            }
            if (!DtPlugin.DEBUG_CONTEXT_DEF) continue;
            System.out.println(MessageFormat.format("Translation {0} for key {1} has wrong back translation {2}", translation, entry.getKey(), list));
        }
        this.translations = treeMap;
        if (DtPlugin.DEBUG_CONTEXT_DEF) {
            System.out.println(MessageFormat.format("Used Translation Count {0} ", this.translations.size()));
        }
    }

    private void process(Property property, Map<String, Set<String>> builder, Map<String, Set<String>> builder2, boolean isRussian, EObject context) {
        if (property.getTypeContainer() == null) {
            return;
        }
        for (TypeItem propertyType : property.getTypes()) {
            EObject resolvedPropertyType = EcoreUtil.resolve((EObject)propertyType, (EObject)context);
            if (resolvedPropertyType instanceof Type) {
                Type type = (Type)resolvedPropertyType;
                this.process(type, builder, builder2, isRussian);
                continue;
            }
            if (!(resolvedPropertyType instanceof TypeSet)) continue;
            TypeSet typeSet = (TypeSet)resolvedPropertyType;
            this.appendTranslation(builder, builder2, (DuallyNamedElement)typeSet, isRussian);
            for (Type type : typeSet.getTypes()) {
                this.process(type, builder, builder2, isRussian);
            }
        }
    }

    public String get(String value) {
        if (value == null) {
            return null;
        }
        return this.translations.get(value);
    }

    private void process(Type type, Map<String, Set<String>> data, Map<String, Set<String>> opositeData, boolean isRussian) {
        if (type == null || type.eIsProxy()) {
            return;
        }
        this.appendTranslation(data, opositeData, (DuallyNamedElement)type, isRussian);
        for (Ctor ctor : type.getCtors()) {
            for (Parameter param : ctor.getParams()) {
                this.appendTranslation(data, opositeData, (DuallyNamedElement)param, isRussian);
            }
        }
        ContextDef contextDef = type.getContextDef();
        if (contextDef == null) {
            return;
        }
        for (Event event : type.allEvents()) {
            this.appendTranslation(data, opositeData, (DuallyNamedElement)event, isRussian);
            for (ParamSet paramSet : event.getParamSet()) {
                for (Parameter param : paramSet.getParams()) {
                    this.appendTranslation(data, opositeData, (DuallyNamedElement)param, isRussian);
                }
            }
        }
        this.process(contextDef, data, opositeData, isRussian);
    }

    private void process(ContextDef contextDef, Map<String, Set<String>> data, Map<String, Set<String>> opositeData, boolean isRussian) {
        for (Property property : contextDef.allProperties()) {
            this.appendTranslation(data, opositeData, (DuallyNamedElement)property, isRussian);
        }
        for (Method method : contextDef.allMethods()) {
            this.appendTranslation(data, opositeData, (DuallyNamedElement)method, isRussian);
            for (ParamSet paramSet : method.getParamSet()) {
                for (Parameter param : paramSet.getParams()) {
                    this.appendTranslation(data, opositeData, (DuallyNamedElement)param, isRussian);
                }
            }
        }
    }

    private void appendTranslation(Map<String, Set<String>> data, Map<String, Set<String>> opositeData, DuallyNamedElement element, boolean isRussian) {
        String translation;
        String source = isRussian ? element.getNameRu() : element.getName();
        String string = translation = isRussian ? element.getName() : element.getNameRu();
        if (StringUtils.isNotEmpty((String)source) && StringUtils.isNotEmpty((String)translation)) {
            this.process(data, opositeData, source, translation);
        }
    }

    private void appendExtraTranslation(Map<String, Set<String>> data, Map<String, Set<String>> opositeData, boolean isRussian) {
        Map<String, String> enumTokens = this.getExtraTerms(isRussian);
        for (Map.Entry<String, String> element : enumTokens.entrySet()) {
            this.process(data, opositeData, element.getKey(), element.getValue());
        }
    }

    private void process(Map<String, Set<String>> data, Map<String, Set<String>> opositeData, String source, String translation) {
        if (source != null && translation != null && !source.equalsIgnoreCase(translation)) {
            source = source.trim();
            translation = translation.trim();
            Set list = data.computeIfAbsent(source, this::createUsageData);
            list.add(translation);
            Set list2 = opositeData.computeIfAbsent(translation, this::createUsageData);
            list2.add(source);
        }
    }

    private Set<String> createUsageData(String key) {
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    public boolean hasKeyForValue(String value, String skipKey) {
        if (value == null) {
            return false;
        }
        if (skipKey == null) {
            return this.translations.containsValue(value);
        }
        Collection<String> keys = this.getKeysByValue().get(value);
        return keys != null && (keys.size() > 1 || !keys.contains(skipKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<String>> getKeysByValue() {
        if (this.keysByValue == null) {
            ContextDefCache contextDefCache = this;
            synchronized (contextDefCache) {
                if (this.keysByValue != null) {
                    return this.keysByValue;
                }
                ConcurrentSkipListMap<String, Collection<String>> cache = new ConcurrentSkipListMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry<String, String> entry : this.translations.entrySet()) {
                    Collection keys = cache.computeIfAbsent(entry.getValue(), k -> new TreeSet(String.CASE_INSENSITIVE_ORDER));
                    keys.add(entry.getKey());
                }
                this.keysByValue = cache;
            }
        }
        return this.keysByValue;
    }
}

