/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.storage;

import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.storage.ContextDefCache;
import com.e1c.langtool.v8.dt.storage.ContextDefDtCacheProvider;
import com.google.common.hash.HashFunction;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

public class ContextDefStorage
implements ITranslationStorageProvider.DictionaryStorage {
    private static final String LANG_CODE_ENG = "en";
    private static final String LANG_CODE_RUS = "ru";
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private ContextDefDtCacheProvider contextDefCacheProvider;
    private StorageID id;
    private volatile boolean isRussian;
    private volatile IProject project;
    private Version version;

    public StorageID getId() {
        if (this.id == null) {
            this.id = new StorageID("com.e1c.langtool.v8.dt.storage", "platform");
        }
        return this.id;
    }

    public String getSegment() {
        return this.getId().getSegment();
    }

    public void addValueChangedListener(IStorageValueChangedListener listener) {
    }

    public void removeValueChangedListener(IStorageValueChangedListener listener) {
    }

    public String getTranslation(TranslationKey key, TranslateLanguage language) {
        if (!key.getFeatureSettings().isModel() || key.getValue() == null) {
            return "";
        }
        if (this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_ENG) || !this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_RUS)) {
            ContextDefCache cache = this.contextDefCacheProvider.getCache(this.project);
            if (cache != null) {
                String translation = cache.get(key.getValue());
                if (translation != null) {
                    return translation;
                }
                if (DtPlugin.DEBUG_CONTEXT_DEF && (cache.translations == null || cache.translations.isEmpty())) {
                    String message = MessageFormat.format("Translation storage {0}  ContextDefCache is empty for project \"{1}\" translation not found for key: \"{2}\" and language code: \"{3}\"", this.getId(), this.project, key.getValue(), language.getLanguageCode());
                    IStatus status = DtPlugin.createWarningStatus(message);
                    DtPlugin.log(status);
                }
            } else if (DtPlugin.DEBUG_CONTEXT_DEF) {
                String message = MessageFormat.format("Translation storage {0} requested ContextDefCache for project \"{1}\" and language code: \"{2}\" but not found", this.getId(), this.project, language.getLanguageCode());
                IStatus status = DtPlugin.createWarningStatus(message);
                DtPlugin.log(status);
            }
        }
        return "";
    }

    public void setTranslation(TranslationKey source, TranslateLanguage language, String translation, boolean autoSave) {
    }

    public void removeTranslation(TranslationKey source, TranslateLanguage language, boolean autoSave) {
    }

    public void moveTranslation(TranslationKey fromSource, TranslationKey toSource, TranslateLanguage language, boolean autoSave) {
    }

    public ITranslationStorageProvider.Storage.Type getType() {
        return ITranslationStorageProvider.Storage.Type.COMMON;
    }

    public void beginBatchUpdate() {
    }

    public void endBatchUpdate() {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void initialize(IProject project) {
        this.project = project;
    }

    public Map<IFile, byte[]> saveFiles(TranslateLanguage language, HashFunction hashFunction) {
        return null;
    }

    private boolean isRussian() {
        if (this.version == null) {
            this.version = this.runtimeVersionSupport.getRuntimeVersion(this.project);
            IV8Project v8project = this.v8ProjectManager.getProject(this.project);
            if (this.version == null || v8project == null) {
                return false;
            }
            this.isRussian = v8project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        }
        return this.isRussian;
    }

    public boolean hasKeyForValue(String value, TranslateLanguage language, TranslationKey skipKey) {
        ContextDefCache cache;
        if (skipKey != null && !skipKey.getFeatureSettings().isModel()) {
            return false;
        }
        if ((this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_ENG) || !this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_RUS)) && (cache = this.contextDefCacheProvider.getCache(this.project)) != null) {
            String key = skipKey == null ? null : skipKey.getValue();
            return cache.hasKeyForValue(value, key);
        }
        return false;
    }
}

