/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.storage;

import com.e1c.langtool.storage.IProjectStorageSettingsConfigurator;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.FeatureSettingsFilter;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.RuleSettings;
import com.e1c.langtool.storage.model.StorageIdList;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.storage.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class V8ProjectStorageConfigurator
implements IProjectStorageSettingsConfigurator {
    private static final String COMMON_COMMON = "com.e1c.langtool.v8.dt.resourcestorage.common:common";
    private static final String COMMON_PREFIX = "com.e1c.langtool.v8.dt.resourcestorage.common:";
    private static final String CONTEXT_TRANS = "com.e1c.langtool.v8.dt.resourcestorage.context:trans";
    private static final String COMPOSITE_TRANS = "com.e1c.langtool.v8.dt.resourcestorage.composite:trans";
    private static final String FILE_EXTENSION_INTERFACE = "lstr";
    private static final String FILE_EXTENSION_INTERFACE_NSTR = "nstr";
    private static final String FILE_EXTENSION_DICT_INTERFACE = "lsdict";
    private static final String FILE_EXTENSION_MODEL = "trans";
    private static final String FILE_EXTENSION_REGEX = "yml";
    private static final IPath PATH_SRC = new Path("src");

    public boolean canConfigure(IProject project) {
        try {
            return project.isAccessible() && (project.hasNature("com._1c.g5.v8.dt.core.V8ConfigurationNature") || project.hasNature("com._1c.g5.v8.dt.core.V8ExtensionNature") || project.hasNature("com._1c.g5.v8.dt.core.V8ExternalObjectsNature"));
        }
        catch (CoreException e) {
            DtPlugin.logError(e);
            return false;
        }
    }

    public void configureNewSettings(IProject project, ProjectStorageSettings storageSettings) {
        if (storageSettings.getRead().isEmpty() && storageSettings.getEdit().getStorages().isEmpty() && storageSettings.getEdit().getRules().isEmpty()) {
            this.configureNew(storageSettings);
        } else {
            this.migrateOldSettings(project, storageSettings);
        }
    }

    private void configureNew(ProjectStorageSettings storageSettings) {
        RuleSettings preferContexRule = new RuleSettings();
        preferContexRule.setId("prefer-context");
        preferContexRule.getWhen().put("prefercontext", Boolean.TRUE.toString());
        storageSettings.getEdit().addRule(preferContexRule);
        ContextStorageSettings interfaceContextSettings = this.createContextInterface();
        storageSettings.addContext(interfaceContextSettings);
        storageSettings.getRead().add(interfaceContextSettings.getStorageId());
        preferContexRule.getStorages().add(interfaceContextSettings.getStorageId());
        ContextStorageSettings modelContextSettings = this.createContextModel();
        storageSettings.addContext(modelContextSettings);
        storageSettings.getRead().add(modelContextSettings.getStorageId());
        preferContexRule.getStorages().add(modelContextSettings.getStorageId());
        RuleSettings otherRule = new RuleSettings();
        otherRule.setId("other");
        storageSettings.getEdit().addRule(otherRule);
        DictionaryStorageSettings dictionarySettings = new DictionaryStorageSettings("common-camelcase");
        dictionarySettings.setPresentation(Messages.V8ProjectStorageConfigurator_Model_common_CamelCase_idenitfiers);
        dictionarySettings.setFormat("dict");
        dictionarySettings.setFilePath(PATH_SRC.append(dictionarySettings.getId()).toString());
        dictionarySettings.setFeatureFilter(Map.of("model", FeatureSettingsFilter.ONLY, "camelcase", FeatureSettingsFilter.ONLY));
        storageSettings.addDictionary(dictionarySettings);
        storageSettings.getRead().add(dictionarySettings.getStorageId());
        otherRule.getStorages().add(dictionarySettings.getStorageId());
        dictionarySettings = new DictionaryStorageSettings("common");
        dictionarySettings.setPresentation(Messages.V8ProjectStorageConfigurator_Model_common_non_CamelCase_translations);
        dictionarySettings.setFormat("dict");
        dictionarySettings.setFilePath(PATH_SRC.append(dictionarySettings.getId()).toString());
        dictionarySettings.setFeatureFilter(Map.of("model", FeatureSettingsFilter.ONLY, "camelcase", FeatureSettingsFilter.NONE));
        storageSettings.addDictionary(dictionarySettings);
        storageSettings.getRead().add(dictionarySettings.getStorageId());
        otherRule.getStorages().add(dictionarySettings.getStorageId());
        dictionarySettings = this.createCommonInterface();
        storageSettings.addDictionary(dictionarySettings);
        storageSettings.getRead().add(dictionarySettings.getStorageId());
        otherRule.getStorages().add(dictionarySettings.getStorageId());
    }

    private DictionaryStorageSettings createCommonInterface() {
        DictionaryStorageSettings settings = new DictionaryStorageSettings("common-interface");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Interface_common_translations);
        settings.setFormat("dict");
        settings.setFileExtension(FILE_EXTENSION_DICT_INTERFACE);
        settings.setFilePath(PATH_SRC.append("common").toString());
        settings.setFeatureFilter(Map.of("interface", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private DictionaryStorageSettings createCommonInterface(String segment) {
        DictionaryStorageSettings settings = new DictionaryStorageSettings("interface-" + segment);
        settings.setPresentation(MessageFormat.format(Messages.V8ProjectStorageConfigurator_Interface_common_translations__S, segment));
        settings.setFormat("dict");
        settings.setFileExtension(FILE_EXTENSION_DICT_INTERFACE);
        settings.setFilePath(PATH_SRC.append(segment).toString());
        settings.setFeatureFilter(Map.of("interface", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private DictionaryStorageSettings createCommonModelLegacy() {
        DictionaryStorageSettings settings = new DictionaryStorageSettings("common-legacy");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Model_common_translations);
        settings.setFormat("dict");
        settings.setFilePath(PATH_SRC.append("common").toString());
        settings.setFeatureFilter(Map.of("model", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private DictionaryStorageSettings createCommonModelLegacy(String segment) {
        DictionaryStorageSettings settings = new DictionaryStorageSettings("model-" + segment);
        settings.setPresentation(MessageFormat.format(Messages.V8ProjectStorageConfigurator_Model_common_translations__S, segment));
        settings.setFormat("dict");
        settings.setFilePath(PATH_SRC.append(segment).toString());
        settings.setFeatureFilter(Map.of("model", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private DictionaryStorageSettings createCommonRegeEx(String segment) {
        DictionaryStorageSettings settings = new DictionaryStorageSettings("regex-" + segment);
        settings.setPresentation(MessageFormat.format(Messages.V8ProjectStorageConfigurator_Smart_RegEx_translations__S, segment));
        settings.setFormat("dict-regex");
        settings.setFileExtension(FILE_EXTENSION_REGEX);
        settings.setFilePath(PATH_SRC.append(segment + "_regex").toString());
        settings.setReadOnly(Boolean.valueOf(true));
        return settings;
    }

    private ContextStorageSettings createContextModel() {
        ContextStorageSettings settings = new ContextStorageSettings("model");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Model_context_translations);
        settings.setFormat("properties");
        settings.setFileExtension(FILE_EXTENSION_MODEL);
        settings.setFeatureFilter(Map.of("model", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private ContextStorageSettings createContextModelMdoLegacy() {
        ContextStorageSettings settings = new ContextStorageSettings("model-mdo-legacy");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Model_context_Metadata_translations);
        settings.setFormat("properties");
        settings.setFileExtension(FILE_EXTENSION_MODEL);
        settings.setFeatureFilter(Map.of("model", FeatureSettingsFilter.ONLY));
        settings.setSettings(Map.of("replace_file_name", "mdo"));
        return settings;
    }

    private ContextStorageSettings createContextInterface() {
        ContextStorageSettings settings = new ContextStorageSettings("interface");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Interface_context_translations);
        settings.setFormat("properties");
        settings.setFileExtension(FILE_EXTENSION_INTERFACE);
        settings.setFeatureFilter(Map.of("interface", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private ContextStorageSettings createContextInterfaceMdoLegacy() {
        ContextStorageSettings settings = new ContextStorageSettings("interface-mdo-legacy");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Interface_context_Metadata_translations);
        settings.setFormat("properties");
        settings.setFileExtension(FILE_EXTENSION_INTERFACE);
        settings.setFeatureFilter(Map.of("interface", FeatureSettingsFilter.ONLY));
        settings.setSettings(Map.of("replace_file_name", "mdo"));
        return settings;
    }

    private ContextStorageSettings createContextInterfaceBslLegacy() {
        ContextStorageSettings settings = new ContextStorageSettings("interface-bsl-legacy");
        settings.setPresentation(Messages.V8ProjectStorageConfigurator_Interface_context_module_Nstr_translations);
        settings.setFormat("properties");
        settings.setFileExtension(FILE_EXTENSION_INTERFACE_NSTR);
        settings.setFeatureFilter(Map.of("interface", FeatureSettingsFilter.ONLY));
        return settings;
    }

    private RuleSettings createModuleNstrRule() {
        RuleSettings rule = new RuleSettings();
        rule.setId("module-nstr");
        rule.getWhen().put("resource_path_regex", ".*\\.bsl$");
        return rule;
    }

    private RuleSettings createMdoContextRule() {
        RuleSettings rule = new RuleSettings();
        rule.setId("mdo");
        rule.getWhen().put("resource_path_regex", ".*\\.mdo$");
        return rule;
    }

    private RuleSettings createOtherRule() {
        RuleSettings rule = new RuleSettings();
        rule.setId("other");
        return rule;
    }

    private RuleSettings createPreferContextMdoContextRule() {
        RuleSettings rule = new RuleSettings();
        rule.setId("prefercontext-mdo");
        rule.getWhen().put("prefercontext", Boolean.TRUE.toString());
        rule.getWhen().put("resource_path_regex", ".*\\.mdo$");
        return rule;
    }

    private RuleSettings createPreferContextOtherRule() {
        RuleSettings rule = new RuleSettings();
        rule.setId("prefercontext-other");
        rule.getWhen().put("prefercontext", Boolean.TRUE.toString());
        return rule;
    }

    private void migrateOldSettings(IProject project, ProjectStorageSettings storageSettings) {
        boolean editContext = storageSettings.getEdit().getStorages().contains((Object)CONTEXT_TRANS);
        boolean editCommon = storageSettings.getEdit().getStorages().contains((Object)COMMON_COMMON);
        boolean editComposite = storageSettings.getEdit().getStorages().contains((Object)COMPOSITE_TRANS);
        if (editContext || editCommon || editComposite) {
            storageSettings.getEdit().getStorages().clear();
            storageSettings.getEdit().setRules(new ArrayList());
        }
        StorageIdList newReadOrder = new StorageIdList();
        Iterator iterator = storageSettings.getRead().iterator();
        while (iterator.hasNext()) {
            String id;
            switch (id = (String)iterator.next()) {
                case "com.e1c.langtool.v8.dt.resourcestorage.context:trans": {
                    ContextStorageSettings settings1 = this.createContextInterface();
                    storageSettings.addContext(settings1);
                    newReadOrder.add(settings1.getStorageId());
                    ContextStorageSettings settings2 = this.createContextModel();
                    storageSettings.addContext(settings2);
                    newReadOrder.add(settings2.getStorageId());
                    ContextStorageSettings settings3 = this.createContextInterfaceMdoLegacy();
                    storageSettings.addContext(settings3);
                    newReadOrder.add(settings3.getStorageId());
                    ContextStorageSettings settings4 = this.createContextModelMdoLegacy();
                    storageSettings.addContext(settings4);
                    newReadOrder.add(settings4.getStorageId());
                    if (editContext) {
                        RuleSettings rule = this.createMdoContextRule();
                        rule.getStorages().add(settings3.getStorageId());
                        rule.getStorages().add(settings4.getStorageId());
                        storageSettings.getEdit().addRule(rule);
                    }
                    ContextStorageSettings settings5 = this.createContextInterfaceBslLegacy();
                    storageSettings.addContext(settings5);
                    newReadOrder.add(settings5.getStorageId());
                    if (editContext) {
                        RuleSettings rule = this.createModuleNstrRule();
                        rule.getStorages().add(settings5.getStorageId());
                        storageSettings.getEdit().addRule(rule);
                        RuleSettings rule2 = this.createOtherRule();
                        rule2.getStorages().add(settings1.getStorageId());
                        rule2.getStorages().add(settings2.getStorageId());
                        storageSettings.getEdit().addRule(rule2);
                    }
                    storageSettings.getStorages().remove(id);
                    break;
                }
                case "com.e1c.langtool.v8.dt.resourcestorage.common:common": {
                    DictionaryStorageSettings settings6 = this.createCommonInterface();
                    storageSettings.addDictionary(settings6);
                    newReadOrder.add(settings6.getStorageId());
                    DictionaryStorageSettings settings7 = this.createCommonModelLegacy();
                    storageSettings.addDictionary(settings7);
                    newReadOrder.add(settings7.getStorageId());
                    DictionaryStorageSettings settings71 = this.createCommonRegeEx("common");
                    storageSettings.addDictionary(settings71);
                    newReadOrder.add(settings71.getStorageId());
                    if (editCommon) {
                        storageSettings.getEdit().getStorages().add(settings6.getStorageId());
                        storageSettings.getEdit().getStorages().add(settings7.getStorageId());
                    }
                    storageSettings.getStorages().remove(id);
                    break;
                }
                case "com.e1c.langtool.v8.dt.resourcestorage.composite:trans": {
                    ContextStorageSettings settings8 = this.createContextInterface();
                    storageSettings.addContext(settings8);
                    newReadOrder.add(settings8.getStorageId());
                    ContextStorageSettings settings9 = this.createContextModel();
                    storageSettings.addContext(settings9);
                    newReadOrder.add(settings9.getStorageId());
                    ContextStorageSettings settings10 = this.createContextInterfaceMdoLegacy();
                    storageSettings.addContext(settings10);
                    newReadOrder.add(settings10.getStorageId());
                    ContextStorageSettings settings11 = this.createContextModelMdoLegacy();
                    storageSettings.addContext(settings11);
                    newReadOrder.add(settings11.getStorageId());
                    if (editComposite) {
                        RuleSettings mdoContextRule = this.createPreferContextMdoContextRule();
                        storageSettings.getEdit().addRule(mdoContextRule);
                        mdoContextRule.getStorages().add(settings10.getStorageId());
                        mdoContextRule.getStorages().add(settings11.getStorageId());
                        RuleSettings rule = this.createMdoContextRule();
                        rule.getStorages().add(settings10.getStorageId());
                        storageSettings.getEdit().addRule(rule);
                    }
                    ContextStorageSettings settings12 = this.createContextInterfaceBslLegacy();
                    storageSettings.addContext(settings12);
                    newReadOrder.add(settings12.getStorageId());
                    DictionaryStorageSettings settings13 = this.createCommonInterface();
                    storageSettings.addDictionary(settings13);
                    newReadOrder.add(settings13.getStorageId());
                    DictionaryStorageSettings settings14 = this.createCommonModelLegacy();
                    storageSettings.addDictionary(settings14);
                    newReadOrder.add(settings14.getStorageId());
                    DictionaryStorageSettings settings141 = this.createCommonRegeEx("common");
                    storageSettings.addDictionary(settings141);
                    newReadOrder.add(settings141.getStorageId());
                    if (editComposite) {
                        RuleSettings rule = this.createModuleNstrRule();
                        rule.getStorages().add(settings12.getStorageId());
                        storageSettings.getEdit().addRule(rule);
                        RuleSettings otherContextRule = this.createPreferContextOtherRule();
                        storageSettings.getEdit().addRule(otherContextRule);
                        otherContextRule.getStorages().add(settings8.getStorageId());
                        otherContextRule.getStorages().add(settings9.getStorageId());
                        RuleSettings rule2 = this.createOtherRule();
                        rule2.getStorages().add(settings14.getStorageId());
                        rule2.getStorages().add(settings13.getStorageId());
                        storageSettings.getEdit().addRule(rule2);
                    }
                    storageSettings.getStorages().remove(id);
                    break;
                }
                default: {
                    if (id != null && id.startsWith(COMMON_PREFIX)) {
                        String segment = id.substring(COMMON_PREFIX.length());
                        DictionaryStorageSettings settings15 = this.createCommonInterface(segment);
                        storageSettings.addDictionary(settings15);
                        newReadOrder.add(settings15.getStorageId());
                        DictionaryStorageSettings settings16 = this.createCommonModelLegacy(segment);
                        storageSettings.addDictionary(settings16);
                        newReadOrder.add(settings16.getStorageId());
                        DictionaryStorageSettings settings161 = this.createCommonRegeEx(segment);
                        storageSettings.addDictionary(settings161);
                        newReadOrder.add(settings161.getStorageId());
                        if (storageSettings.getEdit().getStorages().contains((Object)id)) {
                            storageSettings.getEdit().getStorages().remove((Object)id);
                            storageSettings.getEdit().getStorages().add(settings15.getStorageId());
                            storageSettings.getEdit().getStorages().add(settings16.getStorageId());
                        }
                        storageSettings.getStorages().remove(id);
                        break;
                    }
                    newReadOrder.add(id);
                }
            }
        }
        storageSettings.setRead(newReadOrder);
    }
}

