/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.validation;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.validation.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SingleLineModelValidator
implements FeatureValueValidator {
    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        if (this.isMultilineForSinleLine(value, context)) {
            return DtPlugin.createErrorStatus(Messages.SingleLineModelValidator_Value_has_more_than_one_line, null);
        }
        return Status.OK_STATUS;
    }

    public String preprocessValue(String value, FeatureValueValidator.ValidationContext context) {
        if (this.isMultilineForSinleLine(value, context)) {
            return value.trim();
        }
        return value;
    }

    private boolean isMultilineForSinleLine(String value, FeatureValueValidator.ValidationContext context) {
        FeatureSettings settings = context.getTranslationKey().getFeatureSettings();
        if (settings.isModel() && !settings.isMultiLine() && StringUtils.isNotEmpty((String)value)) {
            long valueCount = value.lines().count();
            return valueCount > 1L;
        }
        return false;
    }
}

